/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.comm.lowlevel;

import com.browsersoft.config.jgate.comm.lowlevel.Receiver;
import com.browsersoft.config.jgate.comm.lowlevel.ReceiverHandler;
import com.browsersoft.config.jgate.comm.lowlevel.SocketReceiverMainThread;
import com.browsersoft.config.jgate.comm.lowlevel.SocketReceiverThread;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateClientInfo;
import com.browsersoft.config.jgate.comm.middlelevel.response.GateResponse;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.util.GateUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.LinkedList;

public class SocketReceiver
implements Receiver {
    private ReceiverHandler handler;
    private SocketReceiverMainThread socketReceiverMainThread;
    private final LinkedList<SocketReceiverThread> clients = new LinkedList();

    public SocketReceiver(int port, GateNodeConfiguration configuration) throws Exception {
        this.socketReceiverMainThread = new SocketReceiverMainThread(this, port, configuration);
        this.socketReceiverMainThread.start();
    }

    public SocketReceiver(int port, GateNodeConfiguration configuration, File keyStoreFile, String ksPass, String crPass, boolean useTLS) {
        this.socketReceiverMainThread = new SocketReceiverMainThread(this, port, configuration, keyStoreFile, ksPass, crPass, useTLS);
        this.socketReceiverMainThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void stopReceiving() throws Exception {
        this.socketReceiverMainThread.close();
        this.socketReceiverMainThread.stop();
        LinkedList<SocketReceiverThread> linkedList = this.clients;
        synchronized (linkedList) {
            while (this.clients.size() > 0) {
                SocketReceiverThread client = this.clients.poll();
                try {
                    client.close();
                }
                catch (IOException iOException) {}
            }
            return;
        }
    }

    @Override
    public ReceiverHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(ReceiverHandler handler) {
        this.handler = handler;
    }

    public byte[] receiveBytes(SocketAddress remoteSocketAddress, InputStream inputStream) throws Exception {
        GateClientInfo gateClientInfo = this.createGateClientInfo(remoteSocketAddress);
        GateResponse response = this.handler.incomingBytes(gateClientInfo, inputStream);
        return GateUtils.serializeObjectToByteArray(response);
    }

    protected GateClientInfo createGateClientInfo(SocketAddress remoteSocketAddress) {
        GateClientInfo gateClientInfo = new GateClientInfo();
        if (remoteSocketAddress != null) {
            // empty if block
        }
        return gateClientInfo;
    }

    public byte[] receiveBytesForInputStream(SocketAddress remoteSocketAddress, InputStream callInputStream, OutputStream outputStream) throws Exception {
        GateClientInfo gateClientInfo = this.createGateClientInfo(remoteSocketAddress);
        return this.handler.incomingBytesForInputStream(gateClientInfo, callInputStream, outputStream);
    }

    public byte[] receiveBytesForOutputStream(SocketAddress remoteSocketAddress, InputStream callInputStream, InputStream inputStream) throws Exception {
        GateClientInfo gateClientInfo = this.createGateClientInfo(remoteSocketAddress);
        return this.handler.incomingBytesForOutputStream(gateClientInfo, callInputStream, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClient(SocketReceiverThread clientThread) {
        LinkedList<SocketReceiverThread> linkedList = this.clients;
        synchronized (linkedList) {
            this.clients.add(clientThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClient(SocketReceiverThread clientThread) {
        LinkedList<SocketReceiverThread> linkedList = this.clients;
        synchronized (linkedList) {
            if (this.clients.contains(clientThread)) {
                this.clients.remove(clientThread);
            }
        }
    }
}

