/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.comm.lowlevel;

import com.browsersoft.config.jgate.comm.lowlevel.RequestType;
import com.browsersoft.config.jgate.comm.lowlevel.SizeLimitInputStream;
import com.browsersoft.config.jgate.comm.lowlevel.SocketReceiver;
import com.browsersoft.config.jgate.comm.lowlevel.SocketSender;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SocketReceiverThread
extends Thread {
    private Socket socket;
    private SocketReceiver socketReceiver;

    public SocketReceiverThread(Socket socket, SocketReceiver socketReceiver) {
        this.socket = socket;
        this.socketReceiver = socketReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.socketReceiver.registerClient(this);
        try {
            BufferedInputStream inputStream = new BufferedInputStream(this.socket.getInputStream());
            BufferedOutputStream socketOutputStream = new BufferedOutputStream(this.socket.getOutputStream());
            int requestType = ((InputStream)inputStream).read();
            boolean first = true;
            if (requestType == RequestType.NORMAL) {
                while (true) {
                    long streamLength;
                    if (!first) {
                        ((InputStream)inputStream).read();
                    }
                    if ((streamLength = SocketReceiverThread.readLength(inputStream)) > 1L) {
                        byte[] bytes = this.socketReceiver.receiveBytes(null, new SizeLimitInputStream(inputStream, streamLength));
                        SocketReceiverThread.writeBytesWithLength(socketOutputStream, bytes);
                    } else {
                        ((InputStream)inputStream).read();
                        SocketReceiverThread.writeBytesWithLength(socketOutputStream, new byte[1]);
                    }
                    first = false;
                }
            }
            if (requestType == RequestType.READ_FROM_INPUTSTREAM) {
                long streamLength = SocketReceiverThread.readLength(inputStream);
                byte[] bytes = this.socketReceiver.receiveBytesForInputStream(null, new SizeLimitInputStream(inputStream, streamLength), socketOutputStream);
                if (bytes.length > 0) {
                    SocketReceiverThread.writeBytesWithLength(socketOutputStream, bytes);
                }
            } else if (requestType == RequestType.WRITE_TO_OUTPUTSTREAM) {
                long streamLength = SocketReceiverThread.readLength(inputStream);
                byte[] bytes = this.socketReceiver.receiveBytesForOutputStream(null, new SizeLimitInputStream(inputStream, streamLength), inputStream);
                SocketReceiverThread.writeBytesWithLength(socketOutputStream, bytes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.socketReceiver.unregisterClient(this);
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public static void writeBytesWithLength(OutputStream outputStreams, byte[] bytes) throws IOException {
        outputStreams.write(SocketSender.longToBytes(bytes.length));
        outputStreams.write(bytes);
        outputStreams.flush();
    }

    public static long readLength(InputStream inputStream) throws IOException {
        byte[] lengthBuffer = new byte[8];
        inputStream.read(lengthBuffer);
        return SocketSender.bytesToLong(lengthBuffer);
    }
}

