/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.comm.lowlevel;

import com.browsersoft.config.jgate.comm.lowlevel.Constants;
import com.browsersoft.config.jgate.comm.lowlevel.RequestType;
import com.browsersoft.config.jgate.comm.lowlevel.Sender;
import com.browsersoft.config.jgate.comm.lowlevel.SizeLimitInputStream;
import com.browsersoft.config.jgate.comm.lowlevel.SocketReceiverThread;
import com.browsersoft.config.jgate.comm.lowlevel.StreamsPair;
import com.browsersoft.config.jgate.comm.lowlevel.XTrustProvider;
import com.browsersoft.config.jgate.util.Arrays;
import com.browsersoft.config.jgate.util.GateUtils;
import com.browsersoft.config.jgate.util.KeyStore;
import com.browsersoft.config.utils.streams.SizedInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.Security;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SocketSender
implements Sender {
    private String remoteHost;
    private int remotePort;
    private boolean ssl;
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private int dummyRequestTimePeriod;
    private KeyStore keyStore;

    public SocketSender(String remoteHost, int remotePort, boolean ssl, int dummyRequestTimePeriod) throws IOException {
        this(remoteHost, remotePort, ssl, dummyRequestTimePeriod, null);
    }

    public SocketSender(String remoteHost, int remotePort, boolean ssl, final int dummyRequestTimePeriod, KeyStore keyStore) throws IOException {
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        this.dummyRequestTimePeriod = dummyRequestTimePeriod;
        this.ssl = ssl;
        this.keyStore = keyStore;
        this.reconnect();
        if (dummyRequestTimePeriod > 0) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(dummyRequestTimePeriod);
                                InputStream inputStream = SocketSender.this.sendBytes(new byte[1]);
                                inputStream.read();
                                inputStream.close();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() throws IOException {
        SocketSender socketSender = this;
        synchronized (socketSender) {
            this.socket = this.connect();
            this.inputStream = new BufferedInputStream(this.socket.getInputStream());
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
        }
    }

    private Socket connect() throws IOException {
        Socket socket;
        if (!this.ssl) {
            socket = new Socket(this.remoteHost, this.remotePort);
        } else {
            SocketFactory factory;
            if (this.keyStore != null) {
                try {
                    SSLContext sslContext = this.keyStore.createSSLContext("TLS");
                    factory = sslContext.getSocketFactory();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            } else {
                Security.insertProviderAt(new XTrustProvider(), 2);
                factory = SSLSocketFactory.getDefault();
            }
            socket = factory.createSocket(this.remoteHost, this.remotePort);
            if (socket instanceof SSLSocket) {
                SSLSocket sslSocket = (SSLSocket)socket;
                String[] enabledProtocols = Arrays.intersection(sslSocket.getEnabledProtocols(), Constants.enabledProtocols);
                if (enabledProtocols.length == 0) {
                    enabledProtocols = new String[]{"TLSv1.2"};
                }
                sslSocket.setEnabledProtocols(enabledProtocols);
            }
        }
        socket.setTcpNoDelay(true);
        return socket;
    }

    @Override
    public synchronized StreamsPair writeToOutputStream(byte[] bytes) throws Exception {
        Socket socket = this.connect();
        BufferedInputStream inputStream = new BufferedInputStream(socket.getInputStream());
        BufferedOutputStream socketOutputStream = new BufferedOutputStream(socket.getOutputStream());
        this.send(socketOutputStream, bytes, RequestType.WRITE_TO_OUTPUTSTREAM);
        return new StreamsPair(socket.getInputStream(), socketOutputStream);
    }

    @Override
    public synchronized SizedInputStream readFromInputStream(byte[] bytes) throws Exception {
        Socket socket = this.connect();
        socket.setSoTimeout(0);
        BufferedInputStream inputStream = new BufferedInputStream(socket.getInputStream());
        BufferedOutputStream outputStream = new BufferedOutputStream(socket.getOutputStream());
        this.send(outputStream, bytes, RequestType.READ_FROM_INPUTSTREAM);
        long length = SocketReceiverThread.readLength(inputStream);
        return new SizedInputStream((InputStream)inputStream, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object sendBytesAndReturnObject(byte[] bytes) throws Exception {
        SocketSender socketSender = this;
        synchronized (socketSender) {
            InputStream response = this.sendBytes(bytes);
            return GateUtils.deserializeInputStreamToObject(response);
        }
    }

    @Override
    public synchronized InputStream sendBytes(byte[] bytes) throws Exception {
        this.send(this.outputStream, bytes, RequestType.NORMAL);
        return new SizeLimitInputStream(this.inputStream, SocketReceiverThread.readLength(this.inputStream));
    }

    private void send(OutputStream outputStream, byte[] bytes, int requestType) throws IOException {
        outputStream.write(requestType);
        outputStream.write(SocketSender.longToBytes(bytes.length));
        outputStream.write(bytes);
        outputStream.flush();
    }

    @Override
    public String getId() {
        return null;
    }

    public static byte[] longToBytes(long l) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return result;
    }

    public static long bytesToLong(byte[] b) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }
}

