/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.node;

import com.browsersoft.config.jgate.annotations.GateMethod;
import com.browsersoft.config.jgate.annotations.HandleProgress;
import com.browsersoft.config.jgate.annotations.LogIt;
import com.browsersoft.config.jgate.annotations.UserName;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateClientInfo;
import com.browsersoft.config.jgate.comm.middlelevel.base.MethodCalling;
import com.browsersoft.config.jgate.exceptions.GateAutheticationException;
import com.browsersoft.config.jgate.exceptions.GateMethodInvocationException;
import com.browsersoft.config.jgate.external.Logger;
import com.browsersoft.config.jgate.external.RuleResolver;
import com.browsersoft.config.jgate.proxy.ServiceCallMethodHandler;
import com.browsersoft.config.jgate.util.GateUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ServiceWrapper {
    private Object service;
    private Map<String, Method> methods = new HashMap<String, Method>();
    private Logger logger;
    private RuleResolver ruleResolver;
    private String proxyClass;
    private String instanceName;
    private ClassLoader classLoader;

    public ServiceWrapper(Object object) throws IllegalArgumentException {
        Method[] methodsArray;
        this.service = object;
        for (Method method : methodsArray = object.getClass().getMethods()) {
            GateMethod gateMethodAnotation = method.getAnnotation(GateMethod.class);
            if (gateMethodAnotation == null) continue;
            String methodName = method.getName();
            if (this.methods.containsKey(methodName)) {
                throw new IllegalArgumentException("Server object contains methods with the same name: \"" + methodName + "\".");
            }
            this.methods.put(method.getName(), method);
        }
    }

    public Object callMethod(GateClientInfo gateClientInfo, MethodCalling methodCalling, ServiceCallMethodHandler handler) throws Exception {
        String method = methodCalling.getMethod();
        Object[] params = methodCalling.getParams(this.classLoader);
        String user = methodCalling.getUser();
        String password = methodCalling.getPassword();
        if (this.methods.containsKey(method)) {
            Method methodObject = this.methods.get(method);
            LogIt logItAnnotation = methodObject.getAnnotation(LogIt.class);
            if (this.ruleResolver != null && !this.ruleResolver.checkMethod(gateClientInfo, methodObject, params, user, password)) {
                String message = "Acces denied for method \"" + method + "\"";
                if (logItAnnotation != null) {
                    this.logIt(1, null, message, methodObject, params, user, password);
                }
                throw new GateAutheticationException(message);
            }
            try {
                UserName userName;
                HandleProgress handleProgress = methodObject.getAnnotation(HandleProgress.class);
                if (handleProgress != null) {
                    params = GateUtils.extendParams(params, handler);
                }
                if ((userName = methodObject.getAnnotation(UserName.class)) != null) {
                    params = GateUtils.extendParams(params, user);
                }
                Object returned = methodObject.invoke(this.service, params);
                if (logItAnnotation != null) {
                    this.logIt(0, null, "OK", methodObject, params, user, password);
                }
                return returned;
            }
            catch (Exception e) {
                e.printStackTrace();
                String message = "Error calling method \"" + method + "\"";
                if (logItAnnotation != null) {
                    this.logIt(4, e, message, methodObject, params, user, password);
                }
                throw e;
            }
        }
        String message = "Wrapped object doesn't have method with the specified name: \"" + method + "\"";
        this.logIt(2, null, message, null, params, user, password);
        throw new GateMethodInvocationException(message);
    }

    public void logIt(int type, Exception e, String message, Method method, Object[] params, String user, String password) {
        if (this.logger != null) {
            this.logger.logMethod(type, message, e, this.instanceName, this.service, method, params, user);
        }
    }

    public RuleResolver getRuleResolver() {
        return this.ruleResolver;
    }

    public void setRuleResolver(RuleResolver ruleResolver) {
        this.ruleResolver = ruleResolver;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Object getService() {
        return this.service;
    }

    public void setService(Object object) {
        this.service = object;
    }

    public String getProxyClass() {
        return this.proxyClass;
    }

    public void setProxyClass(String proxyClass) {
        this.proxyClass = proxyClass;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

