/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.proxy;

import com.browsersoft.config.jgate.classloading.JarsRepositoryOnClient;
import com.browsersoft.config.jgate.comm.lowlevel.Sender;
import com.browsersoft.config.jgate.comm.lowlevel.StreamsPair;
import com.browsersoft.config.jgate.comm.middlelevel.GateSender;
import com.browsersoft.config.jgate.comm.middlelevel.GateSenderHandler;
import com.browsersoft.config.jgate.comm.middlelevel.GateSenderImpl;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateRequestWithId;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateResponseWithId;
import com.browsersoft.config.jgate.comm.middlelevel.base.MethodCalling;
import com.browsersoft.config.jgate.comm.middlelevel.base.ProgressSwitchers;
import com.browsersoft.config.jgate.comm.middlelevel.request.GateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.GateRoutePath;
import com.browsersoft.config.jgate.comm.middlelevel.response.GateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.ReturnedObjectAsByteArray;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.exceptions.GateCommException;
import com.browsersoft.config.jgate.node.GateNodeProxyServant;
import com.browsersoft.config.jgate.proxy.AsyncCallMethodThread;
import com.browsersoft.config.jgate.proxy.GateNodeProxy;
import com.browsersoft.config.jgate.proxy.ServiceProxy;
import com.browsersoft.config.jgate.proxy.ServiceProxyHandler;
import com.browsersoft.config.jgate.proxy.ServiceProxyInfo;
import com.browsersoft.config.jgate.proxy.handlers.AsyncHandler;
import com.browsersoft.config.jgate.proxy.handlers.SyncMethodHandler;
import com.browsersoft.config.jgate.proxy.handlers.SyncProgressMethodHandler;
import com.browsersoft.config.jgate.util.GateUtils;
import com.browsersoft.config.utils.streams.SizedInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class DirectGateNodeProxy
implements ServiceProxyHandler,
GateSenderHandler,
GateNodeProxy {
    private GateNodeProxyServant servant;
    private GateSender gateSender;
    private List<ServiceProxyInfo> serviceProxyInfos;
    private String user = "";
    private String password = "";
    private JarsRepositoryOnClient jarsRepositoryOnClient;
    private String gateNodeId;
    private String serverGateNodeId;
    private String senderId;

    public DirectGateNodeProxy(GateNodeProxyServant servant, GateNodeConfiguration configuration, String gateNodeId, String senderId) throws Exception {
        this.servant = servant;
        this.senderId = senderId;
        this.gateNodeId = gateNodeId;
        this.jarsRepositoryOnClient = new JarsRepositoryOnClient(this.getClass());
        this.gateSender = new GateSenderImpl(configuration, gateNodeId);
        this.gateSender.setHandler(this);
        this.serviceProxyInfos = this.gateSender.getProxyInfos(null);
    }

    public GateSender getGateSender() {
        return this.gateSender;
    }

    @Override
    public List<ServiceProxy> getAllProxies(boolean downloadJars) throws Exception {
        return this.getAllProxies(downloadJars, null);
    }

    @Override
    public List<ServiceProxy> getAllProxies(boolean downloadJars, SyncProgressMethodHandler updateHandler) throws Exception {
        ArrayList<ServiceProxy> proxies = new ArrayList<ServiceProxy>();
        for (ServiceProxyInfo info : this.serviceProxyInfos) {
            proxies.add(this.constructProxy(info, downloadJars, updateHandler));
        }
        return proxies;
    }

    @Override
    public ServiceProxy getProxy(String name, boolean downloadJars) throws Exception {
        return this.getProxy(name, downloadJars, null);
    }

    @Override
    public ServiceProxy getProxy(String name, boolean downloadJars, SyncProgressMethodHandler updateHandler) throws Exception {
        for (ServiceProxyInfo info : this.serviceProxyInfos) {
            if (!info.getInstanceName().equals(name)) continue;
            ServiceProxy serviceProxy = this.constructProxy(info, downloadJars, updateHandler);
            return serviceProxy;
        }
        return null;
    }

    private ServiceProxy constructProxy(ServiceProxyInfo infoService, boolean downloadJars, SyncProgressMethodHandler updateHandler) throws Exception {
        Object ob;
        ClassLoader classLoader = null;
        File[] files = null;
        if (downloadJars) {
            classLoader = this.jarsRepositoryOnClient.constructClassLoader(infoService.getInstanceName(), this, updateHandler);
            files = this.jarsRepositoryOnClient.constructJars(infoService.getInstanceName(), this, updateHandler);
            ob = classLoader != null ? classLoader.loadClass(infoService.getProxyClassName()).newInstance() : Class.forName(infoService.getProxyClassName()).newInstance();
        } else {
            ob = Class.forName(infoService.getProxyClassName()).newInstance();
        }
        if (!(ob instanceof ServiceProxy)) {
            throw new GateCommException("Class \"" + infoService.getProxyClassName() + "\" is not a Proxy object");
        }
        ServiceProxy proxy = (ServiceProxy)ob;
        proxy.setHandler(this);
        proxy.setJars(files);
        proxy.setServiceClassLoader(classLoader);
        proxy.setNameOfInstance(infoService.getInstanceName());
        return proxy;
    }

    @Override
    public ServiceProxy getProxy() throws Exception {
        return this.getProxy("", false);
    }

    @Override
    public ServiceProxy getProxy(boolean downloadJars) throws Exception {
        return this.getProxy("", downloadJars);
    }

    @Override
    public Object callMethod(MethodCalling methodCalling, Object[] extraParams, ProgressSwitchers progressSwitchers, SyncMethodHandler handler, ClassLoader classLoader, GateRoutePath gateRoutePath) throws Exception {
        methodCalling.setUser(this.user);
        methodCalling.setPassword(this.password);
        Object o = this.gateSender.callMethod(methodCalling, extraParams, progressSwitchers, handler, gateRoutePath);
        if (o instanceof ReturnedObjectAsByteArray) {
            Object ret = GateUtils.deserializeByteArrayToObject(((ReturnedObjectAsByteArray)o).getBytes(), classLoader);
            if (ret instanceof Exception) {
                throw (Exception)ret;
            }
            return ret;
        }
        if (o instanceof Exception) {
            throw (Exception)o;
        }
        return o;
    }

    public void clientLogin(Sender sender, GateRoutePath gateRoutePath) throws Exception {
        this.serverGateNodeId = this.gateSender.clientLogin(sender, this.gateNodeId, gateRoutePath);
    }

    @Override
    public void clientLogout(GateRoutePath gateRoutePath) throws Exception {
        this.gateSender.clientLogout(this.gateNodeId, gateRoutePath);
    }

    @Override
    public void ping() throws Exception {
        this.gateSender.ping(null);
    }

    public void ping(GateRoutePath gateRoutePath) throws Exception {
        this.gateSender.ping(gateRoutePath);
    }

    @Override
    public List<GateRequestWithId> checkClientCalling(List<GateResponseWithId> responses, GateRoutePath gateRoutePath) throws Exception {
        return this.gateSender.checkClientCalling(this.gateNodeId, responses, gateRoutePath);
    }

    @Override
    public String callMethodAsync(MethodCalling methodCalling, Object[] extraParams, ProgressSwitchers progressSwitchers, AsyncHandler handler, ClassLoader classLoader, GateRoutePath gateRoutePath) {
        methodCalling.setUser(this.user);
        methodCalling.setPassword(this.password);
        String callingId = UUID.randomUUID().toString();
        AsyncCallMethodThread methodThread = new AsyncCallMethodThread();
        methodThread.setClassLoader(classLoader);
        methodThread.setRoutePath(gateRoutePath);
        methodThread.setHandler(handler);
        methodThread.setMethodCalling(methodCalling);
        methodThread.setExtraParams(extraParams);
        methodThread.setProgressSwitchers(progressSwitchers);
        methodThread.setProxy(this);
        methodThread.setProcessId(callingId);
        methodThread.start();
        return callingId;
    }

    @Override
    public String getClientId() {
        return this.gateNodeId;
    }

    @Override
    public GateNodeProxyServant getServant() {
        return this.servant;
    }

    public void setServant(GateNodeProxyServant servant) {
        this.servant = servant;
    }

    @Override
    public GateResponse sendRequest(GateRequest request) throws Exception {
        GateResponse res = this.servant.sendRequest(request);
        return res;
    }

    @Override
    public SizedInputStream sendInputStreamRequest(GateRequest request) throws Exception {
        return this.servant.sendInputStreamRequest(request);
    }

    @Override
    public StreamsPair sendOutputStreamRequest(GateRequest request) throws Exception {
        return this.servant.sendOutputStreamRequest(request);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public JarsRepositoryOnClient getJarsRepositoryOnClient() {
        return this.jarsRepositoryOnClient;
    }

    public void setJarsRepositoryOnClient(JarsRepositoryOnClient jarsRepositoryOnClient) {
        this.jarsRepositoryOnClient = jarsRepositoryOnClient;
    }

    @Override
    public String getGateNodeId() {
        return this.serverGateNodeId;
    }

    public void setGateNodeId(String serverGateNodeId) {
        this.serverGateNodeId = serverGateNodeId;
    }

    @Override
    public String getSenderId() {
        return this.senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }
}

