/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.repositories.calling;

import com.browsersoft.config.jgate.repositories.calling.Calling;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Date;

public class CallingResponse
implements Calling {
    private Date lastAccess;
    private ByteArrayInputStream inputStream;
    private int remainingSize;

    public CallingResponse(byte[] bytes) {
        this.remainingSize = bytes.length;
        this.inputStream = new ByteArrayInputStream(bytes);
        this.lastAccess = new Date();
    }

    public byte[] read(byte[] buffer) throws IOException {
        this.lastAccess = new Date();
        int numOfBytes = this.inputStream.read(buffer);
        if (numOfBytes == buffer.length) {
            this.remainingSize -= buffer.length;
            return buffer;
        }
        byte[] newBuffer = new byte[numOfBytes];
        System.arraycopy(buffer, 0, newBuffer, 0, numOfBytes);
        this.remainingSize -= newBuffer.length;
        return newBuffer;
    }

    @Override
    public Calling.TypeOfCache getType() {
        return Calling.TypeOfCache.RESPONSE;
    }

    @Override
    public Date getLastAccess() {
        return this.lastAccess;
    }

    public int getRemainingSize() {
        return this.remainingSize;
    }

    public void setRemainingSize(int remainingSize) {
        this.remainingSize = remainingSize;
    }
}

