/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.repositories.streams;

import com.browsersoft.config.jgate.repositories.streams.StreamRepositoryItem;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamRepositoryItem
extends StreamRepositoryItem {
    private InputStream localInputStream;

    public InputStreamRepositoryItem(int initBufferSize) {
        super(initBufferSize);
    }

    public synchronized byte[] readFromStream() throws IOException {
        int size = this.localInputStream.read(this.buffer);
        if (size == this.buffer.length) {
            return this.buffer;
        }
        if (size < 0) {
            return new byte[0];
        }
        byte[] differentSizeArray = new byte[size];
        System.arraycopy(this.buffer, 0, differentSizeArray, 0, size);
        return differentSizeArray;
    }

    @Override
    public void close() throws IOException {
        this.localInputStream.close();
    }

    public InputStream getLocalInputStream() {
        return this.localInputStream;
    }

    public void setLocalInputStream(InputStream localInputStream) {
        this.localInputStream = localInputStream;
    }
}

