/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.util;

import com.browsersoft.config.utils.DOMUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class KeyStore {
    private static final Logger logger = Logger.getLogger(KeyStore.class.getName());
    private java.security.KeyStore keystore;
    private String keystorePassword;
    private String certificatePassword;
    private String alias;
    private List<String> trustedAliases = new ArrayList<String>();

    public KeyStore(InputStream keyStoreInputStream, InputStream accessXmlInputStream) throws IOException, SAXException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        this.loadFromFiles(keyStoreInputStream, accessXmlInputStream);
    }

    public KeyStore(File keyStoreFile, String keystorePassword, String certificatePassword, String alias) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        this.keystorePassword = keystorePassword;
        this.certificatePassword = certificatePassword;
        this.alias = alias;
        try (FileInputStream inputStream = new FileInputStream(keyStoreFile);){
            this.loadKeyStore(inputStream);
        }
    }

    private void loadFromFiles(InputStream keyStoreInputStream, InputStream accessXmlInputStream) throws IOException, SAXException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        this.loadAccessXml(accessXmlInputStream);
        this.loadKeyStore(keyStoreInputStream);
    }

    private void loadAccessXml(InputStream accessXmlInputStream) throws IOException, SAXException {
        Element accessRoot = DOMUtils.loadFromInputStream((InputStream)accessXmlInputStream).getDocumentElement();
        Map params = DOMUtils.getChildNodesAsParams((Node)accessRoot);
        this.keystorePassword = (String)params.get("ksPass");
        this.certificatePassword = (String)params.get("crPass");
        this.alias = (String)params.get("alias");
        Node trustedAliasesNode = DOMUtils.getOneNodeChild((Node)accessRoot, (String)"trustedAliases");
        if (trustedAliasesNode != null) {
            List trustedAliasNodes = DOMUtils.getNodeChilds((Node)trustedAliasesNode, (String)"trustedAlias");
            for (Node trustedAliasNode : trustedAliasNodes) {
                Element trustedElement = (Element)trustedAliasNode;
                this.trustedAliases.add(trustedElement.getTextContent().trim());
            }
        }
    }

    private void loadKeyStore(InputStream keyStoreInputStream) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        logger.fine("Loading keystore");
        java.security.KeyStore ks = java.security.KeyStore.getInstance("JKS");
        ks.load(keyStoreInputStream, this.keystorePassword.toCharArray());
        this.keystore = ks;
    }

    public PrivateKey getPrivateKey() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
        logger.fine("Getting private key with alias '" + this.alias + "'");
        KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(this.certificatePassword.toCharArray());
        KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)this.keystore.getEntry(this.alias, protParam);
        return pkEntry.getPrivateKey();
    }

    public Certificate getCertificate() throws KeyStoreException {
        logger.fine("Getting certificate with alias '" + this.alias + "'");
        return this.keystore.getCertificate(this.alias);
    }

    public Map<String, X509Certificate> getTrustedCertificates() throws KeyStoreException {
        logger.fine("Getting trusted certificates");
        HashMap<String, X509Certificate> trustedCertificates = new HashMap<String, X509Certificate>();
        for (String alias : this.trustedAliases) {
            if (!this.keystore.containsAlias(alias)) continue;
            X509Certificate certificate = (X509Certificate)this.keystore.getCertificate(alias);
            trustedCertificates.put(alias, certificate);
        }
        return trustedCertificates;
    }

    public void initKeyManagerFactory(KeyManagerFactory kmf) throws GeneralSecurityException, IOException {
        KeyStore.PasswordProtection passwordProtection;
        KeyStore.Entry privateKey;
        java.security.KeyStore privateKeystore = this.keystore;
        if (this.alias != null && !this.alias.isEmpty() && (privateKey = this.keystore.getEntry(this.alias, passwordProtection = new KeyStore.PasswordProtection(this.certificatePassword.toCharArray()))) != null) {
            privateKeystore = java.security.KeyStore.getInstance(java.security.KeyStore.getDefaultType());
            privateKeystore.load(null);
            privateKeystore.setEntry(this.alias, privateKey, passwordProtection);
        }
        kmf.init(privateKeystore, this.certificatePassword.toCharArray());
    }

    public X509TrustManager getStandardTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
        factory.init(this.keystore);
        TrustManager[] trustManagers = factory.getTrustManagers();
        if (trustManagers.length == 0) {
            throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
        }
        return (X509TrustManager)trustManagers[0];
    }

    public SSLContext createSSLContext(String protocol) throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        this.initKeyManagerFactory(kmf);
        TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
        factory.init(this.keystore);
        TrustManager[] trustManagers = factory.getTrustManagers();
        SSLContext sc = SSLContext.getInstance(protocol);
        sc.init(kmf.getKeyManagers(), trustManagers, new SecureRandom());
        return sc;
    }
}

