#!/bin/bash
#
# node    Release node 2.0 for managing HIE Engine instances
#
# chkconfig: 345 70 30
# description: Release node 2.0 for managing HIE Engine instances
# processname: node

USER="browsersoft"
ROOT="/opt/browsersoft/node"

# Source function library.
. /etc/init.d/functions

start() {
        echo -n "Starting Node: "
        su - ${USER} -c "${ROOT}/node.sh start"
        return $?
}

stop() {
        echo -n "Shutting down Node: "
        su - ${USER} -c "${ROOT}/node.sh stop"
        return $?
}

case "$1" in
    start)
        start
        ;;
    stop)
        stop
        ;;
    *)
        echo "Usage: $0 [start|stop]"
        exit 1
        ;;
esac

exit $?
