#!/bin/sh

CURDIR="$PWD"
NODEDIR=$( cd -P -- "$(dirname -- "$0")" && pwd -P )

cd "$NODEDIR"

JAVA_OPTS="$JAVA_OPTS -Xmx512M -XX:PermSize=512M -XX:MaxPermSize=512m -Duser.timezone=UTC -Djava.awt.headless=true"

case $1 in
start)

  if [ -f "$NODEDIR/node.pid" ] ; then
    if [ -d "/proc/$(cat $NODEDIR/node.pid)" ] ; then
      echo "Node seems to be running."
      break
    else
      unlink "$NODEDIR/node.pid"
    fi
  fi

  if [ -f "$NODEDIR/node.out" ] ; then
    if [ ! -d "$NODEDIR/logs" ] ; then
        mkdir $NODEDIR/logs
      fi
    logrotate -f $NODEDIR/logrotate.conf -s $NODEDIR/logstatus
  fi

  java $JAVA_OPTS -classpath "libs/*" com.browsersoft.config.node.ReleaseNode $NODEDIR/server.xml &> $NODEDIR/node.out &
  echo "$!" > $NODEDIR/node.pid

  ;;
stop)

  if [ ! -f "$NODEDIR/node.pid" ] ; then
    echo "Node is not running"
  else
    cat "$NODEDIR/node.pid" | while read line;
    do
      pid="${line}";
      kill $pid
      unlink "$NODEDIR/node.pid"
    done
  fi

  ;;

stop-engines)
  java $JAVA_OPTS -classpath "$NODEDIR/libs/*" com.browsersoft.config.node.ReleaseNode $NODEDIR/server.xml stop-engines
  ;;
*)

  echo "Parameters can be either start, stop or stop-engines"

  ;;
esac

cd "$CURDIR"
