/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow;

import com.browsersoft.commander.commanderwindow.JNodeCommanderAppLayout;
import com.browsersoft.commander.commanderwindow.JNodeCommanderHandler;
import com.browsersoft.commander.commanderwindow.MainApp;
import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.commanderwindow.modules.BuildInPluginsManager;
import com.browsersoft.commander.utils.XTrustProvider;
import com.browsersoft.commander.utils.swing.MemoryPanel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.DarkStar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class JNodeCommanderApp
extends JFrame
implements JNodeCommanderHandler {
    private MainApp commander;
    private JNodeCommanderAppLayout layout;
    private JToolBar jToolBar1;
    private JButton buttonSides;
    private JButton toolbarButtonProfiles;
    private JSeparator fileSeparator;
    private JMenuItem jMenuItem1;
    private JSeparator jSeparator1;
    private JPanel layoutPanel;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenuItem menuItemConnect;
    private JMenuItem exportSettings;
    private JMenuItem importSettings;
    private JMenuItem menuItemProfiles;
    private JMenuItem menuItemSettings;
    private JMenuItem menuItemSave;
    private JMenuItem menuItemSaveAll;
    private JMenuItem menuReload;

    public JNodeCommanderApp() throws Exception {
        System.setSecurityManager(null);
        try {
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new DarkStar());
            UIManager.setLookAndFeel(new PlasticLookAndFeel());
        }
        catch (Exception e) {
            System.err.println("Can't set look & feel: " + e);
        }
        URL imgURL = this.getClass().getResource("icon128.png");
        Image icon = Toolkit.getDefaultToolkit().getImage(imgURL);
        if (icon != null) {
            this.setIconImage(icon);
        }
        BuildInPluginsManager.init();
        XTrustProvider.install();
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.initComponents();
        this.commander = new MainApp(this.menuBar, this.jToolBar1);
        this.layout = new JNodeCommanderAppLayout(this.commander);
        this.layoutPanel.add((Component)this.layout.getRootComponent(), "Center");
        this.commander.getDocumentManager().setLayout(this.layout);
        this.commander.setHandler(this);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize);
        this.setLocation(0, 0);
        this.setMaximized(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JNodeCommanderApp.this.layout.setSplitLocation(800);
            }
        });
    }

    public void setMaximized(boolean maximized) {
        if (maximized) {
            DisplayMode mode = this.getGraphicsConfiguration().getDevice().getDisplayMode();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
            this.setMaximizedBounds(new Rectangle(mode.getWidth() - insets.right - insets.left, mode.getHeight() - insets.top - insets.bottom));
            this.setExtendedState(this.getExtendedState() | 6);
        } else {
            this.setExtendedState(0);
        }
    }

    @Override
    public void changeState(boolean saveEnabled, boolean saveAllEnabled) {
        this.menuItemSave.setEnabled(saveEnabled);
        this.menuItemSaveAll.setEnabled(saveAllEnabled);
    }

    @Override
    public void switchDisplaySides() {
        this.sides();
    }

    private void exportSettings() {
        try {
            this.commander.exportSettings();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void importSettings() {
        try {
            this.commander.importSettings();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void modules() {
        try {
            this.commander.openModules();
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    private void profiles() {
        try {
            this.commander.openProfiles();
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    private void settings() {
        try {
            this.commander.openSettings();
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    private void connect() {
        try {
            this.commander.openLoginDialog();
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    private void save() {
        try {
            this.commander.save();
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    private void compile() {
        try {
            this.commander.compile();
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    private void saveAll() {
        try {
            this.commander.saveAll();
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    private void copy() {
        this.commander.copy();
    }

    private void move() {
        this.commander.move();
    }

    private void link() {
        this.commander.link();
    }

    private void delete() {
        this.commander.delete();
    }

    private void reloadModules() {
        this.commander.reloadModules();
    }

    private void sides() {
        this.commander.switchDisplaySides();
        this.layout.setSplitLocation(this.commander.isTwoSides() ? 800 : 550);
        this.commander.updateUI();
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jToolBar1.setFloatable(false);
        this.buttonSides = new JButton();
        this.toolbarButtonProfiles = new JButton();
        this.buttonSides.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/sides24.png")));
        this.buttonSides.setToolTipText("One or two column");
        this.buttonSides.setAlignmentX(0.5f);
        this.buttonSides.setBorder(null);
        this.buttonSides.setBorderPainted(false);
        this.buttonSides.setFocusPainted(false);
        this.buttonSides.setFocusable(false);
        this.buttonSides.setHorizontalTextPosition(0);
        this.buttonSides.setMargin(new Insets(8, 14, 8, 14));
        this.buttonSides.setMaximumSize(new Dimension(28, 25));
        this.buttonSides.setMinimumSize(new Dimension(28, 25));
        this.buttonSides.setPreferredSize(new Dimension(25, 25));
        this.buttonSides.setVerticalTextPosition(3);
        this.buttonSides.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JNodeCommanderApp.this.buttonSidesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.buttonSides);
        this.toolbarButtonProfiles.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/profiles24.png")));
        this.toolbarButtonProfiles.setToolTipText("Profiles");
        this.toolbarButtonProfiles.setBorderPainted(false);
        this.toolbarButtonProfiles.setFocusable(false);
        this.toolbarButtonProfiles.setMargin(new Insets(8, 14, 8, 14));
        this.toolbarButtonProfiles.setMaximumSize(new Dimension(28, 25));
        this.toolbarButtonProfiles.setMinimumSize(new Dimension(28, 25));
        this.toolbarButtonProfiles.setPreferredSize(new Dimension(25, 25));
        this.toolbarButtonProfiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JNodeCommanderApp.this.toolbarButtonProfilesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarButtonProfiles);
        this.jToolBar1.add(new MemoryPanel());
        this.layoutPanel = new JPanel(new BorderLayout());
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuItemProfiles = new JMenuItem();
        this.menuItemSettings = new JMenuItem();
        this.menuItemConnect = new JMenuItem();
        this.menuReload = new JMenuItem();
        this.fileSeparator = new JSeparator();
        this.menuItemSave = new JMenuItem();
        this.menuItemSaveAll = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItem1 = new JMenuItem();
        this.importSettings = new JMenuItem();
        this.exportSettings = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Lightbeam HIE Configurator Studio");
        this.menuFile.setFont(new Font("Arial", 0, 11));
        this.menuFile.setText("File");
        this.menuFile.setToolTipText("File");
        int MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.menuItemProfiles.setAccelerator(KeyStroke.getKeyStroke(80, MASK));
        this.menuItemProfiles.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/profiles.png")));
        this.menuItemProfiles.setText("Profiles");
        this.menuItemProfiles.setFont(new Font("Arial", 0, 11));
        this.menuItemProfiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JNodeCommanderApp.this.menuItemProfilesActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuItemProfiles);
        this.menuItemConnect.setAccelerator(KeyStroke.getKeyStroke(79, MASK));
        this.menuItemConnect.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/network.png")));
        this.menuItemConnect.setText("Connect");
        this.menuItemConnect.setFont(new Font("Arial", 0, 11));
        this.menuItemConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JNodeCommanderApp.this.menuItemConnectActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuItemConnect);
        this.menuFile.add(this.fileSeparator);
        this.menuItemSave.setAccelerator(KeyStroke.getKeyStroke(83, MASK));
        this.menuItemSave.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/save.png")));
        this.menuItemSave.setText("Save");
        this.menuItemSave.setFont(new Font("Arial", 0, 11));
        this.menuItemSave.setEnabled(false);
        this.menuItemSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JNodeCommanderApp.this.menuItemSaveActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuItemSave);
        this.menuItemSaveAll.setAccelerator(KeyStroke.getKeyStroke(87, MASK));
        this.menuItemSaveAll.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/saveAll.png")));
        this.menuItemSaveAll.setText("Save All");
        this.menuItemSaveAll.setFont(new Font("Arial", 0, 11));
        this.menuItemSaveAll.setEnabled(false);
        this.menuItemSaveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JNodeCommanderApp.this.menuItemSaveAllActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuItemSaveAll);
        this.menuFile.add(this.jSeparator1);
        this.importSettings.setAccelerator(KeyStroke.getKeyStroke(73, MASK));
        this.importSettings.setText("Import settings");
        this.importSettings.setFont(new Font("Arial", 0, 11));
        this.importSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JNodeCommanderApp.this.importSettings();
            }
        });
        this.menuFile.add(this.importSettings);
        this.exportSettings.setAccelerator(KeyStroke.getKeyStroke(69, MASK));
        this.exportSettings.setText("Export settings");
        this.exportSettings.setFont(new Font("Arial", 0, 11));
        this.exportSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JNodeCommanderApp.this.exportSettings();
            }
        });
        this.menuFile.add(this.exportSettings);
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.jMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/sides.png")));
        this.jMenuItem1.setText("One or two columns");
        this.jMenuItem1.setFont(new Font("Arial", 0, 11));
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JNodeCommanderApp.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.menuFile.add(this.jMenuItem1);
        this.menuItemSettings.setText("Settings");
        this.menuItemSettings.setFont(new Font("Arial", 0, 11));
        this.menuItemSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JNodeCommanderApp.this.settings();
            }
        });
        this.menuFile.add(this.menuItemSettings);
        this.menuBar.add(this.menuFile);
        this.setJMenuBar(this.menuBar);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jToolBar1, "First");
        this.add((Component)this.layoutPanel, "Center");
    }

    private void menuReloadActionPerformed(ActionEvent evt) {
        this.reloadModules();
    }

    private void menuItemSaveAllActionPerformed(ActionEvent evt) {
        this.saveAll();
    }

    private void menuItemSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void toolbarButtonSaveAllActionPerformed(ActionEvent evt) {
        this.saveAll();
    }

    private void toolbarButtonSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void toolbarButtonConnectActionPerformed(ActionEvent evt) {
        this.connect();
    }

    private void toolbarButtonProfilesActionPerformed(ActionEvent evt) {
        this.profiles();
    }

    private void toolbarButtonModulesActionPerformed(ActionEvent evt) {
        this.modules();
    }

    private void menuItemConnectActionPerformed(ActionEvent evt) {
        try {
            this.commander.openLoginDialog();
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    private void menuItemProfilesActionPerformed(ActionEvent evt) {
        this.profiles();
    }

    private void menuItemModulesActionPerformed(ActionEvent evt) {
        this.modules();
    }

    private void buttonSidesActionPerformed(ActionEvent evt) {
        this.sides();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.sides();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            try {
                new JNodeCommanderApp().setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

