/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow;

import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.commanderwindow.profiles.Profile;
import com.browsersoft.commander.commanderwindow.profiles.ProfileCollection;
import com.browsersoft.commander.model.CommanderPlugStorage;
import com.browsersoft.commander.model.CommanderPlugStorageConfiguration;
import com.browsersoft.commander.model.DocumentManager;
import com.browsersoft.commander.utils.swing.CenteredDialog;
import com.browsersoft.commander.utils.swing.JImageCombo;
import com.browsersoft.commander.utils.swing.JImageComboItem;
import com.browsersoft.commander.utils.swing.KeyBuffer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;

public class LoginForm
extends CenteredDialog {
    private int lastSelectedItem = -1;
    private ProfileCollection profiles;
    private Profile actualProfile;
    private CommanderPlugStorageConfiguration actualConfigurationPanel;
    private Icon connectedIcon = new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/profiles/connect_established.png"));
    private Icon disconnectedIcon = new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/profiles/connect_no.png"));
    private DocumentManager documentManager;
    private JButton buttonOK;
    private JButton buttonStatus;
    private JComboBox comboProfiles;
    private JPanel panelDetails;

    public LoginForm(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    public void fillDialog(ProfileCollection profiles) {
        this.profiles = profiles;
        for (int i = 0; i < profiles.size(); ++i) {
            Profile profile = profiles.get(i);
            CommanderPlugStorage storage = profile.getCommanderPlugStorage();
            JImageComboItem item = new JImageComboItem(String.valueOf(i), profile.getProfileName() + " - " + storage.getStorageName(), storage.getStorageIcon());
            this.comboProfiles.addItem(item);
        }
        if (profiles.size() > 0) {
            this.selectItem(0);
        }
        this.comboProfiles.addActionListener(e -> {
            JImageCombo cb = (JImageCombo)e.getSource();
            this.selectItem(cb.getSelectedIndex());
        });
    }

    private void buttonClick() {
        if (this.actualProfile.isConnected()) {
            try {
                this.actualProfile.disconnect();
                this.enableAll();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                this.save();
                this.actualProfile.connect(this.documentManager);
                this.disableAll();
            }
            catch (Exception e) {
                ErrorManager.notify(e);
            }
        }
    }

    public void save() {
        this.actualProfile.setModuleConfiguration(this.actualConfigurationPanel.save());
    }

    private void selectItem(int index) {
        if (this.lastSelectedItem == index) {
            return;
        }
        this.lastSelectedItem = index;
        this.actualProfile = this.profiles.get(index);
        this.actualConfigurationPanel = this.actualProfile.getCommanderPlugStorage().getConfigurationPanel(this.profiles.toProfilesInfos());
        this.actualConfigurationPanel.load(this.actualProfile.getModuleConfiguration());
        if (this.actualProfile.isConnected()) {
            this.disableAll();
        } else {
            this.enableAll();
        }
        this.panelDetails.removeAll();
        this.panelDetails.setLayout(new BorderLayout());
        this.panelDetails.add((Component)this.actualConfigurationPanel, "Center");
    }

    private void enableAll() {
        this.buttonStatus.setText("Connect");
        this.buttonStatus.setIcon(this.disconnectedIcon);
        this.actualConfigurationPanel.enableAll();
    }

    private void disableAll() {
        this.buttonStatus.setText("Disconnect");
        this.buttonStatus.setIcon(this.connectedIcon);
        this.actualConfigurationPanel.disableAll();
    }

    private void initComponents() {
        this.comboProfiles = new JImageCombo();
        this.panelDetails = new JPanel();
        this.buttonOK = new JButton();
        this.buttonStatus = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Login");
        this.setResizable(false);
        KeyBuffer.installKey(this.getRootPane(), 27, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginForm.this.dispose();
            }
        });
        this.panelDetails.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(null, "Profile detail", 0, 0, new Font("Tahoma", 0, 11), new Color(102, 102, 102))));
        GroupLayout panelDetailsLayout = new GroupLayout((Container)this.panelDetails);
        this.panelDetails.setLayout((LayoutManager)panelDetailsLayout);
        panelDetailsLayout.setHorizontalGroup((GroupLayout.Group)panelDetailsLayout.createParallelGroup(1).add(0, 389, Short.MAX_VALUE));
        panelDetailsLayout.setVerticalGroup((GroupLayout.Group)panelDetailsLayout.createParallelGroup(1).add(0, 156, Short.MAX_VALUE));
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginForm.this.buttonOKActionPerformed(evt);
            }
        });
        this.buttonStatus.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/profiles/connect_no.png")));
        this.buttonStatus.setText(" ");
        this.buttonStatus.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.buttonStatus.setContentAreaFilled(false);
        this.buttonStatus.setHorizontalTextPosition(0);
        this.buttonStatus.setVerticalTextPosition(3);
        this.buttonStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginForm.this.buttonStatusActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.buttonStatus, -1, 413, Short.MAX_VALUE).add((Component)this.buttonOK).add(1, (Component)this.panelDetails, -1, -1, Short.MAX_VALUE).add(1, (Component)this.comboProfiles, 0, 413, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.comboProfiles, -2, -1, -2).addPreferredGap(0).add((Component)this.buttonStatus, -2, 75, -2).addPreferredGap(0).add((Component)this.panelDetails, -2, -1, -2).addPreferredGap(0).add((Component)this.buttonOK).addContainerGap(-1, Short.MAX_VALUE)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 433) / 2, (screenSize.height - 354) / 2, 433, 354);
    }

    private void buttonStatusActionPerformed(ActionEvent evt) {
        this.buttonClick();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new LoginForm((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }
}

