/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow;

import com.browsersoft.commander.commanderwindow.JNodeCommanderHandler;
import com.browsersoft.commander.commanderwindow.LoginForm;
import com.browsersoft.commander.commanderwindow.document.DefaultDocumentManager;
import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.commanderwindow.filesystem.FileSystemAdapter;
import com.browsersoft.commander.commanderwindow.modules.BuildInPluginsManager;
import com.browsersoft.commander.commanderwindow.modules.ModuleInfoCollection;
import com.browsersoft.commander.commanderwindow.modules.ModulesManager;
import com.browsersoft.commander.commanderwindow.modules.ModulesPanel;
import com.browsersoft.commander.commanderwindow.modules.StorageTypeInfo;
import com.browsersoft.commander.commanderwindow.modules.StorageTypeInfoCollection;
import com.browsersoft.commander.commanderwindow.modules.ToolbarPlugin;
import com.browsersoft.commander.commanderwindow.operation.OperationBar;
import com.browsersoft.commander.commanderwindow.operation.OperationBarHandler;
import com.browsersoft.commander.commanderwindow.operation.OperationManager;
import com.browsersoft.commander.commanderwindow.operation.OperationManagerHandler;
import com.browsersoft.commander.commanderwindow.plugin.OpenInSystemPlugin;
import com.browsersoft.commander.commanderwindow.plugin.zip.BrowseZipFilePlugin;
import com.browsersoft.commander.commanderwindow.profiles.Profile;
import com.browsersoft.commander.commanderwindow.profiles.ProfileCollection;
import com.browsersoft.commander.commanderwindow.profiles.ProfileListener;
import com.browsersoft.commander.commanderwindow.profiles.ProfilesPanel;
import com.browsersoft.commander.commanderwindow.settings.CommanderSettings;
import com.browsersoft.commander.commanderwindow.settings.SettingsInfo;
import com.browsersoft.commander.commanderwindow.settings.SettingsInfoElementHandler;
import com.browsersoft.commander.commanderwindow.side.JCommanderSide;
import com.browsersoft.commander.commanderwindow.side.JCommanderSideHandler;
import com.browsersoft.commander.model.CommanderPlugModel;
import com.browsersoft.commander.model.CommanderPlugStorageModel;
import com.browsersoft.commander.model.CommanderPlugStorageModelCollection;
import com.browsersoft.commander.model.DocumentManagerHandler;
import com.browsersoft.commander.model.FileExtensionHandlerCollection;
import com.browsersoft.commander.model.adapter.AdapterStorage;
import com.browsersoft.commander.model.plugin.PluginCollection;
import com.browsersoft.commander.utils.forms.SimpleDialogWithForm;
import com.browsersoft.commander.utils.swing.KeyBuffer;
import com.browsersoft.commander.utils.swing.KeyBufferHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class MainApp
extends JPanel
implements JCommanderSideHandler,
OperationManagerHandler,
DocumentManagerHandler,
KeyBufferHandler,
OperationBarHandler,
ProfileListener {
    private static final Logger log = Logger.getLogger(MainApp.class.getName());
    private boolean leftLastFocus = false;
    private CommanderPlugStorageModelCollection storageModels;
    private StorageTypeInfoCollection storageTypesCollection;
    private CommanderSettings commanderSettings;
    private ProfileCollection profiles;
    private ModuleInfoCollection modules;
    private OperationManager operationManager;
    private DefaultDocumentManager documentManager;
    private AdapterStorage fileSystemStorageModel;
    private ErrorManager errorManager;
    private JNodeCommanderHandler handler;
    private KeyBuffer keyBuffer;
    private JMenuBar menuBar;
    private JToolBar toolBar;
    private List<JMenuItem> menuItemsToRemove;
    private JCommanderSide jCommanderSideLeft;
    private JCommanderSide jCommanderSideRight;
    private OperationBar operationBar;
    private JPanel panelButtons;
    private JPanel panelContent;
    private ModulesManager modulesManager;
    private PluginCollection pluginCollection = new PluginCollection();
    private boolean twoSides;
    public static MainApp mainApp;

    public MainApp(JMenuBar menuBar, JToolBar toolBar) throws Exception {
        super(new BorderLayout());
        mainApp = this;
        this.commanderSettings = new CommanderSettings();
        this.menuBar = menuBar;
        this.toolBar = toolBar;
        this.menuItemsToRemove = new ArrayList<JMenuItem>();
        this.initComponents();
        this.jCommanderSideLeft = new JCommanderSide();
        this.jCommanderSideRight = new JCommanderSide();
        this.jCommanderSideLeft.setCommanderSettings(this.commanderSettings);
        this.jCommanderSideLeft.setLastPathKey("LastLeft");
        this.jCommanderSideRight.setCommanderSettings(this.commanderSettings);
        this.jCommanderSideRight.setLastPathKey("RightLeft");
        this.jCommanderSideLeft.setPluginCollection(this.pluginCollection);
        this.jCommanderSideRight.setPluginCollection(this.pluginCollection);
        this.doTwoSides();
        this.twoSides = true;
        JMenu operationMenu = new JMenu("Operation");
        operationMenu.setFont(new Font("Arial", 0, 11));
        menuBar.add(operationMenu);
        this.operationBar = new OperationBar(operationMenu);
        this.operationBar.setHandler(this);
        this.panelButtons.add((Component)this.operationBar, "Center");
        this.keyBuffer = new KeyBuffer(1000);
        this.keyBuffer.setHandler(this);
        this.errorManager = new ErrorManager(null, this);
        try {
            this.fileSystemStorageModel = new AdapterStorage(new FileSystemAdapter());
            this.fileSystemStorageModel.connect();
            this.documentManager = new DefaultDocumentManager();
            this.documentManager.setParentNodeCommander(this);
            this.documentManager.setHandler(this);
            this.operationManager = new OperationManager();
            this.operationManager.setDocumentManager(this.documentManager);
            this.documentManager.setOperationManager(this.operationManager);
            this.documentManager.setCommanderSettings(this.commanderSettings);
            this.installCloseDocumentTabKey();
            this.operationManager.setHandler(this);
            this.fileSystemStorageModel.setDocumentManager(this.documentManager);
            this.modulesManager = new ModulesManager();
            this.modulesManager.setCommanderSettings(this.commanderSettings);
            this.modulesManager.setFrame((JFrame)SwingUtilities.getWindowAncestor(this));
            this.startIt(false, true);
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainApp.this.errorManager.setParent(MainApp.this.getAncesor());
                    ErrorManager.notify(e);
                }
            });
        }
    }

    private void installCloseDocumentTabKey() {
        int modifierKeys = this.getToolkit().getMenuShortcutKeyMask();
        KeyBuffer.installKey(this, 87, modifierKeys, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainApp.this.documentManager.closeActiveDocument();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void renderToolBarPlugins() {
        Set<ToolbarPlugin> plugins = BuildInPluginsManager.getPlugins(ToolbarPlugin.class);
        LinkedHashSet<ToolbarPlugin> rightSidePlugins = new LinkedHashSet<ToolbarPlugin>();
        for (ToolbarPlugin plugin : plugins) {
            if (!plugin.alignToRight()) {
                plugin.render(this, this.toolBar);
                continue;
            }
            rightSidePlugins.add(plugin);
        }
        if (!rightSidePlugins.isEmpty()) {
            this.toolBar.add(Box.createHorizontalGlue());
            for (ToolbarPlugin plugin : rightSidePlugins) {
                plugin.render(this, this.toolBar);
            }
        }
    }

    @Override
    public void profilesChanged() {
        Set<ToolbarPlugin> plugins = BuildInPluginsManager.getPlugins(ToolbarPlugin.class);
        for (ToolbarPlugin plugin : plugins) {
            if (!(plugin instanceof ProfileListener)) continue;
            try {
                ((ProfileListener)((Object)plugin)).profilesChanged();
            }
            catch (Exception exception) {}
        }
    }

    public boolean isTwoSides() {
        return this.twoSides;
    }

    void switchDisplaySides() {
        if (this.twoSides) {
            this.doOneSide();
            this.twoSides = false;
        } else {
            this.doTwoSides();
            this.twoSides = true;
        }
    }

    private void doTwoSides() {
        this.panelContent.removeAll();
        JSplitPane jSplitPanel = new JSplitPane();
        jSplitPanel.setLeftComponent(this.jCommanderSideLeft);
        jSplitPanel.setRightComponent(this.jCommanderSideRight);
        jSplitPanel.setDividerLocation(400);
        jSplitPanel.setBorder(null);
        this.panelContent.add((Component)jSplitPanel, "Center");
        this.jCommanderSideLeft.makeFocusGain();
    }

    private void doOneSide() {
        this.panelContent.removeAll();
        this.panelContent.add((Component)this.jCommanderSideLeft, "Center");
        this.jCommanderSideRight.makeFocusLost();
        this.jCommanderSideLeft.makeFocusGain();
    }

    public void importSettings() throws Exception, InvalidPreferencesFormatException {
        JFileChooser fileChooser = new JFileChooser();
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            FileInputStream fileInputStream = new FileInputStream(path);
            this.commanderSettings.importPreferences(fileInputStream);
            fileInputStream.close();
            this.startIt(false, true);
        }
    }

    public void exportSettings() throws IOException, BackingStoreException {
        JFileChooser fileChooser = new JFileChooser();
        int returnVal = fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            FileOutputStream fileOutputStream = new FileOutputStream(path);
            this.commanderSettings.exportPreferences(fileOutputStream);
            fileOutputStream.close();
        }
    }

    private void startIt(boolean all, boolean doUpdate) throws Exception {
        this.documentManager.closeAll();
        if (this.profiles != null) {
            this.profiles.disconnectAll();
        }
        this.modules = this.commanderSettings.loadModules();
        this.modulesManager.updateModules(this.modules, all);
        this.storageTypesCollection = new StorageTypeInfoCollection();
        this.storageTypesCollection.reinitStorages(this.modules, this.modulesManager);
        this.updateFileExtensionHandlers();
        this.updatePluginCollection();
        this.profiles = this.commanderSettings.loadProfiles(this.storageTypesCollection);
        ArrayList<CommanderPlugStorageModel> staticStorageModels = new ArrayList<CommanderPlugStorageModel>();
        staticStorageModels.add(this.fileSystemStorageModel);
        this.storageModels = new CommanderPlugStorageModelCollection(this.profiles, staticStorageModels, this.commanderSettings.getGitCheckInterval());
        this.jCommanderSideLeft.setHandler(this);
        this.jCommanderSideRight.setHandler(this);
        this.jCommanderSideLeft.setStorageModels(this.storageModels);
        this.jCommanderSideRight.setStorageModels(this.storageModels);
        this.autoConnects();
        this.reinit();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainApp.this.errorManager.setParent(MainApp.this.getAncesor());
                MainApp.this.documentManager.setParent(MainApp.this.getAncesor());
            }
        });
        this.jCommanderSideLeft.init();
        this.jCommanderSideRight.init();
        this.jCommanderSideLeft.setLastPath();
        this.jCommanderSideRight.setLastPath();
        this.profilesChanged();
        this.selectionChanged();
        this.getLeftSide().makeFocusGain();
    }

    @Override
    public void reconnect() {
        this.reloadModules();
    }

    @Override
    public void openInOpositeWindow(List<String> path, JCommanderSide side) throws Exception {
        if (side == this.jCommanderSideLeft) {
            this.jCommanderSideRight.setPath(path);
        } else {
            this.jCommanderSideLeft.setPath(path);
        }
    }

    @Override
    public void dragBetweenSides(int index, JCommanderSide side) {
        this.operationBar.doCopy();
    }

    @Override
    public boolean canBeDraggedBetweenSides() {
        return this.operationBar.canBeCopied();
    }

    @Override
    public void openPath(List<String> path, boolean oposite, JCommanderSide side) throws Exception {
        String first = side.getPath().get(0);
        path.add(0, first);
        if (side == this.jCommanderSideLeft) {
            if (oposite) {
                this.jCommanderSideRight.setPath(path);
            } else {
                this.jCommanderSideLeft.setPath(path);
            }
        } else if (oposite) {
            this.jCommanderSideLeft.setPath(path);
        } else {
            this.jCommanderSideRight.setPath(path);
        }
    }

    private void updateFileExtensionHandlers() {
        this.documentManager.clearFileExtensionHandlers();
        for (int i = 0; i < this.storageTypesCollection.size(); ++i) {
            StorageTypeInfo info = this.storageTypesCollection.get(i);
            FileExtensionHandlerCollection handlers = info.getStorage().getFileExtensionHandlers();
            if (handlers == null) continue;
            for (int j = 0; j < handlers.size(); ++j) {
                this.documentManager.addFileExtensionHandler(handlers.get(j));
            }
        }
    }

    private void updatePluginCollection() {
        this.pluginCollection.clear();
        for (int i = 0; i < this.storageTypesCollection.size(); ++i) {
            StorageTypeInfo info = this.storageTypesCollection.get(i);
            PluginCollection toAdd = info.getStorage().getPlugins();
            if (toAdd == null) continue;
            this.pluginCollection.add(toAdd);
        }
        this.pluginCollection.add(new BrowseZipFilePlugin());
        this.pluginCollection.add(new OpenInSystemPlugin());
    }

    public CommanderPlugStorageModelCollection getStorageModels() {
        return this.storageModels;
    }

    public void save() throws Exception {
        this.documentManager.saveActual();
        this.getRightSide().reload();
        this.getLeftSide().reload();
    }

    public void compile() throws Exception {
        this.documentManager.compileActual();
        this.getRightSide().reload();
        this.getLeftSide().reload();
    }

    public void saveAll() throws Exception {
        this.documentManager.saveAll();
        this.getRightSide().reload();
        this.getLeftSide().reload();
    }

    public DefaultDocumentManager getDocumentManager() {
        return this.documentManager;
    }

    @Override
    public JFrame getAncesor() {
        return MainApp.getInstanceAncesor();
    }

    public static MainApp getInstance() {
        return mainApp;
    }

    public static JFrame getInstanceAncesor() {
        return (JFrame)SwingUtilities.getWindowAncestor(mainApp);
    }

    public void autoConnectsLater() {
        try {
            for (int i = 0; i < this.profiles.size(); ++i) {
                Profile profile = this.profiles.get(i);
                if (!profile.isAutoConnect()) continue;
                try {
                    profile.connect(this.documentManager);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Cannot autoconnect to the '" + profile.getProfileName() + "' profile", e);
                }
            }
        }
        catch (Exception ex) {
            ErrorManager.notify(ex);
        }
    }

    private void autoConnects() {
        this.autoConnectsLater();
    }

    public void reloadModules() {
        try {
            this.startIt(true, true);
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    public void openModules() throws Exception {
        this.storageTypesCollection = null;
        if (this.profiles != null) {
            this.profiles.disconnectAll();
        }
        this.profiles = null;
        System.gc();
        ModulesPanel modulesPanel = new ModulesPanel((JFrame)SwingUtilities.getWindowAncestor(this), true, this.modulesManager);
        modulesPanel.centerParent();
        modulesPanel.loadModules(this.modules);
        modulesPanel.loadTempDir(this.commanderSettings.getTempDir());
        modulesPanel.setVisible(true);
        this.modules = modulesPanel.saveModules();
        this.commanderSettings.saveModules(this.modules);
        this.commanderSettings.setTempDir(modulesPanel.saveTempDir());
        this.startIt(false, false);
    }

    public void openProfiles() throws Exception {
        ProfilesPanel profilesPanel = new ProfilesPanel((JFrame)SwingUtilities.getWindowAncestor(this), true);
        profilesPanel.setDocumentManager(this.documentManager);
        profilesPanel.setProfiles(this.profiles);
        profilesPanel.setStorageTypes(this.storageTypesCollection);
        profilesPanel.centerParent();
        profilesPanel.fillProfiles();
        profilesPanel.setVisible(true);
        this.commanderSettings.saveProfiles(this.profiles);
        this.reinit();
    }

    public void openSettings() throws Exception {
        SettingsInfo settingsInfo = new SettingsInfo();
        settingsInfo.setTempDir(this.commanderSettings.getTempDir());
        settingsInfo.setJavaPath(this.commanderSettings.getJavaPath());
        settingsInfo.setDateFormat(this.commanderSettings.getDateFormat());
        settingsInfo.setGitEnabled(this.commanderSettings.isGitEnabled());
        settingsInfo.setGitPath(this.commanderSettings.getGitPath());
        settingsInfo.setGitCheckInterval(this.commanderSettings.getGitCheckInterval());
        SimpleDialogWithForm dialogWithForm = new SimpleDialogWithForm((JFrame)SwingUtilities.getWindowAncestor(this), "Settings", settingsInfo, 150, new SettingsInfoElementHandler());
        dialogWithForm.setVisible(true);
        if (dialogWithForm.isOK()) {
            this.commanderSettings.setTempDir(settingsInfo.getTempDir());
            this.commanderSettings.setJavaPath(settingsInfo.getJavaPath());
            this.commanderSettings.setDateFormat(settingsInfo.getDateFormat());
            this.commanderSettings.setGitEnabled(settingsInfo.isGitEnabled());
            this.commanderSettings.setGitPath(settingsInfo.getGitPath());
            this.commanderSettings.setGitCheckInterval(settingsInfo.getGitCheckInterval());
            File tempFile = new File(this.commanderSettings.getTempDir());
            if (!tempFile.exists()) {
                tempFile.mkdir();
            }
        }
    }

    public void openLoginDialog() throws Exception {
        LoginForm login = new LoginForm((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), true);
        login.setDocumentManager(this.documentManager);
        login.centerParent();
        login.fillDialog(this.profiles);
        login.setVisible(true);
        this.reinit();
    }

    public JCommanderSide getLeftSide() {
        return this.jCommanderSideLeft;
    }

    public JCommanderSide getRightSide() {
        return this.jCommanderSideRight;
    }

    public void doOperation(int operationMode, int actionSource, int actionDestination) {
        this.doOperation(operationMode, actionSource, actionDestination, null);
    }

    @Override
    public void doOperation(int operationMode, int actionSource, int actionDestination, String variation) {
        try {
            JCommanderSide source = null;
            JCommanderSide destination = null;
            if (this.leftLastFocus) {
                source = this.getRightSide();
                destination = this.getLeftSide();
            } else {
                source = this.getLeftSide();
                destination = this.getRightSide();
            }
            if (operationMode == 4) {
                this.doNew(actionSource);
            } else if (operationMode == 5) {
                this.doRun(actionSource, variation);
            } else {
                this.operationManager.doOperation(operationMode, source, destination, actionSource, actionDestination);
            }
            source.reload();
            destination.reload();
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    @Override
    public void selectionChanged() {
        JCommanderSide source = null;
        JCommanderSide destination = null;
        if (this.leftLastFocus) {
            source = this.getRightSide();
            destination = this.getLeftSide();
        } else {
            source = this.getLeftSide();
            destination = this.getRightSide();
        }
        try {
            this.operationBar.updateButtons(source.getActualModel(), source.getSelections(), destination.getActualModel(), destination.getSelections());
            this.updateUI();
        }
        catch (Exception ex) {
            ErrorManager.notify(ex);
        }
    }

    public JCommanderSide getFocusedSide() {
        if (this.leftLastFocus) {
            return this.getRightSide();
        }
        return this.getLeftSide();
    }

    public void reload() {
        if (this.leftLastFocus) {
            this.getRightSide().reload();
        } else {
            this.getLeftSide().reload();
        }
    }

    public void goToDefault() throws Exception {
        this.getRightSide().goToDefault();
        this.getLeftSide().goToDefault();
        this.updateUI();
    }

    public void home() throws Exception {
        if (this.leftLastFocus) {
            this.getRightSide().home();
        } else {
            this.getLeftSide().home();
        }
    }

    @Override
    public void focusLost(JCommanderSide side) {
    }

    @Override
    public void focusGained(JCommanderSide side) {
        if (side == this.getLeftSide()) {
            this.leftLastFocus = false;
            this.getRightSide().makeFocusLost();
        } else {
            this.getLeftSide().makeFocusLost();
            this.leftLastFocus = true;
        }
        this.selectionChanged();
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        try {
            switch (code) {
                case 9: {
                    this.tabPressed();
                    break;
                }
                case 114: {
                    this.handler.switchDisplaySides();
                    break;
                }
                case 116: {
                    this.copy();
                    break;
                }
                case 117: {
                    this.move();
                    break;
                }
                case 118: {
                    this.doNewByKey(118);
                    break;
                }
                case 119: 
                case 127: {
                    this.delete();
                    break;
                }
                default: {
                    if (code >= 65 && code <= 90 || code >= 48 && code <= 57) {
                        this.characterPressed(code);
                        break;
                    }
                    this.operationBar.doKey(code);
                    break;
                }
            }
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    @Override
    public void showPopup(Component component, Point point, int onIndex) {
        try {
            if (this.getLeftSide().getCommanderList().hasFocus()) {
                this.getLeftSide().getActualModel().showPopup(component, point, onIndex);
            } else {
                this.getRightSide().getActualModel().showPopup(component, point, onIndex);
            }
        }
        catch (Exception ex) {
            ErrorManager.notify(ex);
        }
    }

    private void characterPressed(int code) {
        this.keyBuffer.keyPressed(code);
    }

    @Override
    public void keyBufferTextEvent(String string) {
        if (this.getLeftSide().getCommanderList().hasFocus()) {
            this.getLeftSide().moveToItemStartWith(string);
        } else {
            this.getRightSide().moveToItemStartWith(string);
        }
    }

    private void tabPressed() {
        if (this.getLeftSide().getCommanderList().hasFocus()) {
            this.getRightSide().makeFocusGain();
        } else {
            this.getLeftSide().makeFocusGain();
        }
    }

    public void reinit() throws Exception {
        this.reinitMenus();
    }

    public void reinitMenus() throws Exception {
        for (JMenuItem item : this.menuItemsToRemove) {
            this.menuBar.remove(item);
        }
        for (int i = 0; i < this.profiles.size(); ++i) {
            JMenu menu;
            Profile profile = this.profiles.get(i);
            if (!profile.isConnected() || (menu = profile.getCommanderPlugStorageModel().getMenu(profile.getProfileName())) == null) continue;
            this.menuBar.add(menu);
            this.menuItemsToRemove.add(menu);
        }
        this.menuBar.updateUI();
    }

    public void copy() {
        this.doOperation(0, -1, -1);
    }

    public void move() {
        this.doOperation(1, 0, 0);
    }

    public void link() {
        this.doOperation(6, 0, 0);
    }

    public void delete() {
        this.doOperation(2, 0, 0);
    }

    public void reloadBothSides() {
        this.jCommanderSideLeft.reload();
        this.jCommanderSideRight.reload();
    }

    public void doNewByKey(int actionKey) throws Exception {
        CommanderPlugModel model = this.getFocusedSide().getActualModel();
        for (int i = 0; i < model.getNumberOfActions(); ++i) {
            if (model.getActionType(i) != 0 || model.getActionKey(i) != actionKey || !model.checkNew(i)) continue;
            this.doNew(i);
            return;
        }
    }

    public void doNew(int action) {
        try {
            JCommanderSide focusedSide = this.getFocusedSide();
            focusedSide.getActualModel().doNew((JFrame)SwingUtilities.getWindowAncestor(this), action);
            focusedSide.reload();
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    public void doRun(int action, String variation) {
        try {
            JCommanderSide focusedSide = this.getFocusedSide();
            focusedSide.getActualModel().doRun((JFrame)SwingUtilities.getWindowAncestor(this), action, variation);
            focusedSide.reload();
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    private void initComponents() {
        this.renderToolBarPlugins();
        this.panelContent = new JPanel(new BorderLayout());
        this.panelButtons = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelContent, "Center");
        this.add((Component)this.panelButtons, "Last");
    }

    public ProfileCollection getProfiles() {
        return this.profiles;
    }

    public void setProfiles(ProfileCollection profiles) {
        this.profiles = profiles;
    }

    public JNodeCommanderHandler getHandler() {
        return this.handler;
    }

    public void setHandler(JNodeCommanderHandler handler) {
        this.handler = handler;
    }

    @Override
    public void changeState(boolean saveEnabled, boolean saveAllEnabled) {
        this.handler.changeState(saveEnabled, saveAllEnabled);
    }

    @Override
    public void reloadSides() {
        this.getLeftSide().reload();
        this.getRightSide().reload();
    }

    public CommanderSettings getCommanderSettings() {
        return this.commanderSettings;
    }

    public void setCommanderSettings(CommanderSettings commanderSettings) {
        this.commanderSettings = commanderSettings;
    }
}

