/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.document;

import com.browsersoft.commander.commanderwindow.JNodeCommanderAppLayout;
import com.browsersoft.commander.commanderwindow.JNodeCommanderAppLayoutHandler;
import com.browsersoft.commander.commanderwindow.MainApp;
import com.browsersoft.commander.commanderwindow.document.ExtensionIconFinder;
import com.browsersoft.commander.commanderwindow.document.SaveDocumentQuestionDialog;
import com.browsersoft.commander.commanderwindow.operation.OperationManager;
import com.browsersoft.commander.commanderwindow.settings.CommanderSettings;
import com.browsersoft.commander.model.CommanderPlugDocument;
import com.browsersoft.commander.model.CommanderPlugDocumentCollection;
import com.browsersoft.commander.model.CommanderPlugStorageModelCollection;
import com.browsersoft.commander.model.DocumentManager;
import com.browsersoft.commander.model.DocumentManagerHandler;
import com.browsersoft.commander.model.FileExtensionHandler;
import com.browsersoft.commander.model.FlavouredItem;
import com.browsersoft.commander.utils.FileUtils;
import java.awt.Desktop;
import java.awt.Frame;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class DefaultDocumentManager
implements DocumentManager,
JNodeCommanderAppLayoutHandler {
    private OperationManager operationManager;
    private ExtensionIconFinder extensionIconFinder;
    private JNodeCommanderAppLayout appLayout;
    private DocumentManagerHandler handler;
    private Frame parent;
    private MainApp parentNodeCommander;
    private Map<String, FileExtensionHandler> fileExtensionHandlers;
    private CommanderSettings commanderSettings;
    private CommanderPlugDocumentCollection collection = new CommanderPlugDocumentCollection();

    public DefaultDocumentManager() {
        this.extensionIconFinder = new ExtensionIconFinder(this.getTempDirectory());
        this.fileExtensionHandlers = new HashMap<String, FileExtensionHandler>();
    }

    @Override
    public CommanderPlugStorageModelCollection getActualStorageModels() {
        return this.parentNodeCommander.getStorageModels();
    }

    @Override
    public DocumentManagerHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(DocumentManagerHandler handler) {
        this.handler = handler;
    }

    @Override
    public void saveActual() throws Exception {
        CommanderPlugDocument document = this.appLayout.getActualDocument();
        if (document != null) {
            document.save();
        }
        this.updateSaveStates();
    }

    public void compileActual() throws Exception {
        CommanderPlugDocument document = this.appLayout.getActualDocument();
        if (document != null) {
            document.compile();
        }
        this.updateSaveStates();
    }

    private boolean getSaveState() {
        CommanderPlugDocument document = this.appLayout.getActualDocument();
        if (document != null) {
            return document.isItChanged();
        }
        return false;
    }

    private boolean getSaveAllState() {
        CommanderPlugDocumentCollection documents = this.appLayout.getAllDocuments();
        if (documents.size() > 0) {
            for (int i = 0; i < documents.size(); ++i) {
                if (!documents.get(i).isItChanged()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void updateSaveStates() {
        this.handler.changeState(this.getSaveState(), this.getSaveAllState());
        this.appLayout.updateTitles();
    }

    @Override
    public void somethingInTabsChanged() {
        this.updateSaveStates();
    }

    @Override
    public void documentChanged(CommanderPlugDocument commanderPlugDocument) {
        this.updateSaveStates();
    }

    @Override
    public boolean documentClosing(CommanderPlugDocument document) throws Exception {
        if (document.isItChanged()) {
            SaveDocumentQuestionDialog dialog = new SaveDocumentQuestionDialog(this.parent, true, "Document " + document.getTitle() + " was changed. Do you want to save it?");
            dialog.centerParent();
            dialog.setVisible(true);
            switch (dialog.getResult()) {
                case 0: {
                    return false;
                }
                case 1: {
                    this.collection.remove(document);
                    return true;
                }
                case 2: {
                    this.collection.remove(document);
                    document.save();
                    return true;
                }
            }
        }
        this.collection.remove(document);
        return true;
    }

    public void closeActiveDocument() throws Exception {
        CommanderPlugDocument actualDocument = this.appLayout.getActualDocument();
        if (actualDocument != null) {
            this.closeTabWithDocument(actualDocument);
        }
    }

    public void closeAll() throws Exception {
    }

    @Override
    public void saveAll() throws Exception {
        CommanderPlugDocumentCollection documents = this.appLayout.getAllDocuments();
        for (int i = 0; i < documents.size(); ++i) {
            documents.get(i).save();
        }
        this.updateSaveStates();
    }

    @Override
    public String getTempDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    @Override
    public void openInSystem(File file) throws Exception {
        try {
            String extension = FileUtils.getExtension(file.getName()).toLowerCase();
            if (this.fileExtensionHandlers.containsKey(extension)) {
                this.fileExtensionHandlers.get(extension).openFile(file);
            } else {
                Desktop.getDesktop().open(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void openURLInSystem(String s) throws Exception {
        try {
            Desktop.getDesktop().browse(new URI(s));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void copyToTempAndOpenInSystem(FlavouredItem flavouredItem) throws Exception {
        this.operationManager.doCopyToTempAndOpen(flavouredItem);
    }

    @Override
    public File copyToTemp(FlavouredItem flavouredItem) throws Exception {
        return this.operationManager.doCopyToTemp(flavouredItem);
    }

    public void setLayout(JNodeCommanderAppLayout appLayout) {
        appLayout.setHandler(this);
        this.appLayout = appLayout;
    }

    @Override
    public void openDocument(CommanderPlugDocument commanderPlugDocument) throws Exception {
        this.collection.add(commanderPlugDocument);
        this.appLayout.addTab(commanderPlugDocument);
        commanderPlugDocument.setHandler(this);
    }

    @Override
    public void closeTabWithDocument(CommanderPlugDocument commanderPlugDocument) throws Exception {
        this.documentClosing(commanderPlugDocument);
        this.appLayout.removeTab();
    }

    @Override
    public CommanderPlugDocumentCollection getDocuments() {
        return this.collection;
    }

    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    public void setOperationManager(OperationManager operationManager) {
        this.operationManager = operationManager;
    }

    public ExtensionIconFinder getExtensionIconFinder() {
        return this.extensionIconFinder;
    }

    public void setExtensionIconFinder(ExtensionIconFinder extensionIconFinder) {
        this.extensionIconFinder = extensionIconFinder;
    }

    @Override
    public Icon getIconForExtension(String string) {
        if (this.fileExtensionHandlers.containsKey(string)) {
            return this.fileExtensionHandlers.get(string).getIcon();
        }
        return this.extensionIconFinder.getIconForExtension(string);
    }

    @Override
    public Frame getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Frame parent) {
        this.parent = parent;
    }

    public MainApp getParentNodeCommander() {
        return this.parentNodeCommander;
    }

    public void setParentNodeCommander(MainApp parentNodeCommander) {
        this.parentNodeCommander = parentNodeCommander;
    }

    @Override
    public void addFileExtensionHandler(FileExtensionHandler fileExtensionHandler) {
        if (this.fileExtensionHandlers.containsKey(fileExtensionHandler.getExtension())) {
            this.fileExtensionHandlers.remove(fileExtensionHandler.getExtension());
        }
        this.fileExtensionHandlers.put(fileExtensionHandler.getExtension(), fileExtensionHandler);
    }

    @Override
    public void clearFileExtensionHandlers() {
        this.fileExtensionHandlers.clear();
    }

    @Override
    public CommanderSettings getCommanderSettings() {
        return this.commanderSettings;
    }

    public void setCommanderSettings(CommanderSettings commanderSettings) {
        this.commanderSettings = commanderSettings;
    }
}

