/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.error;

import com.browsersoft.commander.commanderwindow.MainApp;
import com.browsersoft.commander.utils.CenteredDialog;
import com.browsersoft.commander.utils.StreamUtils;
import com.browsersoft.commander.utils.swing.KeyBuffer;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class ExceptionDialog
extends CenteredDialog {
    private MainApp gui;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel lblIcon;
    private JLabel lblMessage;
    private JButton okButton;
    private JScrollPane scrollPane;
    private JTextArea textException;

    public ExceptionDialog(Frame parent, boolean modal, Exception e, MainApp gui) {
        super(parent, modal);
        this.gui = gui;
        this.initComponents();
        String error = e.getMessage();
        String details = StreamUtils.getExceptionStack(e);
        if (error != null && error.length() > 100) {
            error = error.substring(0, 100) + "...";
            details = error + "\n" + details;
        }
        this.lblMessage.setText("<html>" + error + "</html>");
        this.setCustomText(details);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExceptionDialog.this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
            }
        });
    }

    public void setCustomText(String text) {
        this.textException.setText(text);
        this.scrollPane.setVisible(text != null && !text.trim().isEmpty());
        this.pack();
    }

    private void defaultView() throws Exception {
        this.gui.goToDefault();
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.textException = new JTextArea();
        this.lblIcon = new JLabel();
        this.lblMessage = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Exception");
        this.setResizable(false);
        this.okButton.setText("OK");
        this.okButton.addActionListener(evt -> this.okButtonActionPerformed(evt));
        KeyBuffer.installKey(this.getRootPane(), 27, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionDialog.this.okButton.doClick();
            }
        });
        this.textException.setColumns(20);
        this.textException.setLineWrap(true);
        this.textException.setRows(5);
        this.textException.setEditable(false);
        this.textException.setBackground(Color.WHITE);
        this.scrollPane.setViewportView(this.textException);
        this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/error/error.png")));
        this.lblMessage.setHorizontalAlignment(0);
        this.lblMessage.setHorizontalTextPosition(0);
        this.jButton1.setText("Close application");
        this.jButton1.addActionListener(evt -> this.jButton1ActionPerformed(evt));
        this.jButton2.setText("jButton2");
        this.jButton3.setText("Default view");
        this.jButton3.addActionListener(evt -> this.jButton3ActionPerformed(evt));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -2, 509, -2).addGroup(layout.createSequentialGroup().addComponent(this.lblIcon).addGap(17, 17, 17).addComponent(this.lblMessage, -2, 460, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 204, Short.MAX_VALUE).addComponent(this.okButton, -2, 93, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMessage, -1, 32, Short.MAX_VALUE).addComponent(this.lblIcon)).addGap(28, 28, 28).addComponent(this.scrollPane, -2, 167, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.okButton).addComponent(this.jButton3)).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        try {
            this.defaultView();
            this.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

