/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.filesystem;

import com.browsersoft.commander.commanderwindow.filesystem.DirectoryAdapterItem;
import com.browsersoft.commander.commanderwindow.filesystem.DiscAdapterItem;
import com.browsersoft.commander.commanderwindow.filesystem.FileAdapterItem;
import com.browsersoft.commander.commanderwindow.filesystem.FileSystemAdapterItemCollection;
import com.browsersoft.commander.commanderwindow.filesystem.actions.DirectoryDeleteAction;
import com.browsersoft.commander.commanderwindow.filesystem.actions.DirectoryImportAction;
import com.browsersoft.commander.commanderwindow.filesystem.actions.FileDeleteAction;
import com.browsersoft.commander.commanderwindow.filesystem.actions.FileImportAction;
import com.browsersoft.commander.commanderwindow.filesystem.actions.FilesAndDirectoriesExportAction;
import com.browsersoft.commander.commanderwindow.filesystem.actions.NewDirectoryAction;
import com.browsersoft.commander.model.adapter.AdapterActionCollection;
import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.AdapterItemCollection;
import com.browsersoft.commander.model.adapter.AdapterPath;
import com.browsersoft.commander.model.adapter.CommanderAdapter;
import java.io.File;
import java.io.IOException;

public class FileSystemAdapter
extends CommanderAdapter {
    private AdapterActionCollection actions = new AdapterActionCollection();

    public FileSystemAdapter() {
        this.actions.add(new NewDirectoryAction());
        this.actions.add(new FileImportAction());
        this.actions.add(new DirectoryImportAction());
        this.actions.add(new FilesAndDirectoriesExportAction());
        this.actions.add(new DirectoryDeleteAction());
        this.actions.add(new FileDeleteAction());
    }

    @Override
    public AdapterItemCollection go(AdapterPath path) throws Exception {
        FileSystemAdapterItemCollection collection = new FileSystemAdapterItemCollection();
        if (path.size() == 0) {
            this.createRootCollection(collection);
            return collection;
        }
        AdapterItem last = path.getLast();
        if (last instanceof FileAdapterItem) {
            return null;
        }
        if (last instanceof DiscAdapterItem) {
            this.createListInDir(collection, ((DiscAdapterItem)last).getFile());
        } else if (last instanceof DirectoryAdapterItem) {
            this.createListInDir(collection, ((DirectoryAdapterItem)last).getFile());
        }
        collection.setActions(this.actions);
        return collection;
    }

    public void createRootCollection(AdapterItemCollection collection) throws IOException {
        File[] list = File.listRoots();
        for (int i = 0; i < list.length; ++i) {
            File file = list[i];
            collection.add(new DiscAdapterItem(file));
            if (!file.getAbsolutePath().equalsIgnoreCase("C:\\")) continue;
            collection.setInitIndex(i);
        }
    }

    public void createListInDir(AdapterItemCollection collection, File dir) throws IOException {
        try {
            File[] list = dir.listFiles();
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.length; ++i) {
                File file = list[i];
                if (file.isDirectory()) {
                    if (file.getName().equals("..")) continue;
                    collection.add(new DirectoryAdapterItem(file));
                    continue;
                }
                collection.add(new FileAdapterItem(file, this.getDocumentManager()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

