/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.filesystem.actions;

import com.browsersoft.commander.commanderwindow.filesystem.DirectoryAdapterItem;
import com.browsersoft.commander.commanderwindow.filesystem.DiscAdapterItem;
import com.browsersoft.commander.model.FileFlavour;
import com.browsersoft.commander.model.FlavouredItem;
import com.browsersoft.commander.model.OperationWorkerHandler;
import com.browsersoft.commander.model.adapter.ActionUtils;
import com.browsersoft.commander.model.adapter.AdapterPath;
import com.browsersoft.commander.model.adapter.SimpleImportAdapterAction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class FileImportAction
extends SimpleImportAdapterAction {
    @Override
    public String getFlavourType() {
        return "com.browsersoft.commander.model.FileFlavour";
    }

    @Override
    public void importItem(FlavouredItem item, AdapterPath path, OperationWorkerHandler handler) throws Exception {
        FileFlavour fileFlavour = (FileFlavour)item.getSelectedFlavourAsObject();
        File outputFile = this.getDestinationFile(item, path);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        ActionUtils.inputStreamToOutputStreamWithHandler((InputStream)fileFlavour.openInputStream(), new FileOutputStream(outputFile), handler, fileFlavour.getByteSize());
    }

    @Override
    public boolean existItem(FlavouredItem item, AdapterPath path) throws Exception {
        return this.getDestinationFile(item, path).exists();
    }

    private File getDestinationFile(FlavouredItem item, AdapterPath path) {
        String absolutePath = "";
        absolutePath = path.getLast() instanceof DirectoryAdapterItem ? ((DirectoryAdapterItem)path.getLast()).getFile().getAbsolutePath() : ((DiscAdapterItem)path.getLast()).getFile().getAbsolutePath();
        return new File(absolutePath, item.getNewName());
    }
}

