/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.modules;

import com.browsersoft.commander.utils.DOMUtils;
import com.browsersoft.commander.utils.StreamUtils;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BuildInPluginsManager {
    protected static final Logger log = Logger.getLogger(BuildInPluginsManager.class.getName());
    protected static final String XML_RESOURCE_PATH = "/com/browsersoft/commander/commanderwindow/modules/BuildInPlugins.xml";
    protected static final String PLUGIN_TAG_NAME = "plugin";
    protected static final String PLUGIN_TAG_CLASS_PARAMETER = "class";
    protected static final String PROFILES_PREFIX_PARAMETER = "profilesPrefix";
    protected static String profilesPrefix;
    protected static Map<Class, Object> plugins;

    public static void init() throws Exception {
        String xml = BuildInPluginsManager.loadResourceXML(XML_RESOURCE_PATH);
        if (xml == null) {
            throw new Exception("BuildInPlugins.xml resource not found!");
        }
        Element root = DOMUtils.loadFromString(xml).getDocumentElement();
        profilesPrefix = DOMUtils.getParameter(root, PROFILES_PREFIX_PARAMETER);
        NodeList childs = root.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            String className;
            Node child = childs.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(PLUGIN_TAG_NAME) || (className = DOMUtils.getParameter(child, PLUGIN_TAG_CLASS_PARAMETER)) == null || className.isEmpty()) continue;
            Class<?> pluginClass = Class.forName(className);
            if (pluginClass == null) {
                throw new Exception("Plugin '" + className + "' is not class!");
            }
            try {
                log.info("Loading plugin '" + className + "'");
                Constructor<?> constructor = pluginClass.getConstructors()[0];
                Object plugin = constructor.newInstance(new Object[0]);
                plugins.put(pluginClass, plugin);
                continue;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error while loading plugin '" + className + "'", e);
            }
        }
    }

    protected static String loadResourceXML(String resource) throws Exception {
        InputStream inputStream = BuildInPluginsManager.class.getResourceAsStream(resource);
        if (inputStream == null) {
            return null;
        }
        return StreamUtils.loadInputStreamToString(inputStream, "UTF-8");
    }

    public static String getProfilesPrefix() {
        return profilesPrefix;
    }

    public static Set<Class> getPluginsClasses() {
        return BuildInPluginsManager.getPluginsClasses(null);
    }

    public static Set<Class> getPluginsClasses(Class parentClass) {
        LinkedHashSet<Class> ret = new LinkedHashSet<Class>();
        for (Class pluginClass : plugins.keySet()) {
            if (parentClass != null && !parentClass.isAssignableFrom(pluginClass)) continue;
            ret.add(pluginClass);
        }
        return ret;
    }

    public static <T> Set<T> getPlugins(Class<T> parentClass) {
        LinkedHashSet<Object> ret = new LinkedHashSet<Object>();
        for (Object plugin : plugins.values()) {
            if (!parentClass.isInstance(plugin)) continue;
            ret.add(plugin);
        }
        return ret;
    }

    static {
        plugins = new LinkedHashMap<Class, Object>();
    }
}

