/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.modules;

import com.browsersoft.commander.commanderwindow.modules.ModuleInfo;
import com.browsersoft.commander.commanderwindow.modules.ModuleInfoCollection;
import java.beans.IntrospectionException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class ModulesNode {
    private static final String COUNT = "count";
    private static final String MODULE_ID = "moduleId";
    private static final String MODULE_NAME = "moduleName";
    private static final String MODULE_URL = "moduleURL";
    private static final String MODULE_USER = "moduleUser";
    private static final String MODULE_PASSWORD = "modulePassword";
    private static final String MODULE_AUTO_UPDATE = "moduleAutoUpdate";
    private static final String MODULE_CLASS_NAME = "moduleClassName";
    private static final String MODULE_JARS = "moduleJars";
    private static final String PROFILES_COUNT = "profilesCount";
    private static final String PROFILE_NAME = "profileName";
    private static final String PROFILE_CLASS = "profileClass";
    private static final String PROFILE_AUTO_CONNECT = "autoConnect";
    private static final String TEMP_DIR = "tempDir";
    Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    private String modulePrefix = "";

    public void setTempDir(String tempDir) throws IOException {
        if (tempDir.equals("")) {
            tempDir = ModulesNode.getTempDirectory().getAbsolutePath();
        }
        this.preferences.put(TEMP_DIR, tempDir);
    }

    public String getTempDir() throws IOException {
        File tempFile;
        Object temp;
        if (this.preferences.get(TEMP_DIR, "").equals("")) {
            temp = ModulesNode.getTempDirectory();
            this.preferences.put(TEMP_DIR, ((File)temp).getAbsolutePath());
        }
        if (!(tempFile = new File((String)(temp = this.preferences.get(TEMP_DIR, "")) + "/")).exists() && !tempFile.mkdir()) {
            throw new IOException();
        }
        return tempFile.getAbsolutePath();
    }

    private static File getTempDirectory() throws IOException {
        File tempFile = File.createTempFile("MainApp", "", null);
        tempFile.delete();
        tempFile = new File(tempFile.getAbsolutePath() + "/");
        if (!tempFile.exists() && !tempFile.mkdir()) {
            throw new IOException();
        }
        return tempFile;
    }

    public void exportPreferences(String FilePath) throws BackingStoreException, IOException {
        this.preferences.exportSubtree(new FileOutputStream(FilePath));
    }

    public void importPreferences(String FilePath) throws IOException, InvalidPreferencesFormatException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(FilePath));
        Preferences.importPreferences(is);
    }

    public ModuleInfoCollection load() throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        ModuleInfoCollection modules = new ModuleInfoCollection();
        int count = this.preferences.getInt(this.modulePrefix + COUNT, 0);
        for (int i = 0; i < count; ++i) {
            ModuleInfo moduleInfo = new ModuleInfo();
            moduleInfo.setName(this.preferences.get(this.modulePrefix + MODULE_NAME + "_" + i, ""));
            moduleInfo.setUrl(this.preferences.get(this.modulePrefix + MODULE_URL + "_" + i, ""));
            moduleInfo.setUser(this.preferences.get(this.modulePrefix + MODULE_USER + "_" + i, ""));
            moduleInfo.setId(this.preferences.get(this.modulePrefix + MODULE_ID + "_" + i, ""));
            moduleInfo.setPassword(this.preferences.get(this.modulePrefix + MODULE_PASSWORD + "_" + i, ""));
            moduleInfo.setAutoCheckUpdate(this.preferences.getBoolean(this.modulePrefix + MODULE_AUTO_UPDATE + "_" + i, false));
            moduleInfo.setClassName(this.preferences.get(this.modulePrefix + MODULE_CLASS_NAME + "_" + i, "").split(","));
            moduleInfo.setJars(this.preferences.get(this.modulePrefix + MODULE_JARS + "_" + i, "").split(","));
            modules.add(moduleInfo);
        }
        return modules;
    }

    public void save(ModuleInfoCollection modules) throws IntrospectionException, IllegalAccessException, InvocationTargetException, BackingStoreException {
        this.preferences.putInt(this.modulePrefix + COUNT, modules.size());
        for (int i = 0; i < modules.size(); ++i) {
            ModuleInfo moduleInfo = modules.get(i);
            this.preferences.put(this.modulePrefix + MODULE_NAME + "_" + i, moduleInfo.getName());
            this.preferences.put(this.modulePrefix + MODULE_URL + "_" + i, moduleInfo.getUrl());
            this.preferences.put(this.modulePrefix + MODULE_USER + "_" + i, moduleInfo.getUser());
            this.preferences.put(this.modulePrefix + MODULE_PASSWORD + "_" + i, moduleInfo.getPassword());
            this.preferences.put(this.modulePrefix + MODULE_ID + "_" + i, moduleInfo.getId());
            this.preferences.putBoolean(this.modulePrefix + MODULE_AUTO_UPDATE + "_" + i, moduleInfo.isAutoCheckUpdate());
            String[] jars = moduleInfo.getJars();
            StringBuffer buffer = new StringBuffer();
            for (int j = 0; j < jars.length; ++j) {
                buffer.append(jars[j]);
                if (j == jars.length - 1) continue;
                buffer.append(",");
            }
            this.preferences.put(this.modulePrefix + MODULE_JARS + "_" + i, buffer.toString());
            String[] classes = moduleInfo.getClassNames();
            StringBuffer buffer2 = new StringBuffer();
            for (int j = 0; j < classes.length; ++j) {
                buffer2.append(classes[j]);
                if (j == classes.length - 1) continue;
                buffer2.append(",");
            }
            this.preferences.put(this.modulePrefix + MODULE_CLASS_NAME + "_" + i, buffer2.toString());
        }
    }
}

