/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.operation;

import com.browsersoft.commander.model.adapter.ActionUtils;
import com.browsersoft.commander.utils.swing.CenteredDialog;
import com.browsersoft.commander.utils.swing.KeyBuffer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class OneItemCopyDialog
extends CenteredDialog {
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_OK = 1;
    private int resultType;
    private JButton buttonCancel;
    private JButton buttonOK;
    private JLabel lblFrom;
    private JLabel lblRenameTo;
    private JLabel lblTo;
    private JTextField txtNewName;
    private JLabel errorTextField;

    public OneItemCopyDialog(Frame parent, boolean modal, String from, String to, String name) {
        super(parent, modal);
        this.initComponents();
        from = from.replaceAll("\\\\", "/");
        from = from.replaceAll("//", "/");
        to = to.replaceAll("\\\\", "/");
        to = to.replaceAll("//", "/");
        this.lblFrom.setText("Item: " + from);
        this.lblTo.setText("To: " + to);
        this.txtNewName.setText(name);
        this.errorTextField.setFont(new Font("Arial Unicode MS", 0, 12));
        this.errorTextField.setForeground(Color.RED);
        this.errorTextField.setVisible(false);
    }

    public String getNewName() {
        return this.txtNewName.getText();
    }

    private void showErrorMsg(String text) {
        this.errorTextField.setText(text);
        this.errorTextField.setVisible(true);
        this.revalidate();
        this.pack();
    }

    public void doOK() {
        if (!ActionUtils.isValidActionDialogInput(this.txtNewName.getText())) {
            this.showErrorMsg("Input element cannot be empty or contain forbidden characters.");
            return;
        }
        this.resultType = 1;
        this.dispose();
    }

    public void doCancel() {
        this.resultType = 0;
        this.dispose();
    }

    private void initComponents() {
        this.lblFrom = new JLabel();
        this.lblTo = new JLabel();
        this.txtNewName = new JTextField();
        this.errorTextField = new JLabel();
        this.lblRenameTo = new JLabel();
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Dialog");
        this.setResizable(false);
        this.lblFrom.setText("Item:");
        this.lblTo.setText("To:");
        this.txtNewName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                OneItemCopyDialog.this.txtNewNameKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                OneItemCopyDialog.this.txtNewNameKeyReleased(evt);
            }
        });
        this.lblRenameTo.setText("Rename:");
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(evt -> this.doOK());
        this.buttonOK.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                OneItemCopyDialog.this.buttonOKKeyPressed(evt);
            }
        });
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(evt -> this.doCancel());
        this.buttonCancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                OneItemCopyDialog.this.buttonCancelKeyPressed(evt);
            }
        });
        KeyBuffer.installKey(this.getRootPane(), 27, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneItemCopyDialog.this.doCancel();
            }
        });
        KeyBuffer.installKey(this.getRootPane(), 10, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneItemCopyDialog.this.doOK();
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTo, -2, 380, Integer.MAX_VALUE).addComponent(this.lblFrom, -2, 380, Integer.MAX_VALUE).addComponent(this.txtNewName, -2, 380, Integer.MAX_VALUE).addComponent(this.errorTextField, -2, 380, Integer.MAX_VALUE).addComponent(this.lblRenameTo).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOK, -2, 66, -2).addGap(13, 13, 13).addComponent(this.buttonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblFrom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblTo).addGap(19, 19, 19).addComponent(this.lblRenameTo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtNewName, -2, -1, -2).addGap(5).addComponent(this.errorTextField, -2, -1, -2).addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void txtNewNameKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.doOK();
        } else if (evt.getKeyCode() == 27) {
            this.doCancel();
        }
    }

    private void txtNewNameKeyReleased(KeyEvent evt) {
    }

    private void buttonCancelKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.doCancel();
        } else if (evt.getKeyCode() == 27) {
            this.doCancel();
        }
    }

    private void buttonOKKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.doOK();
        } else if (evt.getKeyCode() == 27) {
            this.doCancel();
        }
    }

    public int getResultType() {
        return this.resultType;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }
}

