/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.operation;

import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.commanderwindow.operation.OperationBarHandler;
import com.browsersoft.commander.commanderwindow.operation.OperationExecuter;
import com.browsersoft.commander.commanderwindow.operation.PairOfFlavours;
import com.browsersoft.commander.customEditor.DiffEditor;
import com.browsersoft.commander.customEditor.DiffNode;
import com.browsersoft.commander.model.CommanderPlugModel;
import com.browsersoft.commander.model.FileFlavour;
import com.browsersoft.commander.model.Flavour;
import com.browsersoft.commander.model.FlavouredItem;
import com.browsersoft.commander.model.FlavouredItemCollection;
import com.browsersoft.commander.model.adapter.AdapterAction;
import com.browsersoft.commander.model.adapter.CompareAction;
import com.browsersoft.commander.utils.StreamUtils;
import com.browsersoft.commander.utils.swing.ButtonPanel;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class OperationBar
extends ButtonPanel {
    private JButton buttonCopy;
    private JButton buttonMove;
    private JButton buttonLink;
    private JButton buttonNew;
    private JButton buttonDelete;
    private JButton buttonDeleteDisabled;
    private JMenuItem menuItemCopy;
    private JMenuItem menuItemDelete;
    private JMenuItem menuItemDeleteDisabled;
    private JMenuItem menuItemMove;
    private JMenuItem menuItemLink;
    private JMenuItem menuItemNew;
    private JButton test = new JButton();
    private JMenu menuOperations;
    private OperationBarHandler handler;
    private boolean showCopy;
    private boolean showDelete;
    private boolean showMove;
    private boolean showLink;
    private Map<Integer, OperationExecuter> keyExecuters = new HashMap<Integer, OperationExecuter>();

    public OperationBar(JMenu menuOperations) {
        this.menuOperations = menuOperations;
        this.buttonCopy = new JButton();
        this.buttonMove = new JButton();
        this.buttonNew = new JButton();
        this.buttonDelete = new JButton();
        this.buttonDeleteDisabled = new JButton();
        this.buttonLink = new JButton();
        this.menuItemCopy = new JMenuItem();
        this.menuItemDelete = new JMenuItem();
        this.menuItemDeleteDisabled = new JMenuItem();
        this.menuItemMove = new JMenuItem();
        this.menuItemLink = new JMenuItem();
        this.menuItemNew = new JMenuItem();
        this.buttonCopy.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/icons/copy.png")));
        this.buttonCopy.setText("F5 Copy");
        this.buttonCopy.setFont(new Font("Arial", 0, 11));
        this.buttonCopy.setMargin(new Insets(2, 4, 2, 4));
        this.buttonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationBar.this.doOperation(0, -1, -1);
            }
        });
        this.buttonMove.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/icons/copy.png")));
        this.buttonMove.setText("F6 Move");
        this.buttonMove.setFont(new Font("Arial", 0, 11));
        this.buttonMove.setMargin(new Insets(2, 4, 2, 4));
        this.buttonMove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationBar.this.doOperation(1, 0, 0);
            }
        });
        this.buttonLink.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/icons/link.png")));
        this.buttonLink.setText("F9 Link");
        this.buttonLink.setFont(new Font("Arial", 0, 11));
        this.buttonLink.setMargin(new Insets(2, 4, 2, 4));
        this.buttonLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationBar.this.doOperation(6, 0, 0);
            }
        });
        this.buttonDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/icons/delete.png")));
        this.buttonDelete.setText("F8 Delete");
        this.buttonDelete.setFont(new Font("Arial", 0, 11));
        this.buttonDelete.setMargin(new Insets(2, 4, 2, 4));
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationBar.this.doOperation(2, 0, 0);
            }
        });
        this.buttonDeleteDisabled.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/icons/delete.png")));
        this.buttonDeleteDisabled.setText("F8 Delete");
        this.buttonDeleteDisabled.setFont(new Font("Arial", 0, 11));
        this.buttonDeleteDisabled.setMargin(new Insets(2, 4, 2, 4));
        this.buttonDeleteDisabled.setEnabled(false);
        this.menuItemCopy.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.menuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/icons/copy.png")));
        this.menuItemCopy.setText("Copy");
        this.menuItemCopy.setFont(new Font("Arial", 0, 11));
        this.menuItemCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationBar.this.doCopy();
            }
        });
        this.menuItemMove.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.menuItemMove.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/icons/copy.png")));
        this.menuItemMove.setText("Move");
        this.menuItemMove.setFont(new Font("Arial", 0, 11));
        this.menuItemMove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationBar.this.doOperation(1, 0, 0);
            }
        });
        this.menuItemLink.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        this.menuItemLink.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/icons/copy.png")));
        this.menuItemLink.setText("Link");
        this.menuItemLink.setFont(new Font("Arial", 0, 11));
        this.menuItemLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationBar.this.doOperation(6, 0, 0);
            }
        });
        this.menuItemDelete.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.menuItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/icons/delete.png")));
        this.menuItemDelete.setText("Delete");
        this.menuItemDelete.setFont(new Font("Arial", 0, 11));
        this.menuItemDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationBar.this.doOperation(2, 0, 0);
            }
        });
        this.menuItemDeleteDisabled.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.menuItemDeleteDisabled.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/icons/delete.png")));
        this.menuItemDeleteDisabled.setText("Delete");
        this.menuItemDeleteDisabled.setFont(new Font("Arial", 0, 11));
        this.menuItemDeleteDisabled.setEnabled(false);
    }

    public void doCopy() {
        this.doOperation(0, -1, -1);
    }

    private void doOperation(int type, int actionSource, int actionDestination) {
        this.doOperation(type, actionSource, actionDestination, null);
    }

    private void doOperation(int type, int actionSource, int actionDestination, String variation) {
        if (this.handler != null) {
            this.handler.doOperation(type, actionSource, actionDestination, variation);
        }
    }

    public void updateButtons(CommanderPlugModel focused, int[] selection, CommanderPlugModel nonFocused, int[] nonFocusedSelection) throws Exception {
        this.showCopy = this.checkAction(focused, selection, nonFocused, -1, -1);
        this.showDelete = this.checkDelete(focused, selection);
        this.showMove = this.checkMove(focused, selection, nonFocused);
        this.showLink = this.checkLink(focused, selection, nonFocused);
        boolean showDisableDelete = this.checkDeleteShowDisabled(focused, selection);
        this.updateControls(this.showCopy, this.showDelete, this.showMove, showDisableDelete);
        this.updateActions(focused, selection, nonFocused, nonFocusedSelection);
        this.updateUI();
        this.menuOperations.updateUI();
    }

    public boolean canBeCopied() {
        return this.showCopy;
    }

    private void updateActions(CommanderPlugModel focused, int[] selection, CommanderPlugModel nonFocused, int[] nonFocusedSelection) throws Exception {
        this.keyExecuters = new HashMap<Integer, OperationExecuter>();
        block11: for (int actionNumber = 0; actionNumber < nonFocused.getNumberOfActions(); ++actionNumber) {
            switch (nonFocused.getActionType(actionNumber)) {
                case 1: {
                    if (!this.checkAction(focused, selection, nonFocused, -1, actionNumber)) continue block11;
                    this.addButtonAndMenuItemForAction(nonFocused, actionNumber, -1, actionNumber, 0);
                    continue block11;
                }
                case 5: {
                    if (!this.checkMove(focused, selection, nonFocused)) continue block11;
                    this.addButtonAndMenuItemForAction(focused, actionNumber, 0, 0, 1);
                    continue block11;
                }
                case 6: {
                    if (!this.checkLink(focused, selection, nonFocused)) continue block11;
                    this.addButtonAndMenuItemForAction(focused, actionNumber, 0, 0, 6);
                    continue block11;
                }
                case 7: {
                    PairOfFlavours pairOfFlavours = this.checkCompare(focused, selection, nonFocused, nonFocusedSelection, actionNumber);
                    if (pairOfFlavours == null) continue block11;
                    this.addCompareButton(nonFocused, actionNumber, pairOfFlavours);
                }
            }
        }
        block12: for (int i = 0; i < focused.getNumberOfActions(); ++i) {
            switch (focused.getActionType(i)) {
                case 2: {
                    if (!this.checkAction(focused, selection, nonFocused, i, -1)) continue block12;
                    this.addButtonAndMenuItemForAction(focused, i, i, -1, 0);
                    continue block12;
                }
                case 0: {
                    if (!focused.checkNew(i)) continue block12;
                    this.addButtonAndMenuItemForAction(focused, i, i, 0, 4);
                    continue block12;
                }
                case 3: {
                    if (!focused.checkRun(i)) continue block12;
                    this.addButtonAndMenuItemForAction(focused, i, i, 0, 5);
                }
            }
        }
    }

    private PairOfFlavours checkCompare(CommanderPlugModel focused, int[] selection, CommanderPlugModel nonFocused, int[] nonFocusedSelection, int actionIndex) throws Exception {
        Flavour flavour1 = this.findFlavour(nonFocused, nonFocused, nonFocusedSelection, -1, actionIndex, false);
        Flavour flavour2 = this.findFlavour(nonFocused, focused, selection, -1, actionIndex, true);
        if (flavour1 != null && flavour2 != null) {
            return new PairOfFlavours(flavour1, flavour2);
        }
        return null;
    }

    private Flavour findFlavour(CommanderPlugModel nonFocused, CommanderPlugModel model, int[] selection, int action, int compareFunctionIndex, boolean focused) throws Exception {
        AdapterAction aAction = nonFocused.getAction(compareFunctionIndex);
        if (!(aAction instanceof CompareAction)) {
            return null;
        }
        CompareAction compareAction = (CompareAction)aAction;
        FlavouredItemCollection nonFocusedFlavours = model.getFlavouredItemsForCopy(selection, action);
        if (nonFocusedFlavours == null || nonFocusedFlavours.size() != 1) {
            return null;
        }
        FlavouredItem fItem = nonFocusedFlavours.get(0);
        for (int j = 0; j < fItem.getNumberOfFlavours(); ++j) {
            Flavour flavour = fItem.getFlavour(j);
            boolean res = focused ? compareAction.checkFocusedFlavour(flavour) : compareAction.checkNonFocusedFlavour(flavour);
            if (!res) continue;
            return flavour;
        }
        return null;
    }

    public void doKey(int keyCode) {
        if (this.keyExecuters.containsKey(keyCode)) {
            this.keyExecuters.get(keyCode).execute();
        }
    }

    private void addButtonAndMenuItemForAction(CommanderPlugModel model, int indexAction, final int indexActionSource, final int indexActionDestination, final int typeAction) {
        JButton buttonAction = new JButton();
        Icon actionIcon = model.getActionIcon(indexAction);
        String actionName = model.getActionName(indexAction);
        String actionDescription = model.getActionDescription(indexAction);
        Map<String, String> variations = model.getActionVariations(indexAction);
        buttonAction.setIcon(actionIcon);
        buttonAction.setText(actionName);
        buttonAction.setToolTipText(actionDescription);
        buttonAction.setFont(new Font("Arial", 0, 11));
        buttonAction.setMargin(new Insets(2, 4, 2, 4));
        buttonAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationBar.this.doOperation(typeAction, indexActionSource, indexActionDestination, null);
            }
        });
        int keyCode = model.getActionKey(indexAction);
        if (keyCode != -1) {
            this.keyExecuters.put(keyCode, new OperationExecuter(){

                @Override
                public void execute() {
                    OperationBar.this.doOperation(typeAction, indexActionSource, indexActionDestination, null);
                }
            });
        }
        this.addButton(buttonAction, variations == null || variations.isEmpty());
        if (variations == null || variations.isEmpty()) {
            JMenuItem menuItemAction = new JMenuItem();
            if (typeAction == 4) {
                menuItemAction.setAccelerator(KeyStroke.getKeyStroke(118, 0));
            }
            if (typeAction == 1) {
                menuItemAction.setAccelerator(KeyStroke.getKeyStroke(117, 0));
            }
            if (typeAction == 6) {
                // empty if block
            }
            menuItemAction.setIcon(actionIcon);
            menuItemAction.setText(actionName);
            menuItemAction.setFont(new Font("Arial", 0, 11));
            menuItemAction.setToolTipText(actionDescription);
            menuItemAction.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OperationBar.this.doOperation(typeAction, indexActionSource, indexActionDestination);
                }
            });
            this.menuOperations.add(menuItemAction);
        } else {
            this.menuOperations.add(this.createActionSubMenu(actionIcon, actionName, variations, typeAction, indexActionSource, indexActionDestination, true));
            this.addPopupItem(this.createActionSubMenu(actionIcon, actionName, variations, typeAction, indexActionSource, indexActionDestination, false));
        }
    }

    private JMenuItem createActionSubMenu(Icon actionIcon, String actionName, Map<String, String> variations, int typeAction, int indexActionSource, int indexActionDestination, boolean setFont) {
        Font font = new Font("Arial", 0, 11);
        JMenu subMenu = new JMenu(actionName);
        subMenu.setIcon(actionIcon);
        if (setFont) {
            subMenu.setFont(font);
        }
        for (Map.Entry<String, String> variationEntry : variations.entrySet()) {
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText(variationEntry.getValue());
            if (setFont) {
                menuItem.setFont(font);
            }
            menuItem.addActionListener(evt -> this.doOperation(typeAction, indexActionSource, indexActionDestination, (String)variationEntry.getKey()));
            subMenu.add(menuItem);
        }
        return subMenu;
    }

    private void addCompareButton(final CommanderPlugModel model, final int indexAction, final PairOfFlavours pairOfFlavours) {
        JButton buttonAction = new JButton();
        buttonAction.setIcon(model.getActionIcon(indexAction));
        buttonAction.setText(model.getActionName(indexAction));
        buttonAction.setToolTipText(model.getActionDescription(indexAction));
        buttonAction.setFont(new Font("Arial", 0, 11));
        buttonAction.setMargin(new Insets(2, 4, 2, 4));
        buttonAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    OperationBar.this.doCompare(model, pairOfFlavours, indexAction);
                }
                catch (Exception e) {
                    ErrorManager.notify(e);
                }
            }
        });
        this.addButton(buttonAction);
    }

    private void doCompare(CommanderPlugModel model, PairOfFlavours pairOfFlavours, int action) throws Exception {
        model.compare(pairOfFlavours.getFlavour1(), pairOfFlavours.getFlavour2(), action);
    }

    private void compare(FileFlavour first, FileFlavour second) {
        try {
            DiffNode diffNode1 = new DiffNode(StreamUtils.loadInputStreamToBytes((InputStream)first.openInputStream()), false);
            diffNode1.registerSaveHandler(data -> {});
            DiffNode diffNode2 = new DiffNode(StreamUtils.loadInputStreamToBytes((InputStream)second.openInputStream()), false);
            diffNode2.registerSaveHandler(data -> {});
            DiffEditor diffEditor = new DiffEditor(diffNode1, diffNode2);
            diffEditor.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(SwingUtilities.getRoot(this), "Exception: " + e.getMessage(), "Error comparing files", 0);
        }
    }

    private void updateControls(boolean showCopy, boolean showDelete, boolean showMove, boolean showDisabledDelete) {
        this.removeAllButtons();
        this.menuOperations.removeAll();
        if (showCopy) {
            this.addButton(this.buttonCopy);
            this.menuOperations.add(this.menuItemCopy);
        }
        if (showMove) {
            this.addButton(this.buttonMove);
            this.menuOperations.add(this.menuItemMove);
        }
        if (this.showLink) {
            this.addButton(this.buttonLink);
            this.menuOperations.add(this.menuItemLink);
        }
        if (showDelete) {
            this.addButton(this.buttonDelete);
            this.menuOperations.add(this.menuItemDelete);
        } else if (showDisabledDelete) {
            this.addButton(this.buttonDeleteDisabled);
            this.menuOperations.add(this.menuItemDeleteDisabled);
        }
        this.menuOperations.updateUI();
    }

    private boolean checkMove(CommanderPlugModel focused, int[] selection, CommanderPlugModel nonFocused) throws Exception {
        if (selection.length == 0) {
            return false;
        }
        for (int i : selection) {
            if (focused.getItemForMove(i) != null) {
                if (nonFocused.checkMove(focused.getItemForMove(i))) continue;
                return false;
            }
            return false;
        }
        return focused.getParentModelStorage() == nonFocused.getParentModelStorage();
    }

    private boolean checkLink(CommanderPlugModel focused, int[] selection, CommanderPlugModel nonFocused) throws Exception {
        if (selection.length == 0) {
            return false;
        }
        for (int i : selection) {
            if (focused.getItemForLink(i) != null) {
                if (nonFocused.checkLink(focused.getItemForLink(i))) continue;
                return false;
            }
            return false;
        }
        return focused.getParentModelStorage() == nonFocused.getParentModelStorage();
    }

    private boolean checkDelete(CommanderPlugModel focused, int[] selection) throws Exception {
        for (int i : selection) {
            if (focused.getItemForDelete(i) != null) continue;
            return false;
        }
        return true;
    }

    private boolean checkDeleteShowDisabled(CommanderPlugModel focused, int[] selection) throws Exception {
        for (int i : selection) {
            if (focused.showDisabledDelete(i)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAction(CommanderPlugModel focused, int[] selection, CommanderPlugModel nonFocused, int focusedAction, int nonFocusedAction) throws Exception {
        FlavouredItemCollection fItems = focused.getFlavouredItemsForCopy(selection, focusedAction);
        if (fItems == null) {
            return false;
        }
        if (fItems.size() == 0) {
            return false;
        }
        for (int i = 0; i < fItems.size(); ++i) {
            FlavouredItem fItem = fItems.get(i);
            if (nonFocused.checkItemForCopy(fItem, nonFocusedAction)) continue;
            return false;
        }
        return true;
    }

    public OperationBarHandler getHandler() {
        return this.handler;
    }

    public void setHandler(OperationBarHandler handler) {
        this.handler = handler;
    }

    private void initComponents() {
    }
}

