/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.operation;

import com.browsersoft.commander.commanderwindow.operation.OneButtonAlert;
import com.browsersoft.commander.commanderwindow.operation.OneItemCopyDialog;
import com.browsersoft.commander.commanderwindow.operation.OperationManagerHandler;
import com.browsersoft.commander.commanderwindow.operation.OperationWorker;
import com.browsersoft.commander.commanderwindow.operation.PreparationWorker;
import com.browsersoft.commander.commanderwindow.operation.PreparingDialog;
import com.browsersoft.commander.commanderwindow.operation.ProgressDialog;
import com.browsersoft.commander.commanderwindow.operation.SimpleAlert;
import com.browsersoft.commander.commanderwindow.side.JCommanderSide;
import com.browsersoft.commander.model.DocumentManager;
import com.browsersoft.commander.model.Flavour;
import com.browsersoft.commander.model.FlavouredItem;
import com.browsersoft.commander.model.FlavouredItemCollection;
import com.browsersoft.commander.model.NamedItem;
import com.browsersoft.commander.model.adapter.ActionUtils;
import java.awt.Frame;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class OperationManager {
    private OperationManagerHandler handler;
    private Icon operationIcon = new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/operation/exec.png"));
    private Icon errorIcon = new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/operation/error.png"));
    private Icon questionIcon = new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/operation/question.png"));
    private DocumentManager documentManager;

    public void doCopyToTempAndOpen(FlavouredItem item) throws Exception {
        if (!ActionUtils.checkAndSetSpecificFlavourType(item, "com.browsersoft.commander.model.FileFlavour")) {
            this.showOneButtonDialog("It is not possible to copy selected items");
            return;
        }
        FlavouredItemCollection flavouredItems = new FlavouredItemCollection();
        item.setNewName(item.getName());
        flavouredItems.add(item);
        OperationWorker worker = this.showProgressDialogAndRunWorkerForCopyAndOpen(flavouredItems);
        if (worker.getTempFile() != null) {
            this.documentManager.openInSystem(worker.getTempFile());
        }
    }

    public File doCopyToTemp(FlavouredItem item) throws Exception {
        if (!ActionUtils.checkAndSetSpecificFlavourType(item, "com.browsersoft.commander.model.FileFlavour")) {
            this.showOneButtonDialog("It is not possible to copy selected items");
            return null;
        }
        FlavouredItemCollection flavouredItems = new FlavouredItemCollection();
        item.setNewName(item.getName());
        flavouredItems.add(item);
        OperationWorker worker = this.showProgressDialogAndRunWorkerForCopyAndOpen(flavouredItems);
        return worker.getTempFile();
    }

    public void doOperation(int operationMode, JCommanderSide source, JCommanderSide destination, int actionSource, int actionDestination) throws Exception {
        int[] selectionSource = source.getSelections();
        switch (operationMode) {
            case 0: {
                FlavouredItemCollection flavouredItems = source.getActualModel().getFlavouredItemsForCopy(selectionSource, actionSource);
                if (flavouredItems == null) {
                    this.showOneButtonDialog("It is not possible to copy selected items.");
                    return;
                }
                if (flavouredItems.size() == 0) {
                    this.showOneButtonDialog("It is not possible to copy selected items.");
                    return;
                }
                if (!this.checkItemsForCopy(flavouredItems, destination, actionDestination)) {
                    this.showOneButtonDialog("It is not possible to copy selected items");
                    return;
                }
                if (this.showPrepareDialogAndRunPrepare(flavouredItems)) {
                    return;
                }
                if (flavouredItems.size() == 1) {
                    FlavouredItem item = flavouredItems.get(0);
                    Flavour flavour = item.getFlavour(item.getSelectedFlavour());
                    String result = this.showOneItemCopyDialog(item.getPathInSource(), destination.getActualModel().getActualPathForHuman(), flavour.getName());
                    if (result == null) break;
                    item.setNewName(result);
                    this.showProgressDialogAndRunWorker(operationMode, source, destination, flavouredItems, actionDestination);
                    break;
                }
                if (!this.showSimpleDialog("Do you really want copy " + selectionSource.length + " selected items?", this.operationIcon)) break;
                for (int i = 0; i < flavouredItems.size(); ++i) {
                    FlavouredItem item = flavouredItems.get(i);
                    item.setNewName(item.getName());
                }
                this.showProgressDialogAndRunWorker(operationMode, source, destination, flavouredItems, actionDestination);
                break;
            }
            case 2: {
                for (int i = 0; i < selectionSource.length; ++i) {
                    NamedItem item = source.getActualModel().getItemForDelete(selectionSource[i]);
                    if (item != null) continue;
                    this.showOneButtonDialog("It is not possible delete selected items");
                    return;
                }
                if (!this.showSimpleDialog("Do you really want delete " + selectionSource.length + " selected items?", this.operationIcon)) break;
                this.showProgressDialogAndRunWorker(operationMode, source, destination, null, actionDestination);
                break;
            }
            case 1: {
                if (!this.checkItemsForMove(selectionSource, source, destination)) break;
                if (selectionSource.length == 1) {
                    NamedItem item = source.getActualModel().getItemForMove(selectionSource[0]);
                    String result = this.showOneItemCopyDialog(source.getActualModel().getActualPathForHuman() + "/" + item.getName(), destination.getActualModel().getActualPathForHuman(), item.getName());
                    if (result == null) break;
                    item.setNewName(result);
                    this.showProgressDialogAndRunWorker(operationMode, source, destination, null, actionDestination);
                    break;
                }
                if (!this.showSimpleDialog("Do you really want move " + selectionSource.length + " selected items?", this.operationIcon)) break;
                for (int i = 0; i < selectionSource.length; ++i) {
                    NamedItem item = source.getActualModel().getItemForMove(selectionSource[i]);
                    item.setNewName(item.getName());
                }
                this.showProgressDialogAndRunWorker(operationMode, source, destination, null, actionDestination);
                break;
            }
            case 6: {
                if (!this.checkItemsForLink(selectionSource, source, destination) || !this.showSimpleDialog("Do you really want link " + selectionSource.length + " selected items?", this.operationIcon)) break;
                for (int i = 0; i < selectionSource.length; ++i) {
                    NamedItem item = source.getActualModel().getItemForLink(selectionSource[i]);
                    item.setNewName(item.getName());
                }
                this.showProgressDialogAndRunWorker(operationMode, source, destination, null, actionDestination);
            }
        }
    }

    private boolean checkItemsForCopy(FlavouredItemCollection flavouredItems, JCommanderSide destination, int action) throws Exception {
        for (int i = 0; i < flavouredItems.size(); ++i) {
            FlavouredItem item = flavouredItems.get(i);
            if (destination.getActualModel().checkItemForCopy(item, action)) continue;
            return false;
        }
        return true;
    }

    private boolean checkItemsForMove(int[] selection, JCommanderSide source, JCommanderSide destination) throws Exception {
        for (int i = 0; i < selection.length; ++i) {
            NamedItem item = source.getActualModel().getItemForMove(selection[i]);
            if (destination.getActualModel().checkMove(item)) continue;
            return false;
        }
        return true;
    }

    private boolean checkItemsForLink(int[] selection, JCommanderSide source, JCommanderSide destination) throws Exception {
        for (int i = 0; i < selection.length; ++i) {
            NamedItem item = source.getActualModel().getItemForLink(selection[i]);
            if (destination.getActualModel().checkLink(item)) continue;
            return false;
        }
        return true;
    }

    private String showOneItemCopyDialog(String text, String to, String name) {
        OneItemCopyDialog oneItemCopyDialog = new OneItemCopyDialog(this.handler.getAncesor(), true, text, to, name);
        oneItemCopyDialog.centerParent();
        oneItemCopyDialog.setVisible(true);
        if (oneItemCopyDialog.getResultType() == 1) {
            return oneItemCopyDialog.getNewName();
        }
        return null;
    }

    private boolean showSimpleDialog(String text, Icon icon) {
        SimpleAlert simpleAlert = new SimpleAlert((Frame)this.handler.getAncesor(), true);
        simpleAlert.setText(text);
        simpleAlert.setIcon(icon);
        simpleAlert.centerParent();
        simpleAlert.setVisible(true);
        return simpleAlert.isOk();
    }

    private void showOneButtonDialog(String text) {
        OneButtonAlert simpleAlert = new OneButtonAlert((Frame)this.handler.getAncesor(), true);
        simpleAlert.setText(text);
        simpleAlert.centerParent();
        simpleAlert.setVisible(true);
    }

    private OperationWorker showProgressDialogAndRunWorkerForCopyAndOpen(FlavouredItemCollection flavouredItems) throws Exception {
        OperationWorker worker = new OperationWorker();
        worker.setFlavouredItems(flavouredItems);
        worker.setDocumentManager(this.documentManager);
        worker.setOperationMode(3);
        ProgressDialog pd = new ProgressDialog((Frame)this.handler.getAncesor(), true);
        pd.centerParent();
        pd.setWorkerAndRun(worker);
        pd.setVisible(true);
        return worker;
    }

    private void showProgressDialogAndRunWorker(int operationMode, JCommanderSide source, JCommanderSide destination, FlavouredItemCollection flavouredItems, int actionId) {
        OperationWorker worker = new OperationWorker();
        worker.setFlavouredItems(flavouredItems);
        worker.setSelectionSource(source.getSelections());
        worker.setSource(source.getActualModel());
        worker.setDestination(destination.getActualModel());
        worker.setOperationMode(operationMode);
        worker.setActionId(actionId);
        ProgressDialog pd = new ProgressDialog((Frame)this.handler.getAncesor(), true);
        pd.centerParent();
        pd.setWorkerAndRun(worker);
        pd.setVisible(true);
    }

    private boolean showPrepareDialogAndRunPrepare(FlavouredItemCollection flavouredItems) throws Exception {
        int j;
        FlavouredItem item;
        int i;
        int numberOfItems = 0;
        boolean someLongPreparing = false;
        for (i = 0; i < flavouredItems.size(); ++i) {
            item = flavouredItems.get(i);
            for (j = 0; j < item.getNumberOfFlavours(); ++j) {
                if (item.getSelectedFlavour() != j) continue;
                Flavour flavour = item.getFlavour(j);
                if (flavour.hasLongPreparing()) {
                    someLongPreparing = true;
                }
                ++numberOfItems;
            }
        }
        if (someLongPreparing) {
            PreparingDialog pd = new PreparingDialog((Frame)this.handler.getAncesor(), true);
            pd.centerParent();
            PreparationWorker worker = new PreparationWorker(flavouredItems, numberOfItems);
            pd.setWorkerAndRun(worker);
            pd.setVisible(true);
            if (pd.isCanceled()) {
                return true;
            }
        } else {
            for (i = 0; i < flavouredItems.size(); ++i) {
                item = flavouredItems.get(i);
                for (j = 0; j < item.getNumberOfFlavours(); ++j) {
                    if (item.getSelectedFlavour() != j) continue;
                    item.getFlavour(j).prepare(null);
                }
            }
        }
        return false;
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    public OperationManagerHandler getHandler() {
        return this.handler;
    }

    public void setHandler(OperationManagerHandler handler) {
        this.handler = handler;
    }
}

