/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.operation;

import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.model.DocumentManager;
import com.browsersoft.commander.model.FileFlavour;
import com.browsersoft.commander.model.FlavouredItem;
import com.browsersoft.commander.model.FlavouredItemCollection;
import com.browsersoft.commander.model.NamedItem;
import com.browsersoft.commander.model.OperationModel;
import com.browsersoft.commander.model.OperationWorkerHandler;
import com.browsersoft.commander.model.adapter.ActionUtils;
import com.browsersoft.commander.utils.swing.SwingWorker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.UUID;

public class OperationWorker
extends SwingWorker {
    public static final int OPERATION_MODE_COPY = 0;
    public static final int OPERATION_MODE_MOVE = 1;
    public static final int OPERATION_MODE_DELETE = 2;
    public static final int OPERATION_MODE_COPY_TO_TEMP = 3;
    public static final int OPERATION_MODE_NEW = 4;
    public static final int OPERATION_MODE_RUN = 5;
    public static final int OPERATION_MODE_LINK = 6;
    public static final int OPERATION_MODE_COMPARE = 7;
    private OperationWorkerHandler handler;
    private OperationModel source;
    private OperationModel destination;
    private FlavouredItemCollection flavouredItems;
    private int[] selectionSource;
    private int operationMode;
    private DocumentManager documentManager;
    private boolean cancel;
    private int actionId;
    private File tempFile;

    public void cancel() {
        this.cancel = true;
    }

    @Override
    public Object construct() {
        try {
            switch (this.operationMode) {
                case 3: {
                    int numberOfElements = this.flavouredItems.getNumberOfElementsInSelectedFlavours();
                    this.handler.operationStarting(numberOfElements);
                    for (int i = 0; i < this.flavouredItems.size(); ++i) {
                        FlavouredItem item = this.flavouredItems.get(i);
                        FileFlavour fileFlavour = (FileFlavour)item.getSelectedFlavourAsObject();
                        File file = new File(this.documentManager.getTempDirectory() + "/" + UUID.randomUUID().toString() + fileFlavour.getName());
                        if (file.exists() && !file.delete()) {
                            this.handler.operationError("It is not possible delete file " + file.getAbsolutePath());
                        }
                        ActionUtils.inputStreamToOutputStreamWithHandler((InputStream)fileFlavour.openInputStream(), new FileOutputStream(file), this.handler, fileFlavour.getByteSize());
                        file.deleteOnExit();
                        if (!this.handler.canContinue()) break;
                        this.tempFile = file;
                    }
                    this.handler.operationDone();
                    break;
                }
                case 0: {
                    int numberOfElements = this.flavouredItems.getNumberOfElementsInSelectedFlavours();
                    this.handler.operationStarting(numberOfElements);
                    for (int i = 0; i < this.flavouredItems.size(); ++i) {
                        FlavouredItem item = this.flavouredItems.get(i);
                        if (item.getSelectedFlavourAsObject().getNumberOfElements() == 1) {
                            if (this.destination.existItem(item, this.actionId)) {
                                if (this.handler.overwriteQuestion("Item \"" + item.getNewName() + "\" already exists. What do you want?")) {
                                    this.handler.operationElementStarting("From: " + this.source.getActualPath() + "/" + item.getName(), "To: " + this.destination.getActualPath() + "/" + item.getNewName());
                                    this.destination.copyItem(item, this.handler, this.actionId);
                                }
                            } else {
                                this.handler.operationElementStarting("From: " + this.source.getActualPath() + "/" + item.getName(), "To: " + this.destination.getActualPath() + "/" + item.getNewName());
                                this.destination.copyItem(item, this.handler, this.actionId);
                            }
                        } else {
                            this.destination.copyItem(item, this.handler, this.actionId);
                        }
                        if (!this.handler.canContinue()) break;
                    }
                    this.handler.operationDone();
                    break;
                }
                case 1: {
                    this.handler.operationStarting(this.selectionSource.length);
                    for (int i = 0; i < this.selectionSource.length; ++i) {
                        NamedItem item = this.source.getItemForMove(this.selectionSource[i]);
                        this.destination.moveItem(item, this.handler);
                        if (!this.handler.canContinue()) break;
                    }
                    this.handler.operationDone();
                    break;
                }
                case 6: {
                    this.handler.operationStarting(this.selectionSource.length);
                    for (int i = 0; i < this.selectionSource.length; ++i) {
                        NamedItem item = this.source.getItemForLink(this.selectionSource[i]);
                        this.destination.linkItem(item, this.handler);
                        if (!this.handler.canContinue()) break;
                    }
                    this.handler.operationDone();
                    break;
                }
                case 7: {
                    break;
                }
                case 2: {
                    this.handler.operationStarting(this.selectionSource.length);
                    for (int i = 0; i < this.selectionSource.length; ++i) {
                        NamedItem item = this.source.getItemForDelete(this.selectionSource[i]);
                        if (item != null) {
                            this.source.deleteItem(item, this.handler);
                        }
                        if (!this.handler.canContinue()) break;
                    }
                    this.handler.operationDone();
                }
            }
        }
        catch (InterruptedException e) {
            this.handler.operationDone();
        }
        catch (Exception e) {
            this.handler.operationDone();
            ErrorManager.notify(e);
        }
        return null;
    }

    public OperationWorkerHandler getHandler() {
        return this.handler;
    }

    public void setHandler(OperationWorkerHandler handler) {
        this.handler = handler;
    }

    public OperationModel getSource() {
        return this.source;
    }

    public void setSource(OperationModel source) {
        this.source = source;
    }

    public OperationModel getDestination() {
        return this.destination;
    }

    public void setDestination(OperationModel destination) {
        this.destination = destination;
    }

    public int getOperationMode() {
        return this.operationMode;
    }

    public void setOperationMode(int operationMode) {
        this.operationMode = operationMode;
    }

    public void setSelectionSource(int[] selectionSource) {
        this.selectionSource = selectionSource;
    }

    public int[] getSelectionSource() {
        return this.selectionSource;
    }

    public FlavouredItemCollection getFlavouredItems() {
        return this.flavouredItems;
    }

    public void setFlavouredItems(FlavouredItemCollection flavouredItems) {
        this.flavouredItems = flavouredItems;
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    public int getActionId() {
        return this.actionId;
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public void setTempFile(File tempFile) {
        this.tempFile = tempFile;
    }
}

