/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.operation;

import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.commanderwindow.operation.PreparationWorker;
import com.browsersoft.commander.model.PreparingHandler;
import com.browsersoft.commander.utils.swing.CenteredDialog;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class PreparingDialog
extends CenteredDialog
implements PreparingHandler {
    private Timer timer;
    private boolean running;
    private boolean indeterminate;
    private int progressPercent;
    private int progressAll;
    private int numberOfItems;
    private String text1 = "";
    private String text2 = "";
    private PreparationWorker worker;
    private boolean canceled;
    private JButton buttonCancel;
    private JLabel lblText;
    private JLabel lblText2;
    private JProgressBar progressBar;
    private JProgressBar progressBarAll;

    public PreparingDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.progressBar.setMaximum(100);
        this.progressBarAll.setMaximum(100);
    }

    public void setWorkerAndRun(PreparationWorker worker) {
        this.worker = worker;
        worker.setHandler(this);
        this.run();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void run() {
        if (!this.running) {
            this.timer = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (PreparingDialog.this.numberOfItems != 0) {
                        int percentAll = PreparingDialog.this.progressAll * 100 / PreparingDialog.this.numberOfItems;
                        PreparingDialog.this.progressBarAll.setValue(percentAll);
                        PreparingDialog.this.progressBarAll.setString(percentAll + "%");
                    }
                    if (PreparingDialog.this.text1.equals("")) {
                        PreparingDialog.this.text1 = " ";
                    }
                    PreparingDialog.this.lblText.setText(PreparingDialog.this.text1);
                    if (PreparingDialog.this.text2.equals("")) {
                        PreparingDialog.this.text2 = " ";
                    }
                    PreparingDialog.this.lblText2.setText(PreparingDialog.this.text2);
                    if (PreparingDialog.this.indeterminate) {
                        PreparingDialog.this.progressBar.setIndeterminate(true);
                    } else {
                        PreparingDialog.this.progressBar.setIndeterminate(false);
                        PreparingDialog.this.progressBar.setValue(PreparingDialog.this.progressPercent);
                        PreparingDialog.this.progressBar.setString(PreparingDialog.this.progressPercent + "%");
                    }
                }
            });
            this.timer.start();
            this.running = true;
            this.buttonCancel.setEnabled(true);
            this.worker.start();
        }
    }

    @Override
    public void prepareStart(int numberOfItems) throws Exception {
        this.numberOfItems = numberOfItems;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public void prepareElementStarting(boolean indeterminate, String text1) throws Exception {
        this.indeterminate = indeterminate;
        text1 = text1.replaceAll("\\\\", "/");
        this.text1 = text1 = text1.replaceAll("//", "/");
        ++this.progressAll;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public void prepareElementRunning(int progressPercent, String text2) throws Exception {
        this.progressPercent = progressPercent;
        text2 = text2.replaceAll("\\\\", "/");
        this.text2 = text2 = text2.replaceAll("//", "/");
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public void prepareFinish() {
        this.running = false;
        this.buttonCancel.setEnabled(false);
        this.timer.stop();
        this.dispose();
    }

    @Override
    public void prepareError(String error) {
        ErrorManager.notify(new Exception(error));
        this.timer.stop();
        this.canceled = true;
        this.dispose();
    }

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.buttonCancel = new JButton();
        this.lblText = new JLabel();
        this.progressBarAll = new JProgressBar();
        this.lblText2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.progressBar.setBackground(new Color(255, 255, 255));
        this.progressBar.setForeground(new Color(51, 204, 255));
        this.progressBar.setStringPainted(false);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreparingDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.lblText.setText(" ");
        this.progressBarAll.setBackground(new Color(255, 255, 255));
        this.progressBarAll.setForeground(new Color(0, 204, 102));
        this.progressBarAll.setStringPainted(false);
        this.lblText2.setText(" ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblText, -1, 464, Short.MAX_VALUE).addComponent(this.progressBar, -1, 464, Short.MAX_VALUE).addComponent(this.progressBarAll, -1, 464, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(195, 195, 195).addComponent(this.buttonCancel)).addComponent(this.lblText2, -1, 464, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblText2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBarAll, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.timer.stop();
        this.worker.interrupt();
        this.canceled = true;
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PreparingDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }
}

