/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.operation;

import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.commanderwindow.operation.CopyAlert;
import com.browsersoft.commander.commanderwindow.operation.OperationWorker;
import com.browsersoft.commander.model.OperationWorkerHandler;
import com.browsersoft.commander.utils.swing.CenteredDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.jdesktop.layout.GroupLayout;

public class ProgressDialog
extends CenteredDialog
implements OperationWorkerHandler {
    private OperationWorker worker;
    private Timer timer;
    private boolean running;
    private int progressItem = 0;
    private int progressAll = 0;
    private String text1 = "";
    private String text2 = "";
    private int numberOfItems = 0;
    private int lastType = -1;
    private boolean stoped;
    private JButton buttonCancel;
    private JLabel lbl1;
    private JLabel lbl2;
    private JProgressBar progressBarAll;
    private JProgressBar progressBarCurrent;

    public ProgressDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.progressBarAll.setMaximum(100);
        this.progressBarAll.setStringPainted(false);
        this.progressBarCurrent.setMaximum(100);
        this.progressBarCurrent.setStringPainted(false);
        this.progressBarAll.setFont(new Font("Arial Unicode MS", 0, 12));
        this.progressBarCurrent.setFont(new Font("Arial Unicode MS", 0, 12));
        this.lbl1.setFont(new Font("Arial Unicode MS", 0, 12));
        this.lbl2.setFont(new Font("Arial Unicode MS", 0, 12));
    }

    public void setWorkerAndRun(OperationWorker worker) {
        this.worker = worker;
        worker.setHandler(this);
        this.run();
    }

    private void run() {
        if (!this.running) {
            this.timer = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int percent = -1;
                    if (ProgressDialog.this.numberOfItems > 0) {
                        percent = ProgressDialog.this.progressAll * 100 / ProgressDialog.this.numberOfItems;
                    }
                    if (percent == -1) {
                        ProgressDialog.this.progressBarAll.setIndeterminate(true);
                    } else {
                        ProgressDialog.this.progressBarAll.setIndeterminate(false);
                    }
                    ProgressDialog.this.progressBarAll.setValue(percent);
                    ProgressDialog.this.progressBarCurrent.setValue(ProgressDialog.this.progressItem);
                    if (ProgressDialog.this.text1.equals("")) {
                        ProgressDialog.this.text1 = " ";
                    }
                    if (ProgressDialog.this.text2.equals("")) {
                        ProgressDialog.this.text2 = " ";
                    }
                    ProgressDialog.this.lbl1.setText(ProgressDialog.this.text1);
                    ProgressDialog.this.lbl2.setText(ProgressDialog.this.text2);
                }
            });
            this.timer.start();
            this.running = true;
            this.buttonCancel.setEnabled(true);
            this.worker.start();
        }
    }

    @Override
    public void operationDone() {
        this.running = false;
        this.buttonCancel.setEnabled(false);
        this.timer.stop();
        this.dispose();
    }

    @Override
    public void operationError(String error) {
        ErrorManager.notify(new Exception(error));
        this.timer.stop();
        this.dispose();
    }

    @Override
    public void operationStarting(int numberOfItems) {
        this.numberOfItems = numberOfItems;
    }

    @Override
    public boolean operationElementRunning(int percent) throws InterruptedException {
        this.progressItem = percent;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return !this.stoped;
    }

    @Override
    public void operationElementStarting(String text1, String text2) throws InterruptedException {
        text1 = text1.replaceAll("\\\\", "/");
        text1 = text1.replaceAll("//", "/");
        text2 = text2.replaceAll("\\\\", "/");
        text2 = text2.replaceAll("//", "/");
        this.text1 = text1;
        this.text2 = text2;
        ++this.progressAll;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public boolean canContinue() {
        return !this.stoped;
    }

    @Override
    public boolean overwriteQuestion(String string) {
        switch (this.lastType) {
            case 1: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        this.lastType = this.showCopyDialog(string);
        switch (this.lastType) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    private int showCopyDialog(String text) {
        CopyAlert copyAlert = new CopyAlert((Frame)this.getParent(), true);
        copyAlert.setText(text);
        copyAlert.centerParent();
        copyAlert.setVisible(true);
        return copyAlert.getResultType();
    }

    private void initComponents() {
        this.lbl1 = new JLabel();
        this.lbl2 = new JLabel();
        this.progressBarCurrent = new JProgressBar();
        this.progressBarAll = new JProgressBar();
        this.buttonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Operation");
        this.setResizable(false);
        this.lbl1.setText(" ");
        this.lbl2.setText(" ");
        this.progressBarCurrent.setBackground(new Color(255, 255, 255));
        this.progressBarCurrent.setForeground(new Color(255, 153, 51));
        this.progressBarCurrent.setStringPainted(true);
        this.progressBarAll.setBackground(new Color(255, 255, 255));
        this.progressBarAll.setForeground(new Color(0, 153, 153));
        this.progressBarAll.setStringPainted(true);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.progressBarCurrent, -2, 462, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.progressBarAll, -2, 462, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(193, 193, 193).add((Component)this.buttonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lbl1, -2, 462, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lbl2, -2, 462, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lbl1).addPreferredGap(0).add((Component)this.lbl2).add(15, 15, 15).add((Component)this.progressBarCurrent, -2, -1, -2).addPreferredGap(0).add((Component)this.progressBarAll, -2, -1, -2).addPreferredGap(0).add((Component)this.buttonCancel).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.stoped = true;
        this.timer.stop();
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ProgressDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }
}

