/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.plugin.zip;

import com.browsersoft.commander.commanderwindow.plugin.zip.ZipEntryDirectoryAdapterItem;
import com.browsersoft.commander.commanderwindow.plugin.zip.ZipEntryDirectoryFlavour;
import com.browsersoft.commander.commanderwindow.plugin.zip.ZipEntryFileAdapterItem;
import com.browsersoft.commander.commanderwindow.plugin.zip.ZipEntryFileFlavour;
import com.browsersoft.commander.commanderwindow.plugin.zip.ZipUtils;
import com.browsersoft.commander.model.FlavouredItem;
import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.SimpleExportAdapterAction;
import com.browsersoft.commander.utils.FileUtils;
import java.io.File;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipEntryExportDirectoryAndFileAction
extends SimpleExportAdapterAction {
    private File file;
    private ZipFile zipFile;

    public ZipEntryExportDirectoryAndFileAction(File file, ZipFile zipFile) {
        this.file = file;
        this.zipFile = zipFile;
    }

    @Override
    public boolean checkItem(AdapterItem adapterItem) {
        return adapterItem instanceof ZipEntryFileAdapterItem || adapterItem instanceof ZipEntryDirectoryAdapterItem;
    }

    @Override
    public FlavouredItem exportItem(AdapterItem item) throws Exception {
        if (item instanceof ZipEntryFileAdapterItem) {
            return this.exportFileItem(item);
        }
        if (item instanceof ZipEntryDirectoryAdapterItem) {
            return this.exportDirectoryItem(item);
        }
        return null;
    }

    public FlavouredItem exportFileItem(AdapterItem adapterItem) throws Exception {
        ZipEntryFileAdapterItem info = (ZipEntryFileAdapterItem)adapterItem;
        FlavouredItem newFlavouredItem = new FlavouredItem();
        newFlavouredItem.setPathInSource(info.getZipEntry().getName());
        newFlavouredItem.setName(FileUtils.getNameFileFromURL(info.getZipEntry().getName()));
        newFlavouredItem.add(new ZipEntryFileFlavour(info.getFile(), info.getZipEntry()));
        return newFlavouredItem;
    }

    public FlavouredItem exportDirectoryItem(AdapterItem adapterItem) throws Exception {
        ZipEntryDirectoryAdapterItem info = (ZipEntryDirectoryAdapterItem)adapterItem;
        FlavouredItem newFlavouredItem = new FlavouredItem();
        newFlavouredItem.setPathInSource(info.getZipEntry().getName());
        newFlavouredItem.setName(FileUtils.getNameFileFromURL(ZipUtils.getNameWithoutSlash(info.getZipEntry().getName())));
        List<ZipEntry> entries = ZipUtils.getZipEntriesInEntryDeep(this.zipFile, info.getZipEntry());
        newFlavouredItem.add(new ZipEntryDirectoryFlavour(this.file, entries, FileUtils.getNameFileFromURL(info.getZipEntry().getName()), info.getZipEntry().getName()));
        return newFlavouredItem;
    }
}

