/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.plugin.zip;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipUtils {
    public static InputStream openInputStream(ZipEntry zipEntry, InputStream inputStream) throws Exception {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(inputStream);
        while ((entry = zis.getNextEntry()) != null) {
            if (!entry.getName().equals(zipEntry.getName())) continue;
            return zis;
        }
        return null;
    }

    public static List<ZipEntry> getZipEntriesInEntry(ZipFile zipFile, String path) {
        ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = ZipUtils.getNameWithoutSlash(zipEntry.getName());
            if (ZipUtils.getNumberOfSlashs(path) != ZipUtils.getNumberOfSlashs(name) || path.equals(name) || !name.startsWith(path)) continue;
            zipEntries.add(zipEntry);
        }
        return zipEntries;
    }

    public static List<ZipEntry> getZipEntriesInEntryDeep(ZipFile zipFile, ZipEntry entry) {
        ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
        zipEntries.add(entry);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = ZipUtils.getNameWithoutSlash(zipEntry.getName());
            if (ZipUtils.getNumberOfSlashs(entry.getName()) > ZipUtils.getNumberOfSlashs(name) || entry.getName().equals(name) || !name.startsWith(entry.getName())) continue;
            zipEntries.add(zipEntry);
        }
        return zipEntries;
    }

    public static int getNumberOfSlashs(String s) {
        int counter = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '/') continue;
            ++counter;
        }
        return counter;
    }

    public static String getNameWithoutSlash(String name) {
        if (name.endsWith("/")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }
}

