/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.profiles;

import com.browsersoft.commander.commanderwindow.profiles.DefaultProfileInfo;
import com.browsersoft.commander.commanderwindow.profiles.Profile;
import com.browsersoft.commander.commanderwindow.profiles.ProfileListener;
import com.browsersoft.commander.model.ProfileInfoCollection;
import com.browsersoft.commander.model.adapter.AdapterStorage;
import com.browsersoft.commander.model.adapter.CommanderAdapter;
import java.util.ArrayList;
import java.util.List;

public class ProfileCollection
implements ProfileListener {
    private ArrayList<Profile> objects;
    private ArrayList<ProfileListener> profileListeners = new ArrayList();

    public ProfileCollection() {
        this.objects = new ArrayList();
    }

    public void setProfiles(List<Profile> profiles) throws Exception {
        this.objects.clear();
        for (Profile profile : profiles) {
            this.objects.add(profile);
            profile.setListener(this);
        }
        this.profilesChanged();
    }

    public Profile get(int index) {
        return this.objects.get(index);
    }

    public int size() {
        return this.objects.size();
    }

    public ProfileInfoCollection toProfilesInfos() {
        ProfileInfoCollection infos = new ProfileInfoCollection();
        for (Profile profile : this.objects) {
            DefaultProfileInfo profileInfo = new DefaultProfileInfo();
            profileInfo.setModuleConfiguration(profile.getModuleConfiguration());
            profileInfo.setName(profile.getProfileName());
            profileInfo.setCommanderPlugStorageModel(profile.getCommanderPlugStorageModel());
            infos.add(profileInfo);
        }
        return infos;
    }

    public void disconnectAll() throws Exception {
        for (Profile profile : this.objects) {
            if (!profile.isConnected()) continue;
            profile.disconnect();
        }
        this.profilesChanged();
    }

    public void addProfileListener(ProfileListener listener) {
        this.profileListeners.add(listener);
    }

    public void removeProfileListener(ProfileListener listener) {
        this.profileListeners.remove(listener);
    }

    public void clearProfileListeners() {
        this.profileListeners.clear();
    }

    @Override
    public void profilesChanged() throws Exception {
        ArrayList<CommanderAdapter> connectedAdapters = new ArrayList<CommanderAdapter>();
        for (Profile profile : this.objects) {
            if (!profile.isConnected() || !(profile.getCommanderPlugStorageModel() instanceof AdapterStorage)) continue;
            connectedAdapters.add(((AdapterStorage)profile.getCommanderPlugStorageModel()).getAdapter());
        }
        for (Profile profile : this.objects) {
            if (!profile.isConnected()) continue;
            profile.getCommanderPlugStorageModel().profilesChanged(connectedAdapters);
        }
        for (ProfileListener listener : this.profileListeners) {
            listener.profilesChanged();
        }
    }
}

