/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.profiles;

import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.commanderwindow.modules.StorageTypeInfo;
import com.browsersoft.commander.commanderwindow.modules.StorageTypeInfoCollection;
import com.browsersoft.commander.commanderwindow.profiles.Profile;
import com.browsersoft.commander.commanderwindow.profiles.ProfilePanelHandler;
import com.browsersoft.commander.commanderwindow.profiles.ProfilesPanel;
import com.browsersoft.commander.model.CommanderPlugStorage;
import com.browsersoft.commander.model.CommanderPlugStorageConfiguration;
import com.browsersoft.commander.model.DocumentManager;
import com.browsersoft.commander.utils.swing.JImageCombo;
import com.browsersoft.commander.utils.swing.JImageComboItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;

public class ProfilePanel
extends JPanel {
    private StorageTypeInfoCollection storageTypes;
    private Profile actualProfile;
    private CommanderPlugStorageConfiguration actualConfigurationPanel;
    private JImageComboItem lastSelectedItem;
    private Icon connectedIcon = new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/profiles/connect_established.png"));
    private Icon disconnectedIcon = new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/profiles/connect_no.png"));
    private DocumentManager documentManager;
    private ProfilesPanel profilesPanel;
    private String uuid = UUID.randomUUID().toString();
    private ProfilePanelHandler handler;
    private JButton buttonStatus;
    private JCheckBox checkAutoConnect;
    private JComboBox comboTypeOfStorage;
    private JLabel lblAutoConnect;
    private JLabel lblProfileName;
    private JLabel lblTypeOfStorage;
    private JPanel panelDetails;
    private JTextField textProfileName;

    public ProfilePanel() {
        this.initComponents();
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    public void load(Profile profile, StorageTypeInfoCollection storageTypes, final ProfilePanelHandler handler) throws Exception {
        this.handler = handler;
        this.storageTypes = storageTypes;
        this.actualProfile = profile;
        this.fillCombo(storageTypes, profile.getCommanderPlugStorage().getFullStorageName());
        this.textProfileName.setText(profile.getProfileName());
        this.checkAutoConnect.setSelected(profile.isAutoConnect());
        this.actualConfigurationPanel = profile.getCommanderPlugStorage().getConfigurationPanel(this.profilesPanel.getProfilesInfo(false));
        this.actualConfigurationPanel.load(profile.getModuleConfiguration());
        this.panelDetails.add((Component)this.actualConfigurationPanel, "Center");
        this.textProfileName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProfilePanel.this.actualProfile.setProfileName(ProfilePanel.this.textProfileName.getText());
                handler.nameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProfilePanel.this.actualProfile.setProfileName(ProfilePanel.this.textProfileName.getText());
                handler.nameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProfilePanel.this.actualProfile.setProfileName(ProfilePanel.this.textProfileName.getText());
                handler.nameChanged();
            }
        });
        if (profile.getCommanderPlugStorageModel() != null) {
            this.disableAll();
        } else {
            this.enableAll();
        }
        this.comboTypeOfStorage.addActionListener(e -> {
            JImageCombo cb = (JImageCombo)e.getSource();
            this.comboItemChanged((JImageComboItem)cb.getSelectedItem());
        });
    }

    public boolean isConnected() {
        return this.actualProfile.isConnected();
    }

    private void enableAll() {
        this.checkAutoConnect.setEnabled(true);
        this.comboTypeOfStorage.setEnabled(true);
        this.textProfileName.setEnabled(true);
        this.actualConfigurationPanel.setEnabled(true);
        this.buttonStatus.setText("Connect");
        this.buttonStatus.setIcon(this.disconnectedIcon);
        this.actualConfigurationPanel.enableAll();
    }

    private void disableAll() {
        this.checkAutoConnect.setEnabled(false);
        this.comboTypeOfStorage.setEnabled(false);
        this.textProfileName.setEnabled(false);
        this.actualConfigurationPanel.setEnabled(false);
        this.buttonStatus.setText("Disconnect");
        this.buttonStatus.setIcon(this.connectedIcon);
        this.actualConfigurationPanel.disableAll();
    }

    private void buttonClick() {
        try {
            if (this.actualProfile.isConnected()) {
                this.actualProfile.disconnect();
                this.enableAll();
            } else {
                this.save();
                this.actualProfile.connect(this.documentManager);
                this.disableAll();
            }
        }
        catch (Exception ex) {
            ErrorManager.notify(ex);
        }
    }

    private void comboItemChanged(JImageComboItem item) {
        if (this.lastSelectedItem != null && this.lastSelectedItem == item) {
            return;
        }
        String className = item.getId();
        try {
            for (int i = 0; i < this.storageTypes.size(); ++i) {
                StorageTypeInfo storageTypeInfo = this.storageTypes.get(i);
                CommanderPlugStorage storage = storageTypeInfo.getStorage();
                if (!storage.getFullStorageName().equals(className)) continue;
                this.actualProfile.setCommanderPlugStorage(storage);
                this.actualConfigurationPanel = this.actualProfile.getCommanderPlugStorage().getConfigurationPanel(this.profilesPanel.getProfilesInfo(true));
                this.panelDetails.removeAll();
                this.panelDetails.add((Component)this.actualConfigurationPanel, "Center");
                this.panelDetails.updateUI();
                this.lastSelectedItem = item;
            }
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    public Profile save() {
        this.actualProfile.setProfileName(this.textProfileName.getText());
        this.actualProfile.setModuleConfiguration(this.actualConfigurationPanel.save());
        this.actualProfile.setAutoConnect(this.checkAutoConnect.isSelected());
        return this.actualProfile;
    }

    private void fillCombo(StorageTypeInfoCollection storageTypes, String modelClass) {
        int i;
        for (i = 0; i < storageTypes.size(); ++i) {
            StorageTypeInfo storageTypeInfo = storageTypes.get(i);
            CommanderPlugStorage storage = storageTypeInfo.getStorage();
            JImageComboItem item = new JImageComboItem(storage.getFullStorageName(), storage.getFullStorageName(), storage.getStorageIcon());
            this.comboTypeOfStorage.addItem(item);
        }
        if (storageTypes.size() > 0) {
            this.lastSelectedItem = (JImageComboItem)this.comboTypeOfStorage.getItemAt(0);
        }
        for (i = 0; i < this.comboTypeOfStorage.getItemCount(); ++i) {
            JImageComboItem item = (JImageComboItem)this.comboTypeOfStorage.getItemAt(i);
            if (!item.getId().equals(modelClass)) continue;
            this.lastSelectedItem = item;
            this.comboTypeOfStorage.setSelectedIndex(i);
            break;
        }
    }

    public ProfilesPanel getProfilesPanel() {
        return this.profilesPanel;
    }

    public void setProfilesPanel(ProfilesPanel profilesPanel) {
        this.profilesPanel = profilesPanel;
    }

    private void initComponents() {
        this.textProfileName = new JTextField();
        this.lblProfileName = new JLabel();
        this.panelDetails = new JPanel(new BorderLayout());
        this.lblTypeOfStorage = new JLabel();
        this.comboTypeOfStorage = new JImageCombo();
        this.checkAutoConnect = new JCheckBox();
        this.lblAutoConnect = new JLabel();
        this.buttonStatus = new JButton();
        this.lblProfileName.setText("Profile name:");
        this.panelDetails.setBorder(BorderFactory.createTitledBorder(null, "Profile detail", 0, 0, new Font("Tahoma", 0, 11), new Color(102, 102, 102)));
        this.lblTypeOfStorage.setText("Module type:");
        this.comboTypeOfStorage.addActionListener(evt -> this.comboTypeOfStorageActionPerformed(evt));
        this.comboTypeOfStorage.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorAdded(AncestorEvent evt) {
                ProfilePanel.this.comboTypeOfStorageAncestorAdded(evt);
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        this.checkAutoConnect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkAutoConnect.setMargin(new Insets(0, 0, 0, 0));
        this.lblAutoConnect.setText("Autoconnect after start:");
        this.buttonStatus.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/profiles/connect_no.png")));
        this.buttonStatus.setText(" ");
        this.buttonStatus.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.buttonStatus.setContentAreaFilled(false);
        this.buttonStatus.setHorizontalTextPosition(0);
        this.buttonStatus.setVerticalTextPosition(3);
        this.buttonStatus.addActionListener(evt -> this.buttonStatusActionPerformed(evt));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(23, 23, 23).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblTypeOfStorage).add((Component)this.lblProfileName).add((Component)this.lblAutoConnect)).add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.checkAutoConnect).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.comboTypeOfStorage, 0, -1, Short.MAX_VALUE).add(1, (Component)this.textProfileName, -1, 256, Short.MAX_VALUE)))).add(22, 22, 22).add((Component)this.buttonStatus, -1, 187, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.panelDetails, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblProfileName).add((Component)this.textProfileName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblTypeOfStorage).add((Component)this.comboTypeOfStorage, -2, -1, -2)).add(7, 7, 7).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblAutoConnect).add((Component)this.checkAutoConnect))).add((GroupLayout.Group)layout.createSequentialGroup().add(21, 21, 21).add((Component)this.buttonStatus, -2, 75, -2))).add(24, 24, 24).add((Component)this.panelDetails, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void comboTypeOfStorageActionPerformed(ActionEvent evt) {
    }

    private void buttonStatusActionPerformed(ActionEvent evt) {
        this.buttonClick();
    }

    private void comboTypeOfStorageAncestorAdded(AncestorEvent evt) {
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String toString() {
        return this.actualProfile.getProfileName();
    }
}

