/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.search;

import com.browsersoft.commander.commanderwindow.search.SearchWorker;
import com.browsersoft.commander.model.CommanderPlugModel;
import com.browsersoft.commander.model.SearchProgressHandler;
import com.browsersoft.commander.utils.swing.CenteredDialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class SearchDialog
extends CenteredDialog
implements SearchProgressHandler {
    private Timer timer;
    private int percent;
    private String text = "";
    private boolean running;
    private JButton buttonCancel;
    private JLabel lblSearching;
    private JProgressBar progressBar;

    public SearchDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    @Override
    public boolean searchRunning(int percent, String message) {
        this.percent = percent;
        this.text = message;
        return this.running;
    }

    public void run(CommanderPlugModel commanderPlugModel, String searchText) {
        SearchWorker searchWorker = new SearchWorker();
        searchWorker.setCommanderPlugModel(commanderPlugModel);
        searchWorker.setSearchText(searchText);
        searchWorker.setHandler(this);
        this.running = true;
        this.timer = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.progressBar.setIndeterminate(SearchDialog.this.percent == -1);
                SearchDialog.this.progressBar.setValue(SearchDialog.this.percent);
                SearchDialog.this.lblSearching.setText("Searching:" + SearchDialog.this.text);
                if (!SearchDialog.this.running) {
                    SearchDialog.this.searchDone();
                }
            }
        });
        this.timer.start();
        this.buttonCancel.setEnabled(true);
        this.centerParent();
        searchWorker.start();
        this.setVisible(true);
    }

    private void doCancel() {
        this.running = false;
        this.dispose();
    }

    @Override
    public void searchDone() {
        this.timer.stop();
        this.dispose();
    }

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.buttonCancel = new JButton();
        this.lblSearching = new JLabel();
        this.setDefaultCloseOperation(2);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.lblSearching.setText("Searching:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressBar, -2, 356, -2).addComponent(this.lblSearching))).addGroup(layout.createSequentialGroup().addGap(155, 155, 155).addComponent(this.buttonCancel))).addContainerGap(23, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.lblSearching).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonCancel).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchDialog dialog = new SearchDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }
}

