/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.settings;

import com.browsersoft.commander.commanderwindow.modules.BuildInPluginsManager;
import com.browsersoft.commander.commanderwindow.modules.ModuleInfo;
import com.browsersoft.commander.commanderwindow.modules.ModuleInfoCollection;
import com.browsersoft.commander.commanderwindow.modules.StorageTypeInfo;
import com.browsersoft.commander.commanderwindow.modules.StorageTypeInfoCollection;
import com.browsersoft.commander.commanderwindow.paths.HotDirectoryListItem;
import com.browsersoft.commander.commanderwindow.profiles.Profile;
import com.browsersoft.commander.commanderwindow.profiles.ProfileCollection;
import com.browsersoft.commander.model.CommanderPlugStorage;
import com.browsersoft.commander.utils.OSValidator;
import com.browsersoft.commander.utils.prefs.PreferencesNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;

public class CommanderSettings {
    private static final String PROPERTY_DATE_FORMAT = "DateFormat";
    public static final String DEFAULT_DATE_FORMAT = "MM/dd/yyyy HH:mm";
    private static final String PROPERTY_GIT_ENABLED = "GitEnabled";
    private static final boolean DEFAULT_GIT_ENABLED = false;
    private static final String PROPERTY_GIT_CHECK_INTERVAL = "GitCheckInterval";
    private static final int DEFAULT_GIT_CHECK_INTERVAL = 60;
    private static final String PROPERTY_GIT_PATH = "GitPath";
    PreferencesNode preferencesNode = new PreferencesNode(this.getClass(), BuildInPluginsManager.getProfilesPrefix());

    public void setTempDir(String tempDir) throws IOException {
        if (tempDir.equals("")) {
            tempDir = CommanderSettings.getTempDirectory().getAbsolutePath();
        }
        this.preferencesNode.setItem("TempDir", tempDir);
    }

    public String getTempDir() throws IOException, ClassNotFoundException {
        File tempFile;
        String tempDir = (String)this.preferencesNode.getItem("TempDir");
        if (tempDir == null) {
            File temp = CommanderSettings.getTempDirectory();
            this.preferencesNode.setItem("TempDir", temp.getAbsolutePath());
        }
        if (!(tempFile = new File((tempDir = (String)this.preferencesNode.getItem("TempDir")) + "/")).exists() && !tempFile.mkdir()) {
            File temp = CommanderSettings.getTempDirectory();
            this.preferencesNode.setItem("TempDir", temp.getAbsolutePath());
        }
        tempDir = (String)this.preferencesNode.getItem("TempDir");
        return tempFile.getAbsolutePath();
    }

    public void setJavaPath(String javaPath) throws IOException {
        this.preferencesNode.setItem("JavaPath", javaPath);
    }

    public String getJavaPath() throws IOException, ClassNotFoundException {
        String javaPath = (String)this.preferencesNode.getItem("JavaPath");
        if (javaPath == null) {
            return "";
        }
        return javaPath;
    }

    public void setDateFormat(String dateFormat) throws IOException {
        if (dateFormat.equals("")) {
            dateFormat = DEFAULT_DATE_FORMAT;
        }
        this.preferencesNode.setItem(PROPERTY_DATE_FORMAT, dateFormat);
    }

    public String getDateFormat() throws IOException, ClassNotFoundException {
        String dateFormat = (String)this.preferencesNode.getItem(PROPERTY_DATE_FORMAT);
        if (dateFormat == null) {
            dateFormat = DEFAULT_DATE_FORMAT;
            this.preferencesNode.setItem(PROPERTY_DATE_FORMAT, dateFormat);
        }
        return dateFormat;
    }

    public void setGitEnabled(boolean gitEnabled) throws IOException {
        this.preferencesNode.setItem(PROPERTY_GIT_ENABLED, new Boolean(gitEnabled));
    }

    public boolean isGitEnabled() throws IOException, ClassNotFoundException {
        Boolean gitEnabled = (Boolean)this.preferencesNode.getItem(PROPERTY_GIT_ENABLED);
        if (gitEnabled == null) {
            gitEnabled = false;
            this.preferencesNode.setItem(PROPERTY_GIT_ENABLED, gitEnabled);
        }
        return gitEnabled;
    }

    public void setGitPath(String gitPath) throws IOException {
        if (gitPath == null || gitPath.equals("")) {
            gitPath = CommanderSettings.getDefaultGitPath();
        }
        this.preferencesNode.setItem(PROPERTY_GIT_PATH, gitPath);
    }

    public String getGitPath() throws IOException, ClassNotFoundException {
        String gitPath = (String)this.preferencesNode.getItem(PROPERTY_GIT_PATH);
        if (gitPath == null) {
            gitPath = CommanderSettings.getDefaultGitPath();
            this.preferencesNode.setItem(PROPERTY_GIT_PATH, gitPath);
        }
        return gitPath;
    }

    private static String getDefaultGitPath() {
        if (OSValidator.isWindows()) {
            return "git.exe";
        }
        return "git";
    }

    public void setGitCheckInterval(Integer interval) throws IOException {
        if (interval == null) {
            interval = 60;
        }
        this.preferencesNode.setItem(PROPERTY_GIT_CHECK_INTERVAL, String.valueOf(interval));
    }

    public int getGitCheckInterval() throws IOException, ClassNotFoundException {
        Integer interval;
        String intervalStr = (String)this.preferencesNode.getItem(PROPERTY_GIT_CHECK_INTERVAL);
        if (intervalStr == null) {
            interval = 60;
            this.preferencesNode.setItem(PROPERTY_GIT_CHECK_INTERVAL, String.valueOf(interval));
        } else {
            interval = Integer.valueOf(intervalStr);
        }
        return interval;
    }

    private static File getTempDirectory() throws IOException {
        File tempFile = File.createTempFile("MainApp", "", null);
        tempFile.delete();
        tempFile = new File(tempFile.getAbsolutePath() + "/");
        if (!tempFile.exists() && !tempFile.mkdir()) {
            throw new IOException();
        }
        return tempFile;
    }

    public List<String> getPath(String name) throws IOException, ClassNotFoundException {
        return (List)this.preferencesNode.getItem(name);
    }

    public void setPath(String name, List<String> path) throws IOException {
        this.preferencesNode.setItem(name, path);
    }

    public List<HotDirectoryListItem> getHotlist() throws ClassNotFoundException, IOException {
        List<Object> objects = this.preferencesNode.getCollection("Hotlist");
        ArrayList<HotDirectoryListItem> itemList = new ArrayList<HotDirectoryListItem>();
        for (Object o : objects) {
            HotDirectoryListItem hotDirectoryListItem = (HotDirectoryListItem)o;
            itemList.add(hotDirectoryListItem);
        }
        return itemList;
    }

    public void setHotlist(List<HotDirectoryListItem> hotlist) throws IOException {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (HotDirectoryListItem hotDirectoryListItem : hotlist) {
            objects.add(hotDirectoryListItem);
        }
        this.preferencesNode.setCollection("Hotlist", objects);
    }

    public ModuleInfoCollection loadModules() {
        List<Object> objects = this.preferencesNode.getCollection("Modules");
        ModuleInfoCollection moduleInfoCollection = new ModuleInfoCollection();
        for (Object o : objects) {
            ModuleInfo moduleInfo = (ModuleInfo)o;
            moduleInfoCollection.add(moduleInfo);
        }
        return moduleInfoCollection;
    }

    public void saveModules(ModuleInfoCollection moduleInfoCollection) throws IOException {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int j = 0; j < moduleInfoCollection.size(); ++j) {
            ModuleInfo moduleInfo = moduleInfoCollection.get(j);
            objects.add(moduleInfo);
        }
        this.preferencesNode.setCollection("Modules", objects);
    }

    public ProfileCollection loadProfiles(StorageTypeInfoCollection storages) {
        try {
            List<Object> storageNames = this.preferencesNode.getCollection("StorageNames");
            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
            for (Object object : storageNames) {
                String name = (String)object;
                CommanderPlugStorage commanderPlugStorage = this.getStorage(storages, name);
                classLoaders.add(commanderPlugStorage.getClass().getClassLoader());
            }
            List<Object> objects = this.preferencesNode.getCollection("Profiles", classLoaders);
            ArrayList<Profile> profilesList = new ArrayList<Profile>();
            for (int i = 0; i < objects.size(); ++i) {
                Profile profile = (Profile)objects.get(i);
                String storageName = (String)storageNames.get(i);
                CommanderPlugStorage commanderStorage = this.getStorage(storages, storageName);
                profile.setCommanderPlugStorage(commanderStorage);
                profilesList.add(profile);
            }
            ProfileCollection profiles = new ProfileCollection();
            profiles.setProfiles(profilesList);
            return profiles;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ProfileCollection();
        }
    }

    public void saveProfiles(ProfileCollection profiles) throws IOException {
        ArrayList<Object> objects = new ArrayList<Object>();
        ArrayList<Object> storageNames = new ArrayList<Object>();
        for (int j = 0; j < profiles.size(); ++j) {
            Profile profile = profiles.get(j);
            objects.add(profile);
            storageNames.add(profile.getCommanderPlugStorage().getFullStorageName());
        }
        this.preferencesNode.setCollection("StorageNames", storageNames);
        this.preferencesNode.setCollection("Profiles", objects);
    }

    private CommanderPlugStorage getStorage(StorageTypeInfoCollection storages, String storageName) {
        for (int j = 0; j < storages.size(); ++j) {
            StorageTypeInfo storageTypeInfo = storages.get(j);
            if (!storageTypeInfo.getStorage().getFullStorageName().equals(storageName)) continue;
            return storageTypeInfo.getStorage();
        }
        return null;
    }

    public void exportPreferences(OutputStream outputStream) throws BackingStoreException, IOException {
        this.preferencesNode.exportPreferences(outputStream);
    }

    public void importPreferences(InputStream inputStream) throws IOException, InvalidPreferencesFormatException {
        this.preferencesNode.importPreferences(inputStream);
    }
}

