/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.side;

import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.commanderwindow.paths.HotDirectoryListItem;
import com.browsersoft.commander.commanderwindow.search.SearchDialog;
import com.browsersoft.commander.commanderwindow.settings.CommanderSettings;
import com.browsersoft.commander.commanderwindow.side.DiscInfo;
import com.browsersoft.commander.commanderwindow.side.DiscInfoCollection;
import com.browsersoft.commander.commanderwindow.side.JCommanderSideHandler;
import com.browsersoft.commander.commanderwindow.table.JCommanderList;
import com.browsersoft.commander.commanderwindow.table.JCommanderListHandler;
import com.browsersoft.commander.model.CommanderPlugModel;
import com.browsersoft.commander.model.CommanderPlugStorageModelCollection;
import com.browsersoft.commander.model.CommanderPlugStorageModelListener;
import com.browsersoft.commander.model.plugin.PluginCollection;
import com.browsersoft.commander.utils.swing.DiscsCombo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import org.jdesktop.layout.GroupLayout;

public class JCommanderSide
extends JPanel
implements JCommanderListHandler,
CommanderPlugStorageModelListener {
    private CommanderPlugModel actualModel;
    private JCommanderSideHandler handler;
    private DiscInfoCollection discs;
    private int actualDisc;
    private JCommanderList commanderList;
    private PluginCollection pluginCollection;
    private String lastPathKey;
    private CommanderSettings commanderSettings;
    private JButton contextLabel;
    private Timer blinkTimer;
    private Color originalTopBackground;
    private JButton buttonHotDir;
    private JButton buttonRoot;
    private JButton buttonSearch;
    private JComboBox comboDisks;
    private JButton reloadButton;
    private JScrollPane jScrollPane2;
    private JLabel lblPath;
    private JPanel panelTop;
    private JPanel pathPanel;
    private JToolBar toolbar;
    private JTextField txtSearch;

    public JCommanderSide() {
        this.initComponents();
        this.originalTopBackground = this.panelTop.getBackground();
        this.commanderList = new JCommanderList();
        this.jScrollPane2.getViewport().setView(this.commanderList);
        this.comboDisks.setPreferredSize(new Dimension(250, 18));
        this.comboDisks.setMaximumSize(new Dimension(250, 18));
        this.comboDisks.setMinimumSize(new Dimension(250, 18));
        this.commanderList.setAutoResizeMode(0);
        this.jScrollPane2.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JCommanderSide.this.columnResized();
            }
        });
        this.comboDisks.setFont(new Font("Arial Unicode MS", 0, 11));
        this.lblPath.setFont(new Font("Arial Unicode MS", 0, 9));
        this.txtSearch.setFont(new Font("Arial Unicode MS", 0, 11));
        this.getCommanderList().setHandler(this);
        this.getCommanderList().initTable();
    }

    public CommanderPlugModel getActualModel() {
        return this.actualModel;
    }

    @Override
    public void openInOpositeWindow(String path) throws Exception {
        List<String> actualPath = this.getPath();
        actualPath.add(path);
        this.handler.openInOpositeWindow(actualPath, this);
    }

    @Override
    public void openInOppositeWindow(List<String> path) throws Exception {
        this.handler.openInOpositeWindow(path, this);
    }

    @Override
    public void openPath(List<String> path, boolean oposite) throws Exception {
        this.handler.openPath(path, oposite, this);
    }

    @Override
    public void reconnect() throws Exception {
        this.handler.reconnect();
    }

    public void init() throws Exception {
        ActionListener[] listeners = this.comboDisks.getActionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.comboDisks.removeActionListener(listeners[i]);
        }
        this.actualModel = this.discs.getElementAt(0).getModel();
        int initIndex = this.actualModel.getParentModelStorage().getInitialDisc();
        DiscInfo discInfo = this.discs.getElementAt(initIndex);
        this.comboDisks.setSelectedIndex(initIndex);
        Object initPath = this.actualModel.getParentModelStorage().getDisc(discInfo.getDiscIndex());
        this.actualDisc = this.actualModel.getParentModelStorage().getInitialDisc();
        this.actualModel.switchToDisc(initPath, this.pluginCollection);
        this.setPathToLabel();
        this.getCommanderList().setHandler(this);
        this.getCommanderList().setCommanderSideModel(this.actualModel);
        this.getCommanderList().reinitTable();
        this.comboDisks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    JCommanderSide.this.comboDiscsSelect();
                }
                catch (Exception ex) {
                    ErrorManager.notify(ex);
                }
            }
        });
    }

    @Override
    public void columnResized() {
        int newWidth = this.jScrollPane2.getViewport().getWidth();
        for (int i = 0; i < this.commanderList.getColumnCount(); ++i) {
            if (i == this.commanderList.getColumnCount() - 1) continue;
            newWidth -= this.commanderList.getColumnModel().getColumn(i).getWidth();
        }
        this.commanderList.getColumnModel().getColumn(this.commanderList.getColumnCount() - 1).setPreferredWidth(newWidth);
    }

    private void comboDiscsSelect() throws Exception {
        int selectedIndex = this.comboDisks.getSelectedIndex();
        if (this.discs != null && selectedIndex >= 0) {
            this.actualDisc = selectedIndex;
            this.switchToDisc();
        }
    }

    @Override
    public void showPopup(Component component, Point point, int onIndex) {
        if (this.handler != null) {
            this.handler.showPopup(component, point, onIndex);
        }
    }

    @Override
    public void selectionChanged() {
        if (this.handler != null) {
            this.handler.selectionChanged();
        }
    }

    public int[] getSelections() {
        int[] selection = null;
        selection = this.commanderList.hasFocus() ? this.commanderList.getSelectedRows() : this.getCommanderList().getLastSelections();
        return selection;
    }

    public JCommanderList getCommanderList() {
        return this.commanderList;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        this.handler.keyPressed(evt);
    }

    public void home() throws Exception {
        this.switchToDisc();
    }

    private boolean isInside(List<HotDirectoryListItem> itemList, List<String> actual) {
        for (HotDirectoryListItem item : itemList) {
            if (!this.compareTwoLists(actual, item.getIdPath())) continue;
            return true;
        }
        return false;
    }

    private boolean compareTwoLists(List<String> first, List<String> second) {
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            if (first.get(i).equals(second.get(i))) continue;
            return false;
        }
        return true;
    }

    private void addCurrentDir() throws Exception {
        List<String> path = this.getPath();
        List<HotDirectoryListItem> itemList = this.commanderSettings.getHotlist();
        if (!this.isInside(itemList, path)) {
            HotDirectoryListItem newItem = new HotDirectoryListItem();
            newItem.setHumanPath(this.actualModel.getActualPathForHuman());
            newItem.setIdPath(path);
            newItem.setIcon(HotDirectoryListItem.toImageIcon(this.actualModel.getActualRootIcon()));
            itemList.add(newItem);
            this.commanderSettings.setHotlist(itemList);
        }
    }

    private void goToHotDirectory(HotDirectoryListItem item) throws Exception {
        this.setPath(item.getIdPath());
    }

    public void reload() {
        try {
            this.actualModel.reload();
            this.commanderList.updateUI();
            this.setPathToLabel();
        }
        catch (Exception ex) {
            ErrorManager.notify(ex);
        }
    }

    @Override
    public void focusGained(JCommanderList me) {
        this.handler.focusGained(this);
        this.panelTop.setBackground(new Color(255, 255, 255, 40));
        Font font = this.contextLabel.getFont();
        this.contextLabel.setFont(font.deriveFont(font.getStyle() | 1));
        this.contextLabel.setForeground(Color.ORANGE);
    }

    public void makeFocusLost() {
        this.panelTop.setBackground(this.originalTopBackground);
        Font font = this.contextLabel.getFont();
        this.contextLabel.setFont(font.deriveFont(font.getStyle() & 0xFFFFFFFE));
        this.contextLabel.setForeground(Color.GRAY);
        this.commanderList.makeFocusLost();
    }

    public void makeFocusGain() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JCommanderSide.this.commanderList.grabFocus();
            }
        });
    }

    public void moveToItemStartWith(String text) {
        int index = this.actualModel.getIndexOfItemStartWith(text);
        if (index >= 0) {
            Rectangle r = this.commanderList.getCellRect(index, 1, true);
            this.jScrollPane2.getViewport().setViewPosition(new Point(0, r.y));
            this.commanderList.setSelectionInterval(index, index);
        }
    }

    public void updatePath() throws Exception {
        this.commanderSettings.setPath(this.lastPathKey, this.getPath());
    }

    public void setLastPath() throws Exception {
        this.setPath(this.commanderSettings.getPath(this.lastPathKey));
    }

    public void goToDefault() throws Exception {
        this.actualDisc = this.actualModel.getParentModelStorage().getInitialDisc();
        this.switchToDisc();
    }

    public List<String> getPath() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        DiscInfo info = this.discs.getElementAt(this.actualDisc);
        arrayList.add(info.getProfileName());
        String[] ids = this.actualModel.getActualIdsPath();
        arrayList.addAll(Arrays.asList(ids));
        return arrayList;
    }

    public void setPath(List<String> arrayList) throws Exception {
        try {
            if (arrayList != null) {
                for (int i = 0; i < this.discs.getSize(); ++i) {
                    DiscInfo info = this.discs.getElementAt(i);
                    if (!info.getProfileName().equals(arrayList.get(0)) || !info.getDiscId().equals(arrayList.get(1))) continue;
                    this.actualDisc = i;
                    this.comboDisks.setSelectedIndex(i);
                    String[] path = new String[arrayList.size() - 2];
                    for (int j = 0; j < arrayList.size() - 2; ++j) {
                        path[j] = arrayList.get(j + 2);
                    }
                    this.actualModel.setActualIdsPath(path);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setPathToLabel();
        this.updatePath();
    }

    private void switchToDisc() throws Exception {
        DiscInfo info = this.discs.getElementAt(this.actualDisc);
        this.actualModel = info.getModel();
        Object newPath = this.actualModel.getParentModelStorage().getDisc(info.getDiscIndex());
        try {
            this.actualModel.switchToDisc(newPath, this.pluginCollection);
            this.getCommanderList().setCommanderSideModel(this.actualModel);
            this.getCommanderList().refreshUI();
        }
        catch (Exception ex) {
            if (ex.getClass().getSimpleName().equals("XmlFileChangedException")) {
                ErrorManager.notifyWithCustomMsg(ex, null);
            }
            ErrorManager.notify(ex);
        }
        this.setPathToLabel();
        this.updatePath();
        this.commanderList.updateUI();
        this.handler.selectionChanged();
        this.makeFocusGain();
    }

    private void setPathToLabel() throws Exception {
        this.lblPath.setText(this.actualModel.getActualPathForHuman());
        this.contextLabel.setText(this.actualModel.getContextLabel());
        if (this.actualModel.getContextLabelError() != null) {
            this.contextLabel.setBorderPainted(true);
            this.contextLabel.setForeground(Color.RED);
            this.contextLabel.setBorder(new LineBorder(Color.RED, 2));
            this.contextLabel.setCursor(new Cursor(12));
            this.blinkTimer.start();
        } else {
            this.contextLabel.setBorderPainted(false);
            this.contextLabel.setCursor(null);
            this.contextLabel.setForeground(Color.ORANGE);
            this.blinkTimer.stop();
        }
        this.updateUI();
    }

    @Override
    public void goInto() {
        try {
            if (this.actualModel != null) {
                this.setPathToLabel();
                this.updatePath();
                this.handler.selectionChanged();
            }
        }
        catch (Exception ex) {
            ErrorManager.notify(ex);
        }
    }

    @Override
    public boolean canBeDraggedInTable(int index) throws Exception {
        int size = this.actualModel.getNumberOfActions();
        for (int i = 0; i < size; ++i) {
            if (this.actualModel.getActionType(i) != 4) continue;
            return this.actualModel.checkReorder(i, this.getSelections(), index);
        }
        return false;
    }

    @Override
    public void dragInTable(int index) throws Exception {
        int size = this.actualModel.getNumberOfActions();
        for (int i = 0; i < size; ++i) {
            if (this.actualModel.getActionType(i) != 4) continue;
            this.actualModel.reorder(i, this.getSelections(), index);
            try {
                this.commanderList.setSelectionInterval(index, index);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.reload();
        }
    }

    @Override
    public boolean canBeDraggedBetweenSides() throws Exception {
        return this.handler.canBeDraggedBetweenSides();
    }

    @Override
    public void dragBetweenSides(int index) {
        this.handler.dragBetweenSides(index, this);
    }

    public void search() throws Exception {
        SearchDialog searchDialog = new SearchDialog((Frame)this.getAncesor(), true);
        searchDialog.run(this.actualModel, this.txtSearch.getText());
        this.commanderList.updateUI();
        this.setPathToLabel();
    }

    public JFrame getAncesor() {
        return (JFrame)SwingUtilities.getWindowAncestor(this);
    }

    public JCommanderSideHandler getHandler() {
        return this.handler;
    }

    public void setHandler(JCommanderSideHandler handler) {
        this.handler = handler;
    }

    private void initComponents() {
        this.pathPanel = new JPanel();
        this.lblPath = new JLabel();
        this.panelTop = new JPanel();
        this.toolbar = new JToolBar();
        this.buttonRoot = new JButton();
        this.reloadButton = new JButton();
        this.buttonHotDir = new JButton();
        this.comboDisks = new DiscsCombo();
        this.txtSearch = new JTextField();
        this.buttonSearch = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.setPreferredSize(new Dimension(439, 587));
        this.pathPanel.setBackground(new Color(230, 230, 232));
        this.lblPath.setText("");
        this.lblPath.setForeground(Color.BLACK);
        GroupLayout pathPanelLayout = new GroupLayout((Container)this.pathPanel);
        this.pathPanel.setLayout((LayoutManager)pathPanelLayout);
        pathPanelLayout.setHorizontalGroup((GroupLayout.Group)pathPanelLayout.createParallelGroup(1).add((GroupLayout.Group)pathPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.lblPath, -1, 417, Short.MAX_VALUE).addContainerGap()));
        pathPanelLayout.setVerticalGroup((GroupLayout.Group)pathPanelLayout.createParallelGroup(1).add(2, (Component)this.lblPath, -1, 14, Short.MAX_VALUE));
        this.panelTop.setPreferredSize(new Dimension(439, 33));
        this.toolbar.setFloatable(false);
        this.toolbar.setOpaque(false);
        this.toolbar.setPreferredSize(new Dimension(92, 20));
        this.buttonRoot.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/icons/home.png")));
        this.buttonRoot.setBorderPainted(false);
        this.buttonRoot.setFocusPainted(false);
        this.buttonRoot.setMaximumSize(new Dimension(24, 24));
        this.buttonRoot.setMinimumSize(new Dimension(24, 24));
        this.buttonRoot.setPreferredSize(new Dimension(24, 24));
        this.buttonRoot.setCursor(new Cursor(12));
        this.buttonRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCommanderSide.this.buttonRootActionPerformed(evt);
            }
        });
        this.toolbar.add(this.buttonRoot);
        this.reloadButton.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/icons/reload.png")));
        this.reloadButton.setBorderPainted(false);
        this.reloadButton.setFocusPainted(false);
        this.reloadButton.setCursor(new Cursor(12));
        this.reloadButton.setMaximumSize(new Dimension(20, 20));
        this.reloadButton.setMinimumSize(new Dimension(24, 24));
        this.reloadButton.setPreferredSize(new Dimension(24, 24));
        this.reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCommanderSide.this.reload();
            }
        });
        this.toolbar.add(this.reloadButton);
        this.contextLabel = new JButton();
        this.contextLabel.setMargin(new Insets(8, 10, 8, 10));
        this.contextLabel.setForeground(Color.ORANGE);
        this.contextLabel.setFocusPainted(false);
        this.contextLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (JCommanderSide.this.actualModel.getContextLabelError() != null) {
                        ErrorManager.notify(JCommanderSide.this.actualModel.getContextLabelError());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.blinkTimer = new Timer(500, new ActionListener(){
            private boolean on = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                JCommanderSide.this.contextLabel.setForeground(this.on ? Color.RED : Color.BLACK);
                this.on = !this.on;
                JCommanderSide.this.contextLabel.updateUI();
            }
        });
        this.toolbar.add(this.contextLabel);
        this.comboDisks.setMaximumRowCount(16);
        this.comboDisks.setModel(new DefaultComboBoxModel<String>(new String[]{"[-C-]"}));
        this.comboDisks.setDoubleBuffered(true);
        this.comboDisks.setFocusable(false);
        this.comboDisks.setMaximumSize(new Dimension(50, 18));
        this.comboDisks.setMinimumSize(new Dimension(43, 15));
        this.comboDisks.setOpaque(false);
        this.comboDisks.setPreferredSize(new Dimension(40, 15));
        this.comboDisks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCommanderSide.this.comboDisksActionPerformed(evt);
            }
        });
        GroupLayout panelTopLayout = new GroupLayout((Container)this.panelTop);
        this.panelTop.setLayout((LayoutManager)panelTopLayout);
        panelTopLayout.setHorizontalGroup((GroupLayout.Group)panelTopLayout.createParallelGroup(1).add((GroupLayout.Group)panelTopLayout.createSequentialGroup().add(2, 2, 2).add((Component)this.comboDisks, 0, 265, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.toolbar, -1, 166, Short.MAX_VALUE)));
        panelTopLayout.setVerticalGroup((GroupLayout.Group)panelTopLayout.createParallelGroup(1).add(2, (GroupLayout.Group)panelTopLayout.createSequentialGroup().add((GroupLayout.Group)panelTopLayout.createParallelGroup(2).add(1, (Component)this.comboDisks, -1, 20, Short.MAX_VALUE).add((Component)this.toolbar, -2, -1, -2)).add(5, 5, 5)));
        this.txtSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JCommanderSide.this.txtSearchKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                JCommanderSide.this.txtSearchKeyTyped(evt);
            }
        });
        this.buttonSearch.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/icons/search.png")));
        this.buttonSearch.setBorderPainted(false);
        this.buttonSearch.setContentAreaFilled(false);
        this.buttonSearch.setFocusPainted(false);
        this.buttonSearch.setMaximumSize(new Dimension(24, 24));
        this.buttonSearch.setMinimumSize(new Dimension(24, 24));
        this.buttonSearch.setPreferredSize(new Dimension(24, 24));
        this.buttonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCommanderSide.this.buttonSearchActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.panelTop, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane2, -1, 439, Short.MAX_VALUE).add((Component)this.pathPanel, -1, -1, Short.MAX_VALUE)).add(0, 0, 0)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(2, 2, 2).add((Component)this.panelTop, -2, 21, -2).add(0, 0, 0).add((Component)this.pathPanel, -2, -1, -2).add(0, 0, 0).add((Component)this.jScrollPane2, -1, 530, Short.MAX_VALUE)));
    }

    private void buttonRootActionPerformed(ActionEvent evt) {
        try {
            this.home();
        }
        catch (Exception ex) {
            ErrorManager.notify(ex);
        }
    }

    private void comboDisksActionPerformed(ActionEvent evt) {
    }

    private void buttonSearchActionPerformed(ActionEvent evt) {
        try {
            this.search();
        }
        catch (Exception ex) {
            ErrorManager.notify(ex);
        }
    }

    private void txtSearchKeyTyped(KeyEvent evt) {
    }

    private void txtSearchKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                this.search();
            }
            catch (Exception ex) {
                ErrorManager.notify(ex);
            }
        }
    }

    public PluginCollection getPluginCollection() {
        return this.pluginCollection;
    }

    public void setPluginCollection(PluginCollection pluginCollection) {
        this.pluginCollection = pluginCollection;
    }

    public String getLastPathKey() {
        return this.lastPathKey;
    }

    public void setLastPathKey(String lastPathKey) {
        this.lastPathKey = lastPathKey;
    }

    public void setContextLabelText(String text) {
        this.contextLabel.setText(text);
    }

    public void setCommanderSettings(CommanderSettings commanderSettings) {
        this.commanderSettings = commanderSettings;
    }

    public void setStorageModels(CommanderPlugStorageModelCollection storageModels) throws Exception {
        this.discs = new DiscInfoCollection(storageModels, this.getCommanderList());
        this.comboDisks.setModel(this.discs);
        this.init();
        storageModels.addStorageListener(this);
    }

    @Override
    public void storagesChanged() {
        if (this.discs == null) {
            return;
        }
        if (this.discs.getSelectedItem() == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

