/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.customEditor;

import com.browsersoft.commander.customEditor.DiffNode;
import com.browsersoft.commander.customEditor.FilePanel;
import com.browsersoft.commander.customEditor.ParentListener;
import com.browsersoft.commander.customEditor.RevisionBar;
import com.browsersoft.commander.customEditor.SavePanelDialog;
import com.browsersoft.commander.customEditor.VerticalSyncScroller;
import com.browsersoft.commander.customEditor.java_diff_utils.Delta;
import com.browsersoft.commander.customEditor.java_diff_utils.DiffUtils;
import com.browsersoft.commander.customEditor.java_diff_utils.Patch;
import com.browsersoft.commander.utils.CenteredDialog;
import com.browsersoft.commander.utils.swing.KeyBuffer;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoManager;

public class DiffEditor
extends CenteredDialog
implements ParentListener {
    private DiffNode leftDiffNode;
    private DiffNode rightDiffNode;
    private JPanel mainPanel;
    private FilePanel leftFilePanel;
    private FilePanel rightFilePanel;
    private final Diff diffs = new Diff();
    private VerticalSyncScroller scroller;
    private RevisionBar leftRevisionBar;
    private RevisionBar rightRevisionBar;

    public static void main(String[] args) throws IOException {
        DiffNode[] nodes = DiffEditor.testWithFiles();
        SwingUtilities.invokeLater(() -> {
            JButton button = new JButton("Show diff");
            button.addActionListener(e -> {
                try {
                    new DiffEditor(nodes[0], nodes[1]).setVisible(true);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            });
            JFrame frame = new JFrame();
            frame.add(button);
            frame.setDefaultCloseOperation(3);
            frame.setSize(800, 600);
            frame.setLocationRelativeTo(null);
            frame.toFront();
            frame.setVisible(true);
        });
    }

    private static DiffNode[] testWithByteArrays() throws IOException {
        DiffNode leftByteDiffNode = new DiffNode("Line 1\nLine 2\nLine 3\nLine 4\nLine 5\nLine 6\nLine 7\nab\nLine 9\nabcb\nLine 10\nLine 11".getBytes(), true);
        DiffNode rightByteDiffNode = new DiffNode("Line 2\nLine 3 with changes\nLine 4\nLine 5 with changes and\na new line\nLine 6\nnew line 6.1\nLine 7\nabab\nLine 9\nab\nLine 10\nLine 11 with changes\n".getBytes(), true);
        return new DiffNode[]{leftByteDiffNode, rightByteDiffNode};
    }

    private static DiffNode[] testWithFiles() throws IOException {
        File file1 = File.createTempFile("file1", ".txt");
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file1));){
            out.write("Line 1\nLine 2\nLine 3\nLine 4\nLine 5\nLine 6\nLine 7\nab\nLine 9\nabcb\nLine 10\nLine 11");
        }
        File file2 = File.createTempFile("file2", ".txt");
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file2));){
            out.write("Line 2\nLine 3 with changes\nLine 4\nLine 5 with changes and\na new line\nLine 6\nnew line 6.1\nLine 7\nabab\nLine 9\nab\nLine 10\nLine 11 with changes\n");
        }
        DiffNode leftDiffNode = new DiffNode(file1, false);
        leftDiffNode.registerSaveHandler(text -> {
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file1, false));){
                bos.write(text.getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        DiffNode rightDiffNode = new DiffNode(file2, false);
        rightDiffNode.registerSaveHandler(text -> {
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file2, false));){
                bos.write(text.getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return new DiffNode[]{leftDiffNode, rightDiffNode};
    }

    public DiffEditor(DiffNode node1, DiffNode node2) throws IOException {
        this.setLayout(new BorderLayout());
        this.setResizable(true);
        if (node1 == null || node2 == null) {
            throw new IllegalArgumentException("Diff nodes must not be null");
        }
        this.leftDiffNode = node1;
        this.rightDiffNode = node2;
        this.init();
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize((int)(0.8 * (double)screenSize.width), (int)(0.8 * (double)screenSize.height));
        this.centerParent();
    }

    private void init() throws IOException {
        this.preparePanels();
        this.showFileContents();
        this.filePanelTextChange();
    }

    private void preparePanels() {
        this.mainPanel = new JPanel((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec("fill:3px:noGrow"), new ColumnSpec("fill:pref:noGrow"), new ColumnSpec("fill:3px:noGrow"), new ColumnSpec("fill:0px:grow"), new ColumnSpec("fill:5px:noGrow"), new ColumnSpec("fill:min:noGrow"), new ColumnSpec("fill:40px:nogrow"), new ColumnSpec("fill:0px:grow"), new ColumnSpec("fill:25px:noGrow"), new ColumnSpec("fill:min:noGrow"), new ColumnSpec("fill:3px:noGrow"), new ColumnSpec("fill:pref:noGrow"), new ColumnSpec("fill:3px:noGrow")}, new RowSpec[]{new RowSpec("center:3px:noGrow"), new RowSpec("center:pref:noGrow"), new RowSpec("center:3px:noGrow"), new RowSpec("fill:0px:grow"), new RowSpec("center:pref:noGrow"), new RowSpec("center:3px:noGrow")}));
        this.leftFilePanel = new FilePanel(this.leftDiffNode, FilePanel.Orientation.LEFT);
        this.rightFilePanel = new FilePanel(this.rightDiffNode, FilePanel.Orientation.RIGHT);
        this.scroller = new VerticalSyncScroller(this.leftFilePanel, this.rightFilePanel);
        this.leftRevisionBar = new RevisionBar(this.diffs, this.leftFilePanel, this.scroller);
        this.rightRevisionBar = new RevisionBar(this.diffs, this.rightFilePanel, this.scroller);
        this.addActionsToMainPanel(this.mainPanel);
        this.panelsWithFormLayout();
        this.add(this.mainPanel);
    }

    private void panelsWithFormLayout() {
        CellConstraints cc = new CellConstraints();
        this.mainPanel.add((Component)this.leftRevisionBar, cc.xy(2, 4));
        this.mainPanel.add((Component)this.leftFilePanel.getSaveButton(), cc.xy(2, 2));
        this.mainPanel.add((Component)this.leftFilePanel.getFileLabel(), cc.xyw(4, 2, 3));
        this.mainPanel.add((Component)this.leftFilePanel.getScrollPane(), cc.xyw(4, 4, 3));
        this.mainPanel.add((Component)this.rightRevisionBar, cc.xy(12, 4));
        this.mainPanel.add((Component)this.rightFilePanel.getFileLabel(), cc.xyw(8, 2, 3));
        this.mainPanel.add((Component)this.rightFilePanel.getScrollPane(), cc.xyw(8, 4, 3));
        this.mainPanel.add((Component)this.rightFilePanel.getSaveButton(), cc.xy(12, 2));
    }

    private void panelsWithGridBagLayout() {
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.fill = 3;
        this.mainPanel.add((Component)this.leftRevisionBar, gbc);
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.mainPanel.add((Component)this.leftFilePanel.getSaveButton(), gbc);
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        this.mainPanel.add((Component)this.leftFilePanel.getFileLabel(), gbc);
        gbc.gridx = 4;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        this.mainPanel.add((Component)this.leftFilePanel.getScrollPane(), gbc);
        gbc.gridx = 12;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        this.mainPanel.add((Component)this.rightRevisionBar, gbc);
        gbc.gridx = 8;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        this.mainPanel.add((Component)this.rightFilePanel.getFileLabel(), gbc);
        gbc.gridx = 8;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        this.mainPanel.add((Component)this.rightFilePanel.getScrollPane(), gbc);
        gbc.gridx = 12;
        gbc.gridy = 2;
        this.mainPanel.add((Component)this.rightFilePanel.getSaveButton(), gbc);
        this.leftFilePanel.setPreferredSize(new Dimension(300, 450));
        this.rightFilePanel.setPreferredSize(new Dimension(300, 450));
    }

    private void addActionsToMainPanel(JPanel mainPanel) {
        this.installKey(mainPanel, 83, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffEditor.this.getSelectedPanel().saveFile();
            }
        });
        this.installKey(mainPanel, 90, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager undoManager = DiffEditor.this.getSelectedPanel().getUndoManager();
                if (undoManager.canUndo()) {
                    undoManager.undo();
                }
            }
        });
        int modifierKeys = this.getToolkit().getMenuShortcutKeyMask() | 0x40;
        KeyBuffer.installKey(mainPanel, 90, modifierKeys, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager undoManager = DiffEditor.this.getSelectedPanel().getUndoManager();
                if (undoManager.canRedo()) {
                    undoManager.redo();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                DiffEditor.this.scroller.scrollToLine(DiffEditor.this.leftFilePanel, 0);
                DiffEditor.this.scroller.scrollToLine(DiffEditor.this.rightFilePanel, 0);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                boolean saved = DiffEditor.this.checkSave();
                if (saved) {
                    DiffEditor.this.dispose();
                }
            }
        });
    }

    private boolean checkSave() {
        boolean savedOk = true;
        if (!this.leftFilePanel.isSaved() || !this.rightFilePanel.isSaved()) {
            SavePanelDialog savePanelDialog = new SavePanelDialog(this);
            savePanelDialog.show();
            savedOk = savePanelDialog.doSave();
        }
        return savedOk;
    }

    private FilePanel getSelectedPanel() {
        return this.leftFilePanel.isPanelSelected() ? this.leftFilePanel : this.rightFilePanel;
    }

    private void installKey(JPanel mainPanel, int key, Action action) {
        int c = this.getToolkit().getMenuShortcutKeyMask();
        KeyBuffer.installKey(mainPanel, key, c, action);
    }

    private void showFileContents() throws IOException {
        this.leftFilePanel.showText();
        this.leftFilePanel.setParentListener(this);
        this.rightFilePanel.showText();
        this.rightFilePanel.setParentListener(this);
    }

    private void showFileDiffs() {
        if (this.leftFilePanel == null || this.rightFilePanel == null) {
            return;
        }
        this.leftFilePanel.highlightDiffs(this.diffs.getDeltas());
        this.leftFilePanel.repaint();
        this.rightFilePanel.highlightDiffs(this.diffs.getDeltas());
        this.rightFilePanel.repaint();
    }

    public FilePanel getLeftFilePanel() {
        return this.leftFilePanel;
    }

    public FilePanel getRightFilePanel() {
        return this.rightFilePanel;
    }

    @Override
    public void filePanelTextChange() {
        this.computeDiff();
        this.showFileDiffs();
        this.refreshRevisionBars();
    }

    private void refreshRevisionBars() {
        if (this.leftRevisionBar == null || this.rightRevisionBar == null) {
            return;
        }
        this.leftRevisionBar.repaint();
        this.rightRevisionBar.repaint();
    }

    @Override
    public void filePanelGainedFocus(FilePanel filePanel) {
        if (this.leftFilePanel == filePanel) {
            this.leftFilePanel.setPanelSelected(true);
            this.rightFilePanel.setPanelSelected(false);
        } else if (this.rightFilePanel == filePanel) {
            this.leftFilePanel.setPanelSelected(false);
            this.rightFilePanel.setPanelSelected(true);
        } else {
            throw new IllegalStateException("The filePanel which gets focus is unknown");
        }
    }

    private void computeDiff() {
        this.diffs.setPatch(DiffUtils.diff(this.leftDiffNode.getLines(), this.rightDiffNode.getLines()));
    }

    public static class Diff {
        private Patch patch;

        public void setPatch(Patch patch) {
            this.patch = patch;
        }

        public List<Delta> getDeltas() {
            return this.patch == null ? Collections.emptyList() : this.patch.getDeltas();
        }

        public boolean isReady() {
            return this.patch != null;
        }
    }
}

