/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.customEditor;

import com.browsersoft.commander.customEditor.FilePanel;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class DiffHighlighter
implements Highlighter {
    private JTextComponent component;
    private boolean doNotRepaint;
    private final Layer TOP_LAYER = Layer.values()[Layer.values().length - 1];
    private final Map<Layer, List<Highlighter.Highlight>> highlights = new HashMap<Layer, List<Highlighter.Highlight>>();

    public DiffHighlighter() {
        for (int i = 0; i < Layer.values().length; ++i) {
            this.highlights.put(Layer.values()[i], new ArrayList());
        }
    }

    @Override
    public void install(JTextComponent c) {
        this.component = c;
        this.removeAllHighlights();
    }

    @Override
    public void deinstall(JTextComponent c) {
        this.component = null;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int lineHeight = this.component.getFontMetrics(this.component.getFont()).getHeight();
        int startOffset = this.component.viewToModel(new Point(clip.x - lineHeight, clip.y));
        int endOffset = this.component.viewToModel(new Point(clip.x, clip.y + clip.height + lineHeight));
        FilePanel.LineNumberBorder lineNumberBorder = null;
        if (this.component.getBorder() instanceof FilePanel.LineNumberBorder && (lineNumberBorder = (FilePanel.LineNumberBorder)this.component.getBorder()) != null) {
            lineNumberBorder.paintBefore(g);
        }
        Rectangle a = null;
        for (List<Highlighter.Highlight> list : this.highlights.values()) {
            if (list.isEmpty()) continue;
            if (a == null) {
                a = this.component.getBounds();
                Insets insets = this.component.getInsets();
                a.x = insets.left;
                a.y = insets.top;
                a.width -= insets.left + insets.right;
                a.height -= insets.top + insets.bottom;
            }
            for (Highlighter.Highlight hli : list) {
                if (hli.getStartOffset() > endOffset || hli.getEndOffset() < startOffset) continue;
                hli.getPainter().paint(g, hli.getStartOffset(), hli.getEndOffset(), a, this.component);
            }
        }
        if (lineNumberBorder != null) {
            lineNumberBorder.paintAfter(g, startOffset, endOffset);
        }
    }

    @Override
    public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter painter) throws BadLocationException {
        return this.addHighlight(this.TOP_LAYER, p0, p1, painter);
    }

    public HighlightInfo addHighlight(Layer layer, int p0, int p1, Highlighter.HighlightPainter painter) throws BadLocationException {
        if (p0 > p1) {
            throw new IllegalArgumentException("The start position for highlighting cannot be lower then endposition!");
        }
        Document doc = this.component.getDocument();
        HighlightInfo hli = new HighlightInfo(doc.createPosition(p0), doc.createPosition(p1), painter);
        this.highlights.get((Object)layer).add(hli);
        this.repaint();
        return hli;
    }

    @Override
    public void removeHighlight(Object tag) {
        this.highlights.get((Object)this.TOP_LAYER).remove(tag);
        this.repaint();
    }

    @Override
    public void removeAllHighlights() {
        for (List<Highlighter.Highlight> layerHighlights : this.highlights.values()) {
            layerHighlights.clear();
        }
        this.repaint();
    }

    @Override
    public void changeHighlight(Object tag, int p0, int p1) throws BadLocationException {
        Document doc = this.component.getDocument();
        HighlightInfo hli = (HighlightInfo)tag;
        hli.setPositions(doc.createPosition(p0), doc.createPosition(p1));
        this.repaint();
    }

    @Override
    public Highlighter.Highlight[] getHighlights() {
        ArrayList<Highlighter.Highlight> allHighlights = new ArrayList<Highlighter.Highlight>();
        for (List<Highlighter.Highlight> layerHighlights : this.highlights.values()) {
            allHighlights.addAll(layerHighlights);
        }
        return allHighlights.toArray(new Highlighter.Highlight[0]);
    }

    private void repaint() {
        if (this.doNotRepaint) {
            return;
        }
        this.component.repaint();
    }

    public void setDoNotRepaint(boolean doNotRepaint) {
        this.doNotRepaint = doNotRepaint;
    }

    private class HighlightInfo
    implements Highlighter.Highlight {
        private Position p0;
        private Position p1;
        private final Highlighter.HighlightPainter painter;

        HighlightInfo(Position p0, Position p1, Highlighter.HighlightPainter painter) {
            this.p0 = p0;
            this.p1 = p1;
            this.painter = painter;
        }

        public void setPositions(Position p0, Position p1) {
            this.p0 = p0;
            this.p1 = p1;
        }

        @Override
        public int getStartOffset() {
            return this.p0.getOffset();
        }

        @Override
        public int getEndOffset() {
            return this.p1.getOffset();
        }

        @Override
        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }

    static enum Layer {
        FIRST,
        SECOND;

    }
}

