/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.customEditor;

import com.browsersoft.commander.customEditor.DiffHighlighter;
import com.browsersoft.commander.customEditor.DiffNode;
import com.browsersoft.commander.customEditor.ParentListener;
import com.browsersoft.commander.customEditor.google_diff_match_patch.Diff_match_patch;
import com.browsersoft.commander.customEditor.java_diff_utils.Chunk;
import com.browsersoft.commander.customEditor.java_diff_utils.Delta;
import com.browsersoft.commander.customEditor.utils.Colors;
import com.browsersoft.commander.customEditor.utils.ImageUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.undo.UndoManager;

public class FilePanel
extends JTextPane {
    private final JScrollPane scrollPane;
    private final Orientation orientation;
    private final DiffNode diffNode;
    private ParentListener parentListener;
    private final Timer timer;
    private final JLabel fileLabel;
    private final JButton saveButton;
    private final UndoManager undoManager;
    private boolean panelSelected;
    private boolean saved = true;

    FilePanel(DiffNode diffNode, Orientation orientation) {
        if (diffNode == null || orientation == null) {
            throw new IllegalArgumentException("FilePanel diffNode and panel orientation must not be null!");
        }
        this.diffNode = diffNode;
        this.orientation = orientation;
        this.panelSelected = orientation == Orientation.LEFT;
        this.setContentType("text/plain");
        this.timer = new Timer(700, null);
        this.initRefreshTimer();
        this.undoManager = new UndoManager();
        this.saveButton = new JButton();
        this.initSaveButton();
        this.fileLabel = new JLabel(diffNode.getNameLabel());
        JPanel noWrapPanel = new JPanel(new BorderLayout());
        noWrapPanel.add(this);
        this.scrollPane = new JScrollPane(noWrapPanel, 20, 30);
        this.initScrollPane();
        this.initLineNumbers();
        this.setHighlighter(new DiffHighlighter());
        this.setSelectionColor(new Color(200, 200, 200));
        this.setEditable(!diffNode.isReadableOnly());
        this.setFocusable(true);
    }

    private void initRefreshTimer() {
        this.timer.addActionListener(ev -> {
            if (this.timer.isRunning()) {
                this.timer.restart();
                return;
            }
            this.diffNode.updateLines(this.getText());
            if (this.parentListener != null) {
                this.parentListener.filePanelTextChange();
            }
        });
        this.timer.setRepeats(false);
    }

    private void initSaveButton() {
        this.saveButton.setEnabled(!this.diffNode.isReadableOnly() && !this.saved);
        this.saveButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.saveButton.setContentAreaFilled(false);
        this.saveButton.addActionListener(event -> this.saveFile());
        this.saveButton.setIcon(ImageUtil.getSaveButtonImage());
        this.saveButton.setDisabledIcon(ImageUtil.getSaveButtonTransparentImage());
    }

    public void saveFile() {
        this.diffNode.writeFile(this.getText());
        this.saved = true;
        this.saveButton.setEnabled(!this.saved);
    }

    private void initScrollPane() {
        this.scrollPane.getViewport().setScrollMode(1);
        if (this.orientation == Orientation.LEFT) {
            ScrollPaneLayout layout = new ScrollPaneLayout(){

                @Override
                public void layoutContainer(Container parent) {
                    ComponentOrientation originalOrientation = parent.getComponentOrientation();
                    parent.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                    super.layoutContainer(parent);
                    parent.setComponentOrientation(originalOrientation);
                }
            };
            this.scrollPane.setLayout(layout);
            layout.syncWithScrollPane(this.scrollPane);
            this.scrollPane.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.TRUE);
        }
        Font defaultTextAreaFont = new Font("Dialog", 0, 12);
        this.setFont(defaultTextAreaFont);
        FontMetrics fm = this.getFontMetrics(defaultTextAreaFont);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(fm.getHeight());
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(fm.getHeight());
    }

    private void initLineNumbers() {
        this.setBorder(new LineNumberBorder(this));
    }

    public void setPanelSelected(boolean panelSelected) {
        this.panelSelected = panelSelected;
    }

    public boolean isPanelSelected() {
        return this.panelSelected;
    }

    public boolean isLeftOriented() {
        return this.orientation == Orientation.LEFT;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JLabel getFileLabel() {
        return this.fileLabel;
    }

    public DiffNode getDiffNode() {
        return this.diffNode;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public boolean isSaved() {
        return this.saved;
    }

    void setParentListener(final ParentListener parentNotifier) {
        if (parentNotifier == null) {
            throw new IllegalArgumentException("ParentNotifier must not be null!");
        }
        if (this.parentListener != null) {
            System.err.println("setParentListener must be called just once");
            return;
        }
        this.parentListener = parentNotifier;
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.anyChange(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.anyChange(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.anyChange(e);
            }

            private void anyChange(DocumentEvent e) {
                FilePanel.this.saved = false;
                FilePanel.this.saveButton.setEnabled(!FilePanel.this.diffNode.isReadableOnly() && !FilePanel.this.saved);
                FilePanel.this.timer.restart();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                parentNotifier.filePanelGainedFocus(FilePanel.this);
            }
        });
        this.getDocument().addUndoableEditListener(this.undoManager);
    }

    public void showText() {
        this.setText(this.diffNode.getText());
    }

    public void highlightDiffs(List<Delta> deltas) {
        this.removeHighlights();
        for (Delta delta : deltas) {
            this.highlightDelta(delta);
            if (delta.getType() != Delta.TYPE.CHANGE) continue;
            this.hightlightChangeInChangedLine(delta);
        }
    }

    private void highlightDelta(Delta delta) {
        int endPosition;
        Chunk chunk = this.orientation == Orientation.LEFT ? delta.getOriginal() : delta.getRevised();
        int lineFrom = chunk.getPosition();
        int startPosition = this.diffNode.getLineEndOffsetPosition(lineFrom);
        boolean isEmptyLine = this.isEmptyLine(delta, startPosition, endPosition = this.diffNode.getLineEndOffsetPosition(lineFrom + chunk.size()));
        if (isEmptyLine) {
            endPosition = startPosition + 1;
        }
        DefaultHighlighter.DefaultHighlightPainter highlightingPainter = Colors.getPainter(delta.getType(), isEmptyLine);
        this.highlight(startPosition, endPosition, DiffHighlighter.Layer.FIRST, highlightingPainter);
    }

    private boolean isEmptyLine(Delta delta, int startPosition, int endPosition) {
        return this.orientation == Orientation.LEFT ? delta.getType().equals((Object)Delta.TYPE.INSERT) : delta.getType().equals((Object)Delta.TYPE.DELETE);
    }

    private void hightlightChangeInChangedLine(Delta delta) {
        Chunk otherPanelChunk;
        Chunk thisPanelChunk;
        if (this.orientation == Orientation.LEFT) {
            thisPanelChunk = delta.getOriginal();
            otherPanelChunk = delta.getRevised();
        } else {
            otherPanelChunk = delta.getOriginal();
            thisPanelChunk = delta.getRevised();
        }
        String s1 = this.concatenateLines(thisPanelChunk.getLines());
        String s2 = this.concatenateLines(otherPanelChunk.getLines());
        int commonSuffixLength = new Diff_match_patch().diff_commonSuffix(s1, s2);
        int commonPrefixLength = new Diff_match_patch().diff_commonPrefix(s1, s2);
        int startPosition = this.diffNode.getLineEndOffsetPosition(thisPanelChunk.getPosition()) + commonPrefixLength;
        int endPosition = this.diffNode.getLineEndOffsetPosition(thisPanelChunk.getPosition() + thisPanelChunk.size());
        this.highlight(startPosition, endPosition, DiffHighlighter.Layer.SECOND, Colors.changeLighterPainter);
    }

    private String concatenateLines(List<?> lines) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            sb.append(lines.get(i).toString());
        }
        return sb.toString();
    }

    private void highlight(int startPosition, int endPosition, DiffHighlighter.Layer layer, DefaultHighlighter.DefaultHighlightPainter painter) {
        try {
            ((DiffHighlighter)this.getHighlighter()).addHighlight(layer, startPosition, endPosition, painter);
        }
        catch (ClassCastException | BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void removeHighlights() {
        this.getHighlighter().removeAllHighlights();
    }

    static class LineNumberBorder
    extends EmptyBorder {
        private static final int MARGIN = 4;
        private final Color lineColor;
        private final Color background;
        private final Font font;
        private final FilePanel editor;
        private final FontMetrics fm;

        public LineNumberBorder(FilePanel editor) {
            super(0, 24, 0, 0);
            this.editor = editor;
            this.lineColor = new Color(225, 225, 225);
            this.background = new Color(251, 251, 251);
            this.font = new Font("Monospaced", 0, 10);
            this.fm = editor.getFontMetrics(this.font);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.paintBefore(g);
            this.paintAfter(g, 0, this.editor.diffNode.getLines().size());
        }

        public void paintBefore(Graphics g) {
            Rectangle clip = g.getClipBounds();
            g.setColor(this.background);
            g.fillRect(0, clip.y, this.left - 4, clip.y + clip.height);
        }

        public void paintAfter(Graphics g, int startLine, int endLine) {
            Graphics2D g2 = (Graphics2D)g;
            Rectangle clip = g.getClipBounds();
            try {
                Rectangle r1 = this.editor.modelToView(0);
                int yAxis = r1.y;
                int lineHeight = r1.height;
                int heightCorrection = (lineHeight - this.fm.getHeight()) / 2 + 2;
                g.setColor(this.lineColor);
                g.drawLine(this.left - 4, clip.y, this.left - 4, clip.y + clip.height);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setFont(this.font);
                g.setColor(Color.black);
                for (int line = startLine; line <= endLine; ++line) {
                    String lineNumber = line + 1 + "";
                    g.drawString(lineNumber, this.left - this.fm.stringWidth("0") * lineNumber.length() - 1 - 4, (yAxis += lineHeight) - heightCorrection);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    static enum Orientation {
        LEFT,
        RIGHT;

    }
}

