/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.customEditor;

import com.browsersoft.commander.customEditor.FilePanel;
import com.browsersoft.commander.customEditor.java_diff_utils.Delta;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;

public class VerticalSyncScroller {
    private final FilePanel leftFilePanel;
    private final FilePanel rightFilePanel;

    public VerticalSyncScroller(FilePanel leftFilePanel, FilePanel rightFilePanel) {
        this.leftFilePanel = leftFilePanel;
        this.rightFilePanel = rightFilePanel;
    }

    public void scrollToDelta(FilePanel filePanel, Delta delta) {
        this.scrollToLineMoreVisible(filePanel, filePanel.isLeftOriented() ? delta.getOriginal().getPosition() : delta.getRevised().getPosition());
    }

    public void scrollToLineMoreVisible(FilePanel filePanel, int lineNumber) {
        this.scrollToLine(filePanel, lineNumber > 0 ? lineNumber - 1 : 0);
    }

    public void scrollToLine(FilePanel filePanel, int lineNumber) {
        try {
            int lineOffset = filePanel.getDiffNode().getLineEndOffsetPosition(lineNumber);
            Rectangle rect = filePanel.modelToView(lineOffset);
            Point p = rect.getLocation();
            p.x = 0;
            JViewport viewport = filePanel.getScrollPane().getViewport();
            viewport.setViewPosition(p);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

