/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.customEditor.utils;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public final class ImageUtil {
    private static final ImageUtil instance = new ImageUtil();
    private ImageIcon saveButton;
    private ImageIcon transparentSaveButton;
    private ImageIcon selectedPanel;
    private ImageIcon selectedPanelTransparent;

    private ImageUtil() {
    }

    public static ImageIcon getSaveButtonTransparentImage() {
        if (ImageUtil.instance.transparentSaveButton != null) {
            return ImageUtil.instance.transparentSaveButton;
        }
        ImageIcon icon = ImageUtil.getSaveButtonImage();
        ImageUtil.instance.transparentSaveButton = ImageUtil.createTransparentIcon(icon);
        return ImageUtil.instance.transparentSaveButton;
    }

    public static ImageIcon getSaveButtonImage() {
        if (ImageUtil.instance.saveButton != null) {
            return ImageUtil.instance.saveButton;
        }
        ImageUtil.instance.saveButton = ImageUtil.getImage("iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAABzElEQVR42p2TzWoaURiGH0djZzALmxgnokPEjYW69Aa6ygUUF90Wuuqq69I76K4UuugN9AZKu0mlNCnYEAhJC1LJH8aIioMZ25nxzPF0YbGaOC76wlkcDu/Dw+H7ALYB9Z+nEgGU6404vhwQdBoUCgUWJRKJoJRC13UOmi4AD+5vEgNo2i6f949Ijy5xHIewxONx8vk8B8cnfK3uAEwAQz8AoFwuUywWWRYhBK77HSH8f4DZ1Ov10LJSimw2ixz5jAK5GHDTYDwe43kerusuhC41kFIyGAzm3kulUjjANE2SySQAw+EQ3/cxTXOuIKUMB1QPT8mZa0hf4AXBQuWLbj8ccNoZ8PPK5vfwGu1GUSqFGitiUS0coJRiKxHB2ppoG4aBZVn0ej129/Z49e4jzx4/4vxaTTtzOM/zsFI6AA+fvuDJ85d0u136/T5WLkfzqsWH3UPSCe02wBcCOZoMh67rpNfvUizew7bt6RSOhY8W1YjPeGsAb9+8nitnMhkc5xcrxp3pzzuOA7GVW9pR4Me3L58qm6kUF60268akkN9YJbMao9FoUKvV6HQ6tFs2QrisJQze71Rx2mdTUOXveh4BjSXrewacz9y3/wC84d7zl4K4QAAAAABJRU5ErkJggg==");
        return ImageUtil.instance.saveButton;
    }

    public static ImageIcon getSelectedPanelTransparentImage() {
        if (ImageUtil.instance.selectedPanelTransparent != null) {
            return ImageUtil.instance.selectedPanelTransparent;
        }
        ImageIcon icon = ImageUtil.getSelectedPanelImage();
        ImageUtil.instance.selectedPanelTransparent = ImageUtil.createTransparentIcon(icon);
        return ImageUtil.instance.selectedPanelTransparent;
    }

    public static ImageIcon getSelectedPanelImage() {
        if (ImageUtil.instance.selectedPanel != null) {
            return ImageUtil.instance.selectedPanel;
        }
        ImageUtil.instance.selectedPanel = ImageUtil.getImage("iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH1gwfDDIQPORCKwAAAFJJREFUOMtjYKAQMDIwMDC8u9ZAUKGQFnY1LEgK/pNqMYoBJLokhIGBYQ0DAwMDE6VhMGAGCA64C6hsAK5EQhcXIIP/JOBUbCmREZrCMKJqcAMA8UoVZ9dqcbUAAAAASUVORK5CYII=");
        return ImageUtil.instance.selectedPanel;
    }

    private static ImageIcon getImage(String imageBase64) {
        byte[] btDataFile = Base64.getDecoder().decode(imageBase64);
        ImageIcon image = null;
        try {
            BufferedImage bfImage = ImageIO.read(new ByteArrayInputStream(btDataFile));
            image = new ImageIcon(bfImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    private static ImageIcon createTransparentIcon(ImageIcon icon) {
        int transparent = 20;
        return ImageUtil.createIcon(icon, new TransparentFilter(transparent));
    }

    private static synchronized ImageIcon createIcon(ImageIcon icon, ImageFilter filter) {
        if (icon == null) {
            return null;
        }
        FilteredImageSource ip = new FilteredImageSource(icon.getImage().getSource(), filter);
        Image image = Toolkit.getDefaultToolkit().createImage(ip);
        MediaTracker tracker = new MediaTracker(new JPanel());
        tracker.addImage(image, 1);
        try {
            tracker.waitForID(1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
        return new ImageIcon(image);
    }

    private static class TransparentFilter
    extends RGBImageFilter {
        int percent;

        public TransparentFilter(int percent) {
            this.canFilterIndexColorModel = true;
            this.percent = percent;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int alpha = rgb >> 24 & 0xFF;
            alpha = Math.min(255, alpha * this.percent / 100);
            return (rgb & 0xFFFFFF) + (alpha << 24);
        }
    }
}

