/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.form.dialogs;

import com.browsersoft.commander.form.dialogs.SimpleDialog;
import com.browsersoft.commander.form.fields.Field;
import com.browsersoft.commander.form.fields.NumberField;
import java.awt.Frame;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class SimpleNumberDialog
extends SimpleDialog<Integer, JSpinner> {
    public SimpleNumberDialog(Frame parent, String title, String label) {
        super(parent, title, label);
    }

    @Override
    protected Field<Integer, JSpinner> createValueField() {
        return new NumberField();
    }

    public void setMinimum(Integer minimum) {
        Integer value;
        this.getSpinnerNumberModel().setMinimum(minimum);
        if (minimum != null && ((value = (Integer)((JSpinner)this.getValueField().getComponent()).getValue()) == null || value < minimum)) {
            this.getValueField().setValue(minimum);
        }
    }

    public void setMaximum(Integer maximum) {
        Integer value;
        this.getSpinnerNumberModel().setMaximum(maximum);
        if (maximum != null && ((value = (Integer)((JSpinner)this.getValueField().getComponent()).getValue()) == null || value > maximum)) {
            this.getValueField().setValue(maximum);
        }
    }

    public void setStepSize(Integer stepSize) {
        this.getSpinnerNumberModel().setStepSize(stepSize);
    }

    protected SpinnerNumberModel getSpinnerNumberModel() {
        SpinnerModel model = ((JSpinner)this.getValueField().getComponent()).getModel();
        if (model instanceof SpinnerNumberModel) {
            return (SpinnerNumberModel)model;
        }
        SpinnerNumberModel numberModel = new SpinnerNumberModel();
        ((JSpinner)this.getValueField().getComponent()).setModel(numberModel);
        return numberModel;
    }

    public static void main(String[] args) {
        Frame f = new Frame("frame");
        f.setVisible(true);
        SimpleNumberDialog dialog = new SimpleNumberDialog(f, "Test", "Value");
        dialog.setMinimum(1);
        dialog.setStepSize(1);
        dialog.setMaximum(100);
        dialog.setVisible(true);
        System.out.println(dialog.getValue());
    }
}

