/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.form.fields;

import com.browsersoft.commander.form.validators.FieldValidator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public abstract class Field<T, C extends JComponent> {
    private final C component;
    private final List<FieldValidator> validators = new ArrayList<FieldValidator>();
    private Boolean isValid = null;
    private T value = null;
    private String error;

    public Field() {
        this.component = this.createComponent();
    }

    protected abstract C createComponent();

    protected abstract T getComponentValue(C var1);

    protected abstract void setComponentValue(C var1, T var2);

    public void setValue(T value) {
        this.setComponentValue(this.component, value);
    }

    public T getValue() {
        return this.value;
    }

    public C getComponent() {
        return this.component;
    }

    public void validate() {
        T value = this.getComponentValue(this.component);
        for (FieldValidator validator : this.validators) {
            String error = validator.validate(value);
            if (error == null) continue;
            this.isValid = false;
            this.value = null;
            this.error = error;
            return;
        }
        this.isValid = true;
        this.value = value;
        this.error = null;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getError() {
        return this.error;
    }

    public void addValidator(FieldValidator validator) {
        this.validators.add(validator);
    }
}

