/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model;

import com.browsersoft.commander.model.CommanderPlugStorageModel;
import com.browsersoft.commander.model.CommanderPlugStorageModelCollection;

public class CommanderPlugStorageModelChecker
extends Thread {
    private final CommanderPlugStorageModelCollection storages;
    private final int interval;
    private boolean running = true;

    public CommanderPlugStorageModelChecker(CommanderPlugStorageModelCollection storages, int interval) {
        this.storages = storages;
        this.interval = interval;
    }

    @Override
    public void run() {
        long lastTime = System.currentTimeMillis();
        long msInterval = this.interval * 1000;
        while (this.running) {
            boolean changed = false;
            for (int i = 0; i < this.storages.size(); ++i) {
                CommanderPlugStorageModel storage = this.storages.get(i);
                boolean res = storage.checkRemoteUpdates();
                if (!res) continue;
                changed = true;
            }
            if (changed) {
                this.storages.fireStoragesChanged();
            }
            long now = System.currentTimeMillis();
            while (this.running && lastTime + msInterval > now) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
            lastTime = now;
        }
    }

    public void finish() {
        this.running = false;
    }
}

