/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter;

import com.browsersoft.commander.model.Flavour;
import com.browsersoft.commander.model.FlavouredItem;
import com.browsersoft.commander.model.OperationWorkerHandler;
import java.io.InputStream;
import java.io.OutputStream;

public class ActionUtils {
    public static boolean checkAndSetSpecificFlavourType(FlavouredItem item, String mainFlavourType) throws Exception {
        boolean selected = false;
        for (int j = 0; j < item.getNumberOfFlavours(); ++j) {
            Flavour flavour = item.getFlavour(j);
            String flavourType = flavour.getType();
            if (!flavourType.equals(mainFlavourType)) continue;
            item.setSelectedFlavour(j);
            selected = true;
            break;
        }
        return selected;
    }

    public static void inputStreamToOutputStreamWithHandler(InputStream inputStream, OutputStream outputStream, OperationWorkerHandler handler, long size) throws Exception {
        byte[] buffer = new byte[20000];
        int length = 0;
        long suma = 0L;
        while ((length = inputStream.read(buffer)) != -1) {
            int percent;
            outputStream.write(buffer, 0, length);
            if (size <= 0L || handler.operationElementRunning(percent = (int)Math.ceil((double)(suma += (long)length) / (double)size * 100.0))) continue;
            break;
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();
    }

    public static boolean isValidActionDialogInput(String input) {
        return input != null && input.matches("[@\\w+][\\-.@()\\*/ \\w]*");
    }
}

