/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter;

import com.browsersoft.commander.model.CommanderPlugModelHandler;
import com.browsersoft.commander.model.SearchProgressHandler;
import com.browsersoft.commander.model.adapter.ActionResolver;
import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.AdapterItemCollection;
import com.browsersoft.commander.model.adapter.AdapterItemComparator;
import com.browsersoft.commander.model.adapter.AdapterPath;
import com.browsersoft.commander.model.adapter.ColumnResolver;
import com.browsersoft.commander.model.adapter.CommanderAdapter;
import com.browsersoft.commander.model.adapter.ItemDefaultRenderer;
import com.browsersoft.commander.model.adapter.NullComparator;
import com.browsersoft.commander.model.adapter.RedirectAdapterItem;
import com.browsersoft.commander.model.adapter.SearchResultAdapter;
import com.browsersoft.commander.model.adapter.SearchRootAdapterItem;
import com.browsersoft.commander.model.plugin.Plugin;
import com.browsersoft.commander.model.plugin.PluginCollection;
import com.browsersoft.commander.model.plugin.PublicType;
import com.browsersoft.commander.model.plugin.PublicTypeCollection;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AdapterItemsWrapper {
    private AdapterItemCollection items;
    private AdapterPath path;
    private CommanderAdapter adapter;
    private ColumnResolver resolver;
    private ActionResolver actionResolver;
    private PluginCollection plugins;

    public AdapterItemsWrapper(AdapterItemCollection items, AdapterPath path, CommanderAdapter adapter, PluginCollection plugins) throws Exception {
        AdapterItemsWrapper.setSourceAdapterToCollection(items, adapter);
        this.plugins = plugins;
        this.items = items;
        this.adapter = adapter;
        this.path = path;
        items.useComparator(items.getComparatorForColumnCreating());
        this.resolver = new ColumnResolver(items);
        this.actionResolver = new ActionResolver(items.getActions(), items, path);
        this.sortColumn(1, true);
    }

    public AdapterItem getItem(int index) {
        int i = 0;
        i = this.path.size() > 1 ? index - 1 : index;
        if (i < 0 || i > this.items.size() - 1) {
            return null;
        }
        return this.items.get(i);
    }

    public int getIndexOfItemStartWith(String text) {
        text = text.toLowerCase();
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).getName().toLowerCase().startsWith(text)) continue;
            if (this.path.size() > 1) {
                return i + 1;
            }
            return i;
        }
        return -1;
    }

    public int getSize() {
        if (this.path.size() > 1) {
            return this.items.size() + 1;
        }
        return this.items.size();
    }

    public void reload() throws Exception {
        this.items = this.callGo();
        this.afterCallGo();
    }

    public void home() throws Exception {
        if (this.path.size() > 0) {
            AdapterItem adapterItem = this.path.get(0);
            this.path.clear();
            this.path.add(adapterItem);
            this.items = this.callGo();
            this.afterCallGo();
        }
    }

    private void afterCallGo() throws Exception {
        this.actionResolver = new ActionResolver(this.items.getActions(), this.items, this.path);
        this.items.useComparator(this.items.getComparatorForColumnCreating());
        this.resolver = new ColumnResolver(this.items);
        this.sortColumn(1, true);
    }

    public String getContextLabel() {
        return this.items.getContextLabel();
    }

    public Exception getContextLabelError() {
        return this.items.getContextLabelError();
    }

    public void search(String text, SearchProgressHandler searchHandler, CommanderPlugModelHandler handler) throws Exception {
        CommanderAdapter source = this.getAdapter();
        this.items = source.search(this.path, text, searchHandler);
        if (this.items != null) {
            if (this.items.isNoSearch()) {
                AdapterItemsWrapper.setSourceAdapterToCollection(this.items, source);
                this.afterCallGo();
            } else {
                AdapterItem adapterItem = this.path.get(0);
                this.path.clear();
                this.path.add(adapterItem);
                SearchRootAdapterItem searchAdapterItem = new SearchRootAdapterItem();
                searchAdapterItem.setName("Search result [" + text + "]");
                SearchResultAdapter resultAdapter = new SearchResultAdapter(this.items, handler);
                AdapterItemsWrapper.setSourceAdapterToCollection(this.items, source);
                this.items = resultAdapter.getOriginalItems();
                AdapterItemsWrapper.setSourceAdapterToCollection(this.items, resultAdapter);
                searchAdapterItem.setSourceAdapter(resultAdapter);
                this.path.add(searchAdapterItem);
                this.afterCallGo();
            }
        }
    }

    private boolean isPathAfterSearching() {
        if (this.path.size() > 1) {
            return this.path.get(1) instanceof SearchRootAdapterItem;
        }
        return false;
    }

    private CommanderAdapter getAdapter() {
        if (this.path.size() == 0) {
            return this.adapter;
        }
        return this.path.getLast().getSourceAdapter();
    }

    private AdapterItemCollection callGo() throws Exception {
        CommanderAdapter source = this.getAdapter();
        AdapterItemCollection collection = source.go(this.path.getSubPathForSource(source));
        if (collection == null) {
            collection = this.solvePlugins();
        } else {
            AdapterItem item;
            if (collection.size() == 1 && (item = collection.get(0)) instanceof RedirectAdapterItem) {
                RedirectAdapterItem redirectAdapterItem = (RedirectAdapterItem)item;
                AdapterItem newItem = redirectAdapterItem.getRedirectTo();
                this.path.removeLast();
                this.path.add(newItem);
                return this.callGo();
            }
            AdapterItemsWrapper.setSourceAdapterToCollection(collection, source);
        }
        return collection;
    }

    private AdapterItemCollection solvePlugins() throws Exception {
        if (this.path.size() > 0) {
            AdapterItem adapterItem = this.path.getLast();
            PublicTypeCollection publicTypeCollection = adapterItem.getPublicTypeCollection();
            for (int i = 0; i < this.plugins.size(); ++i) {
                Plugin plugin = this.plugins.get(i);
                if (publicTypeCollection == null) continue;
                for (int j = 0; j < publicTypeCollection.size(); ++j) {
                    PublicType publicType = publicTypeCollection.get(j);
                    CommanderAdapter commanderAdapter = plugin.checkType(publicType);
                    if (commanderAdapter == null) continue;
                    commanderAdapter.setDocumentManager(this.adapter.getDocumentManager());
                    commanderAdapter.setErrorNotifier(this.adapter.getErrorNotifier());
                    AdapterItemCollection collection = commanderAdapter.go(this.path.getSubPathForSource(commanderAdapter));
                    AdapterItemsWrapper.setSourceAdapterToCollection(collection, commanderAdapter);
                    return collection;
                }
            }
        }
        return null;
    }

    public static void setSourceAdapterToCollection(AdapterItemCollection collection, CommanderAdapter commanderAdapter) {
        if (collection != null) {
            for (int k = 0; k < collection.size(); ++k) {
                collection.get(k).setSourceAdapter(commanderAdapter);
            }
        }
    }

    public int goInto(String id) throws Exception {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).getId().equals(id)) continue;
            if (this.path.size() > 1) {
                return this.goInto(i + 1);
            }
            return this.goInto(i);
        }
        throw new Exception("Invalid id \"" + id + "\"");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int goInto(int index) throws Exception {
        AdapterItemCollection newItems = null;
        if (this.path.size() > 1) {
            if (index == 0) {
                AdapterItem item = this.path.removeLast();
                newItems = this.callGo();
                if (newItems == null) return -1;
                this.items = newItems;
                this.actionResolver = new ActionResolver(this.items.getActions(), this.items, this.path);
                this.items.useComparator(this.items.getComparatorForColumnCreating());
                this.resolver = new ColumnResolver(this.items);
                this.sortColumn(1, true);
                int indexOfItem = this.items.getIndexOfItemWithSameId(item);
                if (indexOfItem <= 0) return 0;
                if (this.path.size() <= 1) return indexOfItem;
                return indexOfItem + 1;
            }
            AdapterItem item = this.items.get(index - 1);
            this.path.add(item);
            try {
                newItems = this.callGo();
            }
            catch (Exception e) {
                this.path.remove(this.path.size() - 1);
                throw e;
            }
            if (newItems != null) {
                this.items = newItems;
                this.actionResolver = new ActionResolver(this.items.getActions(), this.items, this.path);
                this.items.useComparator(this.items.getComparatorForColumnCreating());
                this.resolver = new ColumnResolver(this.items);
                this.sortColumn(1, true);
                return 0;
            }
            this.path.removeLast();
            return -1;
        }
        AdapterItem item = this.items.get(index);
        this.path.add(item);
        newItems = this.callGo();
        if (newItems != null) {
            this.items = newItems;
            this.actionResolver = new ActionResolver(this.items.getActions(), this.items, this.path);
            this.items.useComparator(this.items.getComparatorForColumnCreating());
            this.resolver = new ColumnResolver(this.items);
            this.sortColumn(1, true);
            return 0;
        }
        this.path.removeLast();
        return -1;
    }

    public int getInitColumnSize(int index) {
        switch (index) {
            case 0: {
                return 20;
            }
            case 1: {
                return 200;
            }
        }
        return this.resolver.getColumnInitSize(index - 2);
    }

    public void sortColumn(int index, boolean ascendent) throws Exception {
        Comparator defaultComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    return ((String)o1).toLowerCase().compareTo(((String)o2).toLowerCase());
                }
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return 0;
            }
        };
        if (index > 0) {
            Comparator c = defaultComparator;
            if (this.items.getComparatorForName() != null) {
                c = this.items.getComparatorForName();
            }
            if (index > 1 && !((c = this.resolver.getColumnComparator(index - 2)) instanceof NullComparator) && c == null) {
                c = defaultComparator;
            }
            AdapterItemComparator comparator = new AdapterItemComparator(this.items.getComparator(), c, ascendent, this.resolver, index);
            this.items.useComparator(comparator);
        }
    }

    public TableCellEditor getTableEditor(int rowIndex, int columnIndex) throws Exception {
        switch (columnIndex) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return this.resolver.getColumnEditor(columnIndex - 2, this.getItem(rowIndex));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TableCellRenderer getTableRenderer(int rowIndex, int columnIndex) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        AdapterItem item;
        if (this.path.size() > 1) {
            if (rowIndex <= 0) return null;
            item = this.items.get(rowIndex - 1);
        } else {
            item = this.items.get(rowIndex);
        }
        TableCellRenderer customRenderer = null;
        ItemDefaultRenderer itemDefaultRenderer = item.getClass().getAnnotation(ItemDefaultRenderer.class);
        if (itemDefaultRenderer != null) {
            Class clazz = itemDefaultRenderer.value();
            Constructor<?> constructor = clazz.getConstructors()[0];
            Object[] params = new Object[]{item};
            customRenderer = (TableCellRenderer)constructor.newInstance(params);
        }
        switch (columnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                if (customRenderer == null) return null;
                return customRenderer;
            }
        }
        return this.resolver.getColumnRenderer(columnIndex - 2, item, customRenderer);
    }

    public int getRowCount() {
        if (this.path.size() > 1) {
            return this.items.size() + 1;
        }
        return this.items.size();
    }

    public int getColumnCount() {
        return 2 + this.resolver.getSize();
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return "Name";
            }
        }
        return this.resolver.getColumnName(columnIndex - 2);
    }

    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Icon.class;
            }
            case 1: {
                return String.class;
            }
        }
        return this.resolver.getColumnClass(columnIndex - 2);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) throws Exception {
        switch (columnIndex) {
            case 0: 
            case 1: {
                return false;
            }
        }
        return this.resolver.getColumnEditor(columnIndex - 2, this.getItem(rowIndex)) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object getValueAt(int index, int column) throws Exception {
        AdapterItem item;
        block8: {
            item = null;
            if (this.path.size() > 1) {
                if (index > 0) {
                    item = this.items.get(index - 1);
                    break block8;
                } else {
                    if (column == 1) {
                        return "..";
                    }
                    return null;
                }
            }
            item = this.items.get(index);
        }
        switch (column) {
            case 0: {
                return item.getIcon();
            }
            case 1: {
                return item.getName();
            }
        }
        return this.resolver.getValueForColumn(column - 2, item);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AdapterItem item = null;
        if (this.path.size() > 1) {
            if (rowIndex > 0) {
                item = this.items.get(rowIndex - 1);
            }
        } else {
            item = this.items.get(rowIndex);
        }
        if (item != null) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    this.resolver.setValueForColumn(columnIndex - 2, item, aValue);
                }
            }
        }
    }

    public ActionResolver getActionResolver() {
        return this.actionResolver;
    }

    public void setActionResolver(ActionResolver actionResolver) {
        this.actionResolver = actionResolver;
    }

    public PluginCollection getPlugins() {
        return this.plugins;
    }

    public void setPlugins(PluginCollection plugins) {
        this.plugins = plugins;
    }
}

