/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter;

import com.browsersoft.commander.model.CommanderPlugModel;
import com.browsersoft.commander.model.CommanderPlugStorage;
import com.browsersoft.commander.model.CommanderPlugStorageModel;
import com.browsersoft.commander.model.DocumentManager;
import com.browsersoft.commander.model.adapter.AdapterItemCollection;
import com.browsersoft.commander.model.adapter.AdapterItemsWrapper;
import com.browsersoft.commander.model.adapter.AdapterLayer;
import com.browsersoft.commander.model.adapter.AdapterPath;
import com.browsersoft.commander.model.adapter.CommanderAdapter;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;

public class AdapterStorage
implements CommanderPlugStorageModel {
    private CommanderAdapter adapter;
    private DocumentManager documentManager;
    private AdapterItemCollection discs;
    private CommanderPlugStorage commanderPlugStorage;
    private String profileName;

    public AdapterStorage(CommanderAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public CommanderPlugModel createNewModel() throws Exception {
        AdapterLayer al = new AdapterLayer(this.adapter);
        al.setParentModelStorage(this);
        return al;
    }

    @Override
    public JMenu getMenu(String name) {
        return this.adapter.getMenu(name);
    }

    @Override
    public void connect() throws Exception {
        this.adapter.connect();
        this.discs = this.adapter.go(new AdapterPath());
        AdapterItemsWrapper.setSourceAdapterToCollection(this.discs, this.adapter);
    }

    @Override
    public void disconnect() throws Exception {
        this.adapter.disconnect();
    }

    @Override
    public boolean checkRemoteUpdates() {
        return this.adapter.checkRemoteUpdates();
    }

    @Override
    public boolean hasRemoteUpdates() {
        return this.adapter.hasRemoteUpdates();
    }

    @Override
    public void profilesChanged(List<CommanderAdapter> otherAdapters) throws Exception {
        this.adapter.profilesChanged(otherAdapters);
    }

    @Override
    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    @Override
    public void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
        this.adapter.setDocumentManager(documentManager);
    }

    @Override
    public int getDiscsSize() {
        return this.discs.size();
    }

    @Override
    public String getDiscName(int index) {
        return this.discs.get(index).getName();
    }

    @Override
    public String getDiscId(int index) {
        return this.discs.get(index).getId();
    }

    @Override
    public String getDiscDescription(int index) {
        return this.discs.get(index).getName();
    }

    @Override
    public Icon getDiscIcon(int index) {
        return this.discs.get(index).getIcon();
    }

    @Override
    public Object getDisc(int index) {
        return this.discs.get(index);
    }

    @Override
    public int getInitialDisc() {
        return this.discs.getInitIndex();
    }

    @Override
    public CommanderPlugStorage getParentStorage() {
        return this.commanderPlugStorage;
    }

    @Override
    public void setParentStorage(CommanderPlugStorage commanderPlugStorage) {
        this.commanderPlugStorage = commanderPlugStorage;
        this.adapter.setErrorNotifier(commanderPlugStorage.getErrorNotifier());
    }

    @Override
    public String getProfileName() {
        return this.profileName;
    }

    @Override
    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public CommanderAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(CommanderAdapter adapter) {
        this.adapter = adapter;
    }
}

