/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter;

import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.ClassCollection;
import com.browsersoft.commander.model.adapter.Column;
import com.browsersoft.commander.model.adapter.ColumnClass;
import com.browsersoft.commander.model.adapter.ColumnComparator;
import com.browsersoft.commander.model.adapter.ColumnName;
import com.browsersoft.commander.model.adapter.ColumnPosition;
import com.browsersoft.commander.model.adapter.ColumnResizable;
import com.browsersoft.commander.model.adapter.ColumnSize;
import com.browsersoft.commander.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.Comparator;

public class ColumnItem {
    private String name;
    private String nameOfProperty;
    private ClassCollection classes = new ClassCollection();
    private Comparator comparator;
    private int initSize = 100;
    private boolean resizable = true;
    private boolean visible = false;
    private int position = 0;
    private Class columnClass;
    private String nameOfGetMethod;
    private Method method;

    public ColumnItem(Method method, String nameOfProperty, AdapterItem item) throws Exception {
        ColumnPosition columnPosition;
        ColumnResizable columnResizable;
        ColumnSize columnInitSize;
        ColumnName columnName;
        this.method = method;
        this.nameOfProperty = nameOfProperty;
        this.nameOfGetMethod = method.getName();
        this.classes.add(item.getClass());
        ColumnClass columnClassAnnotation = method.getAnnotation(ColumnClass.class);
        this.columnClass = columnClassAnnotation != null ? columnClassAnnotation.value() : ReflectionUtils.getWrappedClass(method.getReturnType());
        Column column = method.getAnnotation(Column.class);
        if (column != null) {
            this.visible = true;
        }
        if ((columnName = method.getAnnotation(ColumnName.class)) != null) {
            this.name = columnName.value();
            this.visible = true;
        } else {
            this.name = nameOfProperty;
        }
        ColumnComparator columnComparator = method.getAnnotation(ColumnComparator.class);
        if (columnComparator != null) {
            this.comparator = (Comparator)columnComparator.value().newInstance();
            this.visible = true;
        }
        if ((columnInitSize = method.getAnnotation(ColumnSize.class)) != null) {
            this.initSize = columnInitSize.value();
            this.visible = true;
        }
        if ((columnResizable = method.getAnnotation(ColumnResizable.class)) != null) {
            this.resizable = columnResizable.value();
            this.visible = true;
        }
        if ((columnPosition = method.getAnnotation(ColumnPosition.class)) != null) {
            this.position = columnPosition.value();
            this.visible = true;
        }
    }

    public String getNameOfSetMethod() {
        return "set" + this.getJustNameOfMethod();
    }

    public String getNameOfGetEditorMethod() {
        return "get" + this.getJustNameOfMethod() + "Editor";
    }

    private String getJustNameOfMethod() {
        if (this.nameOfGetMethod.startsWith("get")) {
            return this.nameOfGetMethod.substring(3);
        }
        if (this.nameOfGetMethod.startsWith("is")) {
            return this.nameOfGetMethod.substring(2);
        }
        return this.nameOfGetMethod;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof ColumnItem)) {
            return false;
        }
        ColumnItem obC = (ColumnItem)ob;
        return obC.getName().equals(this.name);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Name:" + this.name + "\n");
        buffer.append("columnClass:" + this.columnClass + "\n");
        buffer.append("comparator:" + this.comparator + "\n");
        buffer.append("initSize:" + this.initSize + "\n");
        buffer.append("resizable:" + this.resizable + "\n");
        buffer.append("position:" + this.position + "\n");
        return buffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClassCollection getClasses() {
        return this.classes;
    }

    public void setClasses(ClassCollection classes) {
        this.classes = classes;
    }

    public String getNameOfProperty() {
        return this.nameOfProperty;
    }

    public void setNameOfProperty(String nameOfProperty) {
        this.nameOfProperty = nameOfProperty;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public int getInitSize() {
        return this.initSize;
    }

    public void setInitSize(int initSize) {
        this.initSize = initSize;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public Class getColumnClass() {
        return this.columnClass;
    }

    public void setColumnClass(Class columnClass) {
        this.columnClass = columnClass;
    }

    public String getNameOfGetMethod() {
        return this.nameOfGetMethod;
    }

    public void setNameOfGetMethod(String nameOfGetMethod) {
        this.nameOfGetMethod = nameOfGetMethod;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }
}

