/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter;

import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.AdapterItemCollection;
import com.browsersoft.commander.model.adapter.AdapterTableCellEditor;
import com.browsersoft.commander.model.adapter.ColumnCollection;
import com.browsersoft.commander.model.adapter.ColumnEditor;
import com.browsersoft.commander.model.adapter.ColumnItem;
import com.browsersoft.commander.model.adapter.ColumnRenderer;
import com.browsersoft.commander.model.adapter.Editable;
import com.browsersoft.commander.model.adapter.editor.BooleanEditor;
import com.browsersoft.commander.model.adapter.editor.StringEditor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ColumnResolver {
    private ColumnCollection columns = new ColumnCollection();

    public ColumnResolver(AdapterItemCollection collection) throws Exception {
        for (int i = 0; i < collection.size(); ++i) {
            AdapterItem item = collection.get(i);
            if (this.columns.classSomewhereInside(item.getClass())) continue;
            PropertyDescriptor[] properties = this.getObjectGetSetProperties(item.getClass());
            ArrayList<ColumnItem> infos = new ArrayList<ColumnItem>();
            for (PropertyDescriptor property : properties) {
                ColumnItem info;
                if (property.getReadMethod() == null || !(info = new ColumnItem(property.getReadMethod(), property.getName(), item)).isVisible()) continue;
                infos.add(info);
            }
            Collections.sort(infos, new Comparator(){

                public int compare(Object o1, Object o2) {
                    ColumnItem c1 = (ColumnItem)o1;
                    ColumnItem c2 = (ColumnItem)o2;
                    if (c1.getPosition() < c2.getPosition()) {
                        return -1;
                    }
                    if (c1.getPosition() > c2.getPosition()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (ColumnItem info : infos) {
                ColumnItem sameColumn = this.columns.sameColumnSomewhereInside(info);
                if (sameColumn != null) {
                    sameColumn.getClasses().add(item.getClass());
                    continue;
                }
                this.columns.add(info);
            }
        }
    }

    public int getSize() {
        return this.columns.size();
    }

    public String getColumnName(int index) {
        return this.columns.get(index).getName();
    }

    public int getColumnInitSize(int index) {
        return this.columns.get(index).getInitSize();
    }

    public boolean isColumnResizable(int index) {
        return this.columns.get(index).isResizable();
    }

    public Class getColumnClass(int index) {
        return this.columns.get(index).getColumnClass();
    }

    public TableCellRenderer getColumnRenderer(int columnIndex, AdapterItem item, TableCellRenderer customRenderer) throws IllegalAccessException, InstantiationException {
        ColumnRenderer columnRenderer;
        ColumnItem column = this.columns.get(columnIndex);
        if (column.getClasses().isInside(item.getClass()) && (columnRenderer = column.getMethod().getAnnotation(ColumnRenderer.class)) != null) {
            Class columnRendererClass = columnRenderer.value();
            try {
                Constructor constructor = columnRendererClass.getConstructor(AdapterItem.class);
                return (TableCellRenderer)constructor.newInstance(item);
            }
            catch (Exception exception) {
                return (TableCellRenderer)columnRendererClass.newInstance();
            }
        }
        if (customRenderer != null) {
            return customRenderer;
        }
        return null;
    }

    public TableCellEditor getColumnEditor(int columnIndex, AdapterItem item) throws Exception {
        ColumnEditor columnEditor;
        Method method;
        Editable editable;
        ColumnItem column = this.columns.get(columnIndex);
        if (column.getClasses().isInside(item.getClass()) && (editable = (method = item.getClass().getMethod(column.getNameOfGetMethod(), new Class[0])).getAnnotation(Editable.class)) != null && (columnEditor = this.resolveColumnEditor(item, column)) != null) {
            columnEditor.setEditorValue(method.invoke((Object)item, (Object[])new Class[0]));
            return new AdapterTableCellEditor(columnEditor);
        }
        return null;
    }

    private ColumnEditor resolveColumnEditor(AdapterItem item, ColumnItem column) throws Exception {
        try {
            Method methodOfEditor = item.getClass().getMethod(column.getNameOfGetEditorMethod(), new Class[0]);
            Object ret = methodOfEditor.invoke((Object)item, new Object[0]);
            if (!(ret instanceof ColumnEditor)) {
                throw new Exception("Method \"" + column.getNameOfGetEditorMethod() + "\" must return ColumnEditor ");
            }
            return (ColumnEditor)ret;
        }
        catch (NoSuchMethodException e) {
            return this.getDefaultEditorForType(item.getClass().getMethod(column.getNameOfGetMethod(), new Class[0]));
        }
    }

    private ColumnEditor getDefaultEditorForType(Method methodOfEditor) {
        Class<?> aClass = methodOfEditor.getReturnType();
        if (aClass.equals(String.class)) {
            return new StringEditor(methodOfEditor);
        }
        if (aClass.getName().equals("boolean")) {
            return new BooleanEditor();
        }
        return null;
    }

    public Comparator getColumnComparator(int index) {
        return this.columns.get(index).getComparator();
    }

    public Object getValueForColumn(int index, AdapterItem item) throws Exception {
        ColumnItem column = this.columns.get(index);
        if (column.getClasses().isInside(item.getClass())) {
            Method method = item.getClass().getMethod(column.getNameOfGetMethod(), new Class[0]);
            return method.invoke((Object)item, new Object[0]);
        }
        return null;
    }

    public void setValueForColumn(int index, AdapterItem item, Object value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ColumnItem column = this.columns.get(index);
        if (column.getClasses().isInside(item.getClass())) {
            Method methodGet = item.getClass().getMethod(column.getNameOfGetMethod(), new Class[0]);
            Class[] params = new Class[]{methodGet.getReturnType()};
            Method methodSet = item.getClass().getMethod(column.getNameOfSetMethod(), params);
            Object[] paramsObjects = new Object[]{value};
            methodSet.invoke((Object)item, paramsObjects);
        }
    }

    private PropertyDescriptor[] getObjectGetSetProperties(Class clazz) throws IntrospectionException {
        BeanInfo bi = Introspector.getBeanInfo(clazz);
        return bi.getPropertyDescriptors();
    }
}

