/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter.renderer;

import com.browsersoft.commander.model.adapter.AdapterItem;
import java.awt.Component;
import java.text.SimpleDateFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DateCellRenderer
extends DefaultTableCellRenderer {
    private final AdapterItem item;

    public DateCellRenderer(AdapterItem item) {
        this.item = item;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String newValue = "";
        if (value != null) {
            String dateFormat = "MM/dd/yyyy HH:mm";
            try {
                dateFormat = this.item.getSourceAdapter().getDocumentManager().getCommanderSettings().getDateFormat();
            }
            catch (Exception exception) {
                // empty catch block
            }
            newValue = new SimpleDateFormat(dateFormat).format((Long)value).toString();
        }
        Component theComponent = super.getTableCellRendererComponent(table, newValue, isSelected, hasFocus, row, column);
        theComponent.setFont(theComponent.getFont().deriveFont(2));
        return theComponent;
    }
}

