/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.model.adapter.renderer;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class SpacedNumberCellRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String newValue = "";
        if (value != null) {
            newValue = this.getSpacedSize(String.valueOf(value)) + " ";
        }
        Component theComponent = super.getTableCellRendererComponent(table, newValue, isSelected, hasFocus, row, column);
        return theComponent;
    }

    @Override
    public int getHorizontalAlignment() {
        return 4;
    }

    private String getSpacedSize(String size) {
        StringBuffer ret = new StringBuffer();
        int len = size.length();
        int mod = len % 3;
        if (mod != 0) {
            ret.append(size.substring(0, mod));
            ret.append(" ");
        }
        for (int i = mod; i < size.length(); i += 3) {
            ret.append(size.substring(i, i + 3));
            ret.append(" ");
        }
        return ret.toString().trim();
    }
}

