/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils;

import com.browsersoft.commander.utils.Logger;
import java.util.GregorianCalendar;

public class ConsoleLogger
implements Logger {
    private static String padZeros(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return "" + n;
    }

    public static void log(String level, String msg) {
        GregorianCalendar calendar = new GregorianCalendar();
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        String timeStr = "[" + ConsoleLogger.padZeros(hour) + ":" + ConsoleLogger.padZeros(minute) + ":" + ConsoleLogger.padZeros(second) + "]";
        System.out.println(timeStr + " " + level + ": " + msg);
    }

    @Override
    public void info(String message) {
        ConsoleLogger.log("INFO", message);
    }

    @Override
    public void debug(String message) {
        ConsoleLogger.log("DEBUG", message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.error(message);
        t.printStackTrace();
    }

    @Override
    public void error(String message) {
        ConsoleLogger.log("ERROR", message);
    }

    @Override
    public void warn(String message) {
        ConsoleLogger.log("WARN", message);
    }
}

