/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils;

import com.browsersoft.commander.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpUtils {
    public static String openURL(String URL2, boolean debug) throws IOException {
        try {
            if (debug) {
                System.out.println("Opening URL:" + URL2);
            }
            URL myCM = new URL(URL2);
            HttpURLConnection connection = (HttpURLConnection)myCM.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 7.0b; Windows NT 6.0)");
            InputStream inputStream = connection.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamUtils.inputStreamToOutputStream(inputStream, byteArrayOutputStream);
            inputStream.close();
            connection.disconnect();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (Exception e) {
            if (debug) {
                System.out.println("Error");
            }
            throw new IOException(e);
        }
    }

    public static String postData(String urlstr, String parameters) throws IOException {
        URL url = new URL(urlstr);
        HttpURLConnection hpcon = null;
        try {
            String input;
            hpcon = (HttpURLConnection)url.openConnection();
            hpcon.setRequestMethod("POST");
            hpcon.addRequestProperty("Content-Type", "text/xml;charset=UTF-8");
            hpcon.setRequestProperty("Content-Length", Integer.toString(parameters.getBytes("UTF-8").length));
            hpcon.setDoOutput(true);
            OutputStream out = hpcon.getOutputStream();
            out.write(parameters.getBytes("UTF-8"));
            out.flush();
            out.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(hpcon.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((input = in.readLine()) != null) {
                response.append(input).append("\r");
            }
            String string = response.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error");
            throw new IOException(e.getMessage());
        }
        finally {
            if (hpcon != null) {
                hpcon.disconnect();
            }
        }
    }

    public static void trustAllHttpsCertificates() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[1];
        miTM tm = new miTM();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    public static class miTM
    implements TrustManager,
    X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

