/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ReflectionUtils {
    public static List<Method> getMethodsWithSpecificAnotation(Class clazz, Class anotationClass) {
        ArrayList<Method> ret = new ArrayList<Method>();
        ReflectionUtils.addMethodsRecursive(clazz, ret, anotationClass);
        return ret;
    }

    private static void addMethodsRecursive(Class clazz, List<Method> ret, Class anotationClass) {
        Method[] methods = clazz.getMethods();
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtils.addMethodsRecursive(superClass, ret, anotationClass);
        }
        for (Method method : methods) {
            if (method.getAnnotation(anotationClass) == null) continue;
            ret.add(method);
        }
    }

    public static List<Field> getDeclaredFieldsWithSpecificAnotation(Class clazz, Class anotationClass) {
        ArrayList<Field> ret = new ArrayList<Field>();
        ReflectionUtils.addFieldsRecursive(clazz, ret, anotationClass);
        return ret;
    }

    private static void addFieldsRecursive(Class clazz, List<Field> ret, Class anotationClass) {
        Field[] fields = clazz.getDeclaredFields();
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtils.addFieldsRecursive(superClass, ret, anotationClass);
        }
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.getAnnotation(anotationClass) == null) continue;
            ret.add(field);
        }
    }

    public static Class getWrappedClass(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz.getName().equals("boolean")) {
                return Boolean.class;
            }
            if (clazz.getName().equals("byte")) {
                return Byte.class;
            }
            if (clazz.getName().equals("char")) {
                return Character.class;
            }
            if (clazz.getName().equals("double")) {
                return Double.class;
            }
            if (clazz.getName().equals("float")) {
                return Float.class;
            }
            if (clazz.getName().equals("int")) {
                return Integer.class;
            }
            if (clazz.getName().equals("long")) {
                return Long.class;
            }
            if (clazz.getName().equals("short")) {
                return Short.class;
            }
            if (clazz.getName().equals("void")) {
                return Void.class;
            }
        }
        return clazz;
    }
}

